/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.Memory;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.item.Item;
import net.minecraft.item.ShootableItem;
import net.minecraft.util.math.EntityPosWrapper;

public final class BrainUtils {
    public static <T> T memoryOrDefault(LivingEntity entity, MemoryModuleType<T> memory, Supplier<T> fallback) {
        return BrainUtils.memoryOrDefault(entity.func_213375_cj(), memory, fallback);
    }

    public static <T> T memoryOrDefault(Brain<?> brain, MemoryModuleType<T> memory, Supplier<T> fallback) {
        return brain.func_218207_c(memory).orElseGet(fallback);
    }

    @Nullable
    public static <T> T getMemory(LivingEntity entity, MemoryModuleType<T> memory) {
        return BrainUtils.getMemory(entity.func_213375_cj(), memory);
    }

    @Nullable
    public static <T> T getMemory(Brain<?> brain, MemoryModuleType<T> memory) {
        return (T)BrainUtils.memoryOrDefault(brain, memory, () -> null);
    }

    public static <T> void withMemory(LivingEntity entity, MemoryModuleType<T> memory, Consumer<T> consumer) {
        BrainUtils.withMemory(entity.func_213375_cj(), memory, consumer);
    }

    public static <T> void withMemory(Brain<?> brain, MemoryModuleType<T> memory, Consumer<T> consumer) {
        brain.func_218207_c(memory).ifPresent(consumer);
    }

    public static boolean hasMemory(LivingEntity entity, MemoryModuleType<?> memory) {
        return BrainUtils.hasMemory(entity.func_213375_cj(), memory);
    }

    public static boolean hasMemory(Brain<?> brain, MemoryModuleType<?> memory) {
        return brain.func_218191_a(memory);
    }

    public static long getTimeUntilMemoryExpires(LivingEntity entity, MemoryModuleType<?> memory) {
        return BrainUtils.getTimeUntilMemoryExpires(entity.func_213375_cj(), memory);
    }

    public static long getTimeUntilMemoryExpires(Brain<?> brain, MemoryModuleType<?> memory) {
        Memory mem;
        Object object;
        long result = 0L;
        Optional opt = brain.func_218207_c(memory);
        if (opt.isPresent() && (object = opt.get()) instanceof Memory && (mem = (Memory)object).func_234074_e_()) {
            result = mem.field_234063_b_;
        }
        return result;
    }

    public static <T> void setMemory(LivingEntity entity, MemoryModuleType<T> memoryType, T memory) {
        BrainUtils.setMemory(entity.func_213375_cj(), memoryType, memory);
    }

    public static <T> void setMemory(Brain<?> brain, MemoryModuleType<T> memoryType, T memory) {
        brain.func_218205_a(memoryType, memory);
    }

    public static <T> void setForgettableMemory(LivingEntity entity, MemoryModuleType<T> memoryType, T memory, int expirationTicks) {
        BrainUtils.setForgettableMemory(entity.func_213375_cj(), memoryType, memory, expirationTicks);
    }

    public static <T> void setForgettableMemory(Brain<?> brain, MemoryModuleType<T> memoryType, T memory, int expirationTicks) {
        brain.func_233696_a_(memoryType, memory, (long)expirationTicks);
    }

    public static void clearMemory(LivingEntity entity, MemoryModuleType<?> memory) {
        BrainUtils.clearMemory(entity.func_213375_cj(), memory);
    }

    public static void clearMemory(Brain<?> brain, MemoryModuleType<?> memory) {
        brain.func_218189_b(memory);
    }

    public static void clearMemories(LivingEntity entity, MemoryModuleType<?> ... memories) {
        BrainUtils.clearMemories(entity.func_213375_cj(), memories);
    }

    public static void clearMemories(Brain<?> brain, MemoryModuleType<?> ... memories) {
        for (MemoryModuleType<?> memory : memories) {
            brain.func_218189_b(memory);
        }
    }

    @Nullable
    public static LivingEntity getTargetOfEntity(LivingEntity entity) {
        return BrainUtils.getTargetOfEntity(entity, null);
    }

    @Nullable
    public static LivingEntity getTargetOfEntity(LivingEntity entity, @Nullable LivingEntity fallback) {
        return BrainUtils.memoryOrDefault(entity.func_213375_cj(), MemoryModuleType.field_234103_o_, () -> fallback);
    }

    @Nullable
    public static LivingEntity getLastAttacker(LivingEntity entity) {
        return (LivingEntity)BrainUtils.memoryOrDefault(entity, MemoryModuleType.field_220958_s, null);
    }

    public static void setTargetOfEntity(LivingEntity entity, @Nullable LivingEntity target) {
        if (entity instanceof MobEntity) {
            ((MobEntity)entity).func_70624_b(target);
        }
        if (target == null) {
            BrainUtils.clearMemory(entity, MemoryModuleType.field_234103_o_);
        } else {
            BrainUtils.setMemory(entity, MemoryModuleType.field_234103_o_, target);
        }
    }

    public static void lookAtEntity(LivingEntity entity, LivingEntity target) {
        entity.func_213375_cj().func_218205_a(MemoryModuleType.field_220951_l, (Object)new EntityPosWrapper((Entity)target, true));
    }

    public static boolean canSee(LivingEntity pLivingEntity, LivingEntity pTarget) {
        Brain brain = pLivingEntity.func_213375_cj();
        if (BrainUtil.func_220619_a((Brain)brain, (LivingEntity)pTarget)) {
            return true;
        }
        return pLivingEntity.func_70685_l((Entity)pTarget);
    }

    public static boolean isWithinAttackRange(MobEntity entity, LivingEntity target, int maxDistance) {
        Item item = entity.func_184614_ca().func_77973_b();
        boolean entityInRange = BrainUtil.func_233869_a_((MobEntity)entity, (LivingEntity)target, (int)maxDistance);
        if (item == null) {
            return entityInRange;
        }
        if (item instanceof ShootableItem && entity.func_230280_a_((ShootableItem)item)) {
            int i = ((ShootableItem)item).func_230305_d_() - maxDistance;
            return entity.func_233562_a_((Entity)target, (double)i);
        }
        return entityInRange;
    }
}

