/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.entity.PartEntity;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public final class EntityRetrievalUtil {
    @Nullable
    public static <T extends Entity> T getNearest(Vector3d origin, List<T> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        double dist = Double.MAX_VALUE;
        Entity closest = null;
        for (Entity entity : entities) {
            double entityDist = entity.func_195048_a(origin);
            if (!(entityDist < dist)) continue;
            dist = entityDist;
            closest = entity;
        }
        return (T)closest;
    }

    @Nullable
    public static <T extends Entity> T getNearestEntity(Entity origin, double radius, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin, radius, radius, radius, predicate);
    }

    @Nullable
    public static <T extends Entity> T getNearestEntity(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getNearestEntity(origin.field_70170_p, new AxisAlignedBB(origin.func_226277_ct_() - radiusX, origin.func_226278_cu_() - radiusY, origin.func_226281_cx_() - radiusZ, origin.func_226277_ct_() + radiusX, origin.func_226278_cu_() + radiusY, origin.func_226281_cx_() + radiusZ), origin.func_213303_ch(), predicate);
    }

    @Nullable
    public static <T extends Entity> T getNearestEntity(World level, AxisAlignedBB area, Vector3d origin, Predicate<? extends Entity> predicate) {
        Predicate<? extends Entity> typeSafePredicate = predicate;
        MutableDouble dist = new MutableDouble(Double.MAX_VALUE);
        MutableObject closest = new MutableObject(null);
        level.func_72839_b(null, area).forEach(entity -> {
            double entityDist;
            if (typeSafePredicate.test((Entity)entity) && (entityDist = entity.func_195048_a(origin)) < dist.getValue()) {
                dist.setValue(entityDist);
                closest.setValue(entity);
            }
        });
        return (T)((Entity)closest.getValue());
    }

    @Nullable
    public static PlayerEntity getNearestPlayer(Entity origin, double radius, Predicate<PlayerEntity> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin, radius, radius, radius, predicate);
    }

    @Nullable
    public static PlayerEntity getNearestPlayer(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<PlayerEntity> predicate) {
        return EntityRetrievalUtil.getNearestPlayer(origin.field_70170_p, new AxisAlignedBB(origin.func_226277_ct_() - radiusX, origin.func_226278_cu_() - radiusY, origin.func_226281_cx_() - radiusZ, origin.func_226277_ct_() + radiusX, origin.func_226278_cu_() + radiusY, origin.func_226281_cx_() + radiusZ), origin.func_213303_ch(), predicate);
    }

    @Nullable
    public static PlayerEntity getNearestPlayer(World level, AxisAlignedBB area, Vector3d origin, Predicate<PlayerEntity> predicate) {
        double dist = Double.MAX_VALUE;
        PlayerEntity closest = null;
        for (PlayerEntity player : level.func_217369_A()) {
            double playerDist;
            if (!area.func_72318_a(player.func_213303_ch()) || !predicate.test(player) || !((playerDist = player.func_195048_a(origin)) < dist)) continue;
            dist = playerDist;
            closest = player;
        }
        return closest;
    }

    public static List<PlayerEntity> getPlayers(World level, AxisAlignedBB area) {
        return EntityRetrievalUtil.getPlayers(level, area, (PlayerEntity pl) -> true);
    }

    public static List<PlayerEntity> getPlayers(Entity origin, double radius, Predicate<PlayerEntity> predicate) {
        return EntityRetrievalUtil.getPlayers(origin, radius, radius, radius, predicate);
    }

    public static List<PlayerEntity> getPlayers(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<PlayerEntity> predicate) {
        return EntityRetrievalUtil.getPlayers(origin.field_70170_p, new AxisAlignedBB(origin.func_226277_ct_() - radiusX, origin.func_226278_cu_() - radiusY, origin.func_226281_cx_() - radiusZ, origin.func_226277_ct_() + radiusX, origin.func_226278_cu_() + radiusY, origin.func_226281_cx_() + radiusZ), predicate);
    }

    public static List<PlayerEntity> getPlayers(World level, AxisAlignedBB area, Predicate<PlayerEntity> predicate) {
        ObjectArrayList players = new ObjectArrayList();
        for (PlayerEntity player : level.func_217369_A()) {
            if (!area.func_72318_a(player.func_213303_ch()) || !predicate.test(player)) continue;
            players.add(player);
        }
        return players;
    }

    public static <T> List<T> getEntities(Entity origin, double radius, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getEntities(origin, radius, radius, radius, predicate);
    }

    public static <T> List<T> getEntities(Entity origin, double radiusX, double radiusY, double radiusZ, Predicate<? extends Entity> predicate) {
        return EntityRetrievalUtil.getEntities(origin.field_70170_p, new AxisAlignedBB(origin.func_226277_ct_() - radiusX, origin.func_226278_cu_() - radiusY, origin.func_226281_cx_() - radiusZ, origin.func_226277_ct_() + radiusX, origin.func_226278_cu_() + radiusY, origin.func_226281_cx_() + radiusZ), predicate.and(entity -> entity != origin));
    }

    public static <T> List<T> getEntities(World level, AxisAlignedBB area, Predicate<? extends Entity> predicate) {
        Predicate<? extends Entity> typeSafePredicate = predicate;
        ObjectArrayList entities = new ObjectArrayList();
        level.func_72839_b(null, area).forEach(arg_0 -> EntityRetrievalUtil.lambda$getEntities$3(typeSafePredicate, (List)entities, arg_0));
        for (PartEntity part : level.getPartEntities()) {
            if (!part.func_174813_aQ().func_72326_a(area) || !typeSafePredicate.test((Entity)part)) continue;
            entities.add(part);
        }
        return entities;
    }

    private static /* synthetic */ void lambda$getEntities$3(Predicate typeSafePredicate, List entities, Entity entity) {
        if (typeSafePredicate.test(entity)) {
            entities.add(entity);
        }
    }
}

