/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.util;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public final class RandomUtil {
    public static final EasyRandom RANDOM = new EasyRandom(ThreadLocalRandom.current());

    public static ThreadLocalRandom getRandomInstance() {
        return ThreadLocalRandom.current();
    }

    public static boolean fiftyFifty() {
        return RANDOM.fiftyFifty();
    }

    public static boolean oneInNChance(int n) {
        return RANDOM.oneInNChance(n);
    }

    public static boolean percentChance(double percentChance) {
        return RANDOM.percentChance(percentChance);
    }

    public static boolean percentChance(float percentChance) {
        return RANDOM.percentChance(percentChance);
    }

    public static int randomNumberUpTo(int upperBound) {
        return RANDOM.randomNumberUpTo(upperBound);
    }

    public static float randomValueUpTo(float upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomValueUpTo(double upperBound) {
        return RANDOM.randomValueUpTo(upperBound);
    }

    public static double randomGaussianValue() {
        return RANDOM.randomGaussianValue();
    }

    public static double randomScaledGaussianValue(double scale) {
        return RANDOM.randomScaledGaussianValue(scale);
    }

    public static int randomNumberBetween(int min, int max) {
        return RANDOM.randomNumberBetween(min, max);
    }

    public static double randomValueBetween(double min, double max) {
        return RANDOM.randomValueBetween(min, max);
    }

    public static <T> T getRandomSelection(T ... options) {
        return RANDOM.getRandomSelection(options);
    }

    public static <T> T getRandomSelection(@Nonnull List<T> options) {
        return RANDOM.getRandomSelection(options);
    }

    @Nonnull
    public static BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius);
    }

    @Nonnull
    public static BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, World world) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, safeSurfacePlacement, world);
    }

    @Nonnull
    @Deprecated
    public static BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, World world, int tries, @Nullable Predicate<BlockState> statePredicate) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, minSpreadX, minSpreadY, minSpreadZ, safeSurfacePlacement, world, tries, statePredicate);
    }

    @Nonnull
    public static BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, World world, int tries, @Nullable BiPredicate<BlockState, BlockPos> statePredicate) {
        return RANDOM.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, minSpreadX, minSpreadY, minSpreadZ, safeSurfacePlacement, world, tries, statePredicate);
    }

    public static final class EasyRandom
    extends Random {
        private final Random random;

        public EasyRandom() {
            this(new Random());
        }

        public EasyRandom(@Nonnull Random rand) {
            this.random = rand;
        }

        public Random getSource() {
            return new Random();
        }

        public boolean fiftyFifty() {
            return this.random.nextBoolean();
        }

        public boolean oneInNChance(int n) {
            if (n <= 0) {
                return false;
            }
            return this.random.nextFloat() < 1.0f / (float)n;
        }

        public boolean percentChance(double percentChance) {
            if (percentChance <= 0.0) {
                return false;
            }
            if (percentChance >= 1.0) {
                return true;
            }
            return this.random.nextDouble() < percentChance;
        }

        public boolean percentChance(float percentChance) {
            if (percentChance <= 0.0f) {
                return false;
            }
            if (percentChance >= 1.0f) {
                return true;
            }
            return this.random.nextDouble() < (double)percentChance;
        }

        public int randomNumberUpTo(int upperBound) {
            return this.random.nextInt(upperBound);
        }

        public float randomValueUpTo(float upperBound) {
            return this.random.nextFloat() * upperBound;
        }

        public double randomValueUpTo(double upperBound) {
            return this.random.nextDouble() * upperBound;
        }

        public double randomGaussianValue() {
            return this.random.nextGaussian();
        }

        public double randomScaledGaussianValue(double scale) {
            return this.random.nextGaussian() * scale;
        }

        public int randomNumberBetween(int min, int max) {
            return min + (int)Math.floor(this.random.nextDouble() * (double)(1 + max - min));
        }

        public double randomValueBetween(double min, double max) {
            return min + this.random.nextDouble() * (max - min);
        }

        public <T> T getRandomSelection(T ... options) {
            return options[this.random.nextInt(options.length)];
        }

        public <T> T getRandomSelection(@Nonnull List<T> options) {
            return options.get(this.random.nextInt(options.size()));
        }

        @Nonnull
        public BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, false, null);
        }

        @Nonnull
        public BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, boolean safeSurfacePlacement, World world) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, 0, 0, 0, safeSurfacePlacement, world, 1, (Predicate<BlockState>)null);
        }

        @Nonnull
        @Deprecated
        public BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, World world, int tries, @Nullable Predicate<BlockState> statePredicate) {
            return this.getRandomPositionWithinRange(centerPos, xRadius, yRadius, zRadius, minSpreadX, minSpreadY, minSpreadZ, safeSurfacePlacement, world, tries, (BlockState state, BlockPos pos) -> statePredicate == null || statePredicate.test((BlockState)state));
        }

        @Nonnull
        public BlockPos getRandomPositionWithinRange(BlockPos centerPos, int xRadius, int yRadius, int zRadius, int minSpreadX, int minSpreadY, int minSpreadZ, boolean safeSurfacePlacement, World world, int tries, @Nullable BiPredicate<BlockState, BlockPos> statePredicate) {
            BlockPos.Mutable mutablePos = centerPos.func_239590_i_();
            xRadius = Math.max(xRadius - minSpreadX, 0);
            yRadius = Math.max(yRadius - minSpreadY, 0);
            zRadius = Math.max(zRadius - minSpreadZ, 0);
            for (int i = 0; i < tries; ++i) {
                double xAdjust = this.random.nextFloat() * (float)xRadius * 2.0f - (float)xRadius;
                double yAdjust = this.random.nextFloat() * (float)yRadius * 2.0f - (float)yRadius;
                double zAdjust = this.random.nextFloat() * (float)zRadius * 2.0f - (float)zRadius;
                int newX = (int)Math.floor((double)centerPos.func_177958_n() + xAdjust + (double)minSpreadX * Math.signum(xAdjust));
                int newY = (int)Math.floor((double)centerPos.func_177956_o() + yAdjust + (double)minSpreadY * Math.signum(yAdjust));
                int newZ = (int)Math.floor((double)centerPos.func_177952_p() + zAdjust + (double)minSpreadZ * Math.signum(zAdjust));
                mutablePos.func_181079_c(newX, newY, newZ);
                if (safeSurfacePlacement && world != null) {
                    mutablePos.func_189533_g((Vector3i)world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (BlockPos)mutablePos));
                }
                if (statePredicate != null && !statePredicate.test(world.func_180495_p((BlockPos)mutablePos), mutablePos.func_185334_h())) continue;
                return mutablePos.func_185334_h();
            }
            return centerPos;
        }

        @Override
        public void setSeed(long seed) {
            this.random.setSeed(seed);
        }

        @Override
        public int nextInt() {
            return this.random.nextInt();
        }

        @Override
        public int nextInt(int upperLimit) {
            return this.random.nextInt(upperLimit);
        }

        @Override
        public long nextLong() {
            return this.random.nextLong();
        }

        @Override
        public boolean nextBoolean() {
            return this.random.nextBoolean();
        }

        @Override
        public float nextFloat() {
            return this.random.nextFloat();
        }

        @Override
        public double nextDouble() {
            return this.random.nextDouble();
        }

        @Override
        public double nextGaussian() {
            return this.random.nextGaussian();
        }
    }
}

