/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.example;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.task.FindNewAttackTargetTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BowItem;
import net.minecraft.world.World;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.BowAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.AvoidSun;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.AvoidEntity;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.EscapeSun;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;

public class SBLSkeleton
extends SkeletonEntity
implements SmartBrainOwner<SBLSkeleton> {
    public SBLSkeleton(EntityType<? extends SBLSkeleton> entityType, World level) {
        super(entityType, level);
    }

    protected final void func_184651_r() {
    }

    public final void func_85036_m() {
    }

    protected Brain.BrainCodec<?> func_230289_cH_() {
        return new SmartBrainProvider<SBLSkeleton>(this);
    }

    @Override
    public List<ExtendedSensor<SBLSkeleton>> getSensors() {
        return ObjectArrayList.wrap((Object[])new ExtendedSensor[]{new NearbyPlayersSensor(), new NearbyLivingEntitySensor<SBLSkeleton>().setPredicate((target, entity) -> target instanceof PlayerEntity || target instanceof IronGolemEntity || target instanceof WolfEntity || target instanceof TurtleEntity && target.func_70631_g_() && !target.func_70090_H())});
    }

    @Override
    public BrainActivityGroup<SBLSkeleton> getCoreTasks() {
        return BrainActivityGroup.coreTasks(new Task[]{new AvoidSun(), new EscapeSun<CreatureEntity>().cooldownFor(entity -> 20), new AvoidEntity().avoiding(entity -> entity instanceof WolfEntity), new LookAtEntityTask(300.0f), new StrafeTarget<MobEntity>().stopStrafingWhen(entity -> !SBLSkeleton.isHoldingBow((LivingEntity)entity)).startCondition(SBLSkeleton::isHoldingBow), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<SBLSkeleton> getIdleTasks() {
        return BrainActivityGroup.idleTasks(new FirstApplicableBehaviour(new TargetOrRetaliate(), new SetPlayerLookTarget(), new SetRandomLookTarget()), new OneRandomBehaviour(new SetRandomWalkTarget().speedModifier(1.0f), new Idle<LivingEntity>().runFor(entity -> 60 + entity.func_70681_au().nextInt(60))));
    }

    @Override
    public BrainActivityGroup<SBLSkeleton> getFightTasks() {
        return BrainActivityGroup.fightTasks(new Task[]{new FindNewAttackTargetTask(target -> !target.func_70089_S() || target instanceof PlayerEntity && ((PlayerEntity)target).func_184812_l_()), new FirstApplicableBehaviour(new BowAttack<SBLSkeleton>(20).startCondition(SBLSkeleton::isHoldingBow), new AnimatableMeleeAttack<MobEntity>(0).whenStarting(entity -> this.func_213395_q(true)).whenStarting(entity -> this.func_213395_q(false)))});
    }

    protected void func_70619_bc() {
        this.tickBrain((LivingEntity)this);
    }

    private static boolean isHoldingBow(LivingEntity livingEntity) {
        return livingEntity.func_233634_a_(stack -> stack.getItem() instanceof BowItem);
    }
}

