/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.object;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.sensor.Sensor;

public class NearestVisibleLivingEntities
extends ArrayList<LivingEntity> {
    private static final long serialVersionUID = 275532968616126431L;
    private static final NearestVisibleLivingEntities EMPTY = new NearestVisibleLivingEntities();
    private final Predicate<LivingEntity> lineOfSightTest;

    private NearestVisibleLivingEntities() {
        this.lineOfSightTest = curEntity -> false;
    }

    public NearestVisibleLivingEntities(LivingEntity owner, List<LivingEntity> nearbyEntities) {
        this(nearbyEntities, (LivingEntity entityIn) -> Sensor.func_242316_a((LivingEntity)owner, (LivingEntity)entityIn));
    }

    public NearestVisibleLivingEntities(List<LivingEntity> nearbyEntities, Predicate<LivingEntity> lineOfSightPredicate) {
        super(nearbyEntities);
        this.lineOfSightTest = lineOfSightPredicate;
    }

    public static NearestVisibleLivingEntities empty() {
        return EMPTY;
    }

    public Optional<LivingEntity> findFirstMatchingEntry(Predicate<LivingEntity> condition) {
        for (LivingEntity livingentity : this) {
            if (!condition.test(livingentity) || !this.lineOfSightTest.test(livingentity)) continue;
            return Optional.of(livingentity);
        }
        return Optional.empty();
    }

    public List<LivingEntity> findAllMatchingEntries(Predicate<LivingEntity> condition) {
        HashSet<LivingEntity> result = new HashSet<LivingEntity>();
        for (LivingEntity living : this) {
            if (!condition.test(living) || !this.lineOfSightTest.test(living)) continue;
            result.add(living);
        }
        return new ArrayList<LivingEntity>(result);
    }

    public boolean contains(LivingEntity entityToTest) {
        return super.contains(entityToTest) && this.lineOfSightTest.test(entityToTest);
    }

    public boolean containsEntryMatching(Predicate<LivingEntity> condition) {
        for (LivingEntity livingentity : this) {
            if (!condition.test(livingentity) || !this.lineOfSightTest.test(livingentity)) continue;
            return true;
        }
        return false;
    }
}

