/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.object;

import com.mojang.datafixers.util.Pair;
import io.netty.util.internal.ThreadLocalRandom;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SBLShufflingList<T>
implements Iterable<T> {
    private final List<WeightedEntry<T>> entries;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();

    public SBLShufflingList() {
        this.entries = new ObjectArrayList();
    }

    public SBLShufflingList(int size) {
        this.entries = new ObjectArrayList(size);
    }

    public SBLShufflingList(Pair<T, Integer> ... entries) {
        this.entries = new ObjectArrayList(entries.length);
        for (Pair<T, Integer> entry : entries) {
            this.entries.add(new WeightedEntry<Object>(entry.getFirst(), (Integer)entry.getSecond()));
        }
    }

    public SBLShufflingList<T> shuffle() {
        this.entries.forEach(entry -> entry.setShuffledWeight(this.random.nextFloat()));
        this.entries.sort(Comparator.comparingDouble(WeightedEntry::getShuffledWeight));
        return this;
    }

    public boolean add(T entry, int weight) {
        return this.entries.add(new WeightedEntry<T>(entry, weight));
    }

    @Nullable
    public T get(int index) {
        return this.entries.get(index).get();
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        ArrayList al = new ArrayList();
        this.entries.forEach(we -> al.add(we.get()));
        return new ObjectListIterator<T>(){
            int pointer = 0;
            int last = -1;

            public boolean hasNext() {
                return this.pointer < SBLShufflingList.this.entries.size();
            }

            public boolean hasPrevious() {
                return this.pointer > 0;
            }

            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pointer++;
                return ((WeightedEntry)SBLShufflingList.this.entries.get(this.last)).object;
            }

            public T previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pointer;
                return ((WeightedEntry)SBLShufflingList.this.entries.get(this.pointer)).object;
            }

            public int nextIndex() {
                return this.pointer;
            }

            public int previousIndex() {
                return this.pointer - 1;
            }

            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                SBLShufflingList.this.entries.remove(this.last);
                if (this.last < this.pointer) {
                    --this.pointer;
                }
                this.last = -1;
            }

            public void forEachRemaining(Consumer<? super T> consumer) {
                while (this.pointer < SBLShufflingList.this.entries.size()) {
                    ++this.pointer;
                    this.last = this.last;
                    consumer.accept(((WeightedEntry)SBLShufflingList.this.entries.get(this.last)).object);
                }
            }

            public int back(int positions) {
                if (positions < 0) {
                    throw new IllegalArgumentException("Argument must not be negative: " + positions);
                }
                int remaining = SBLShufflingList.this.entries.size() - this.pointer;
                if (positions < remaining) {
                    this.pointer -= positions;
                } else {
                    positions = remaining;
                    this.pointer = 0;
                }
                this.last = this.pointer;
                return positions;
            }

            public int skip(int positions) {
                if (positions < 0) {
                    throw new IllegalArgumentException("Argument must not be negative: " + positions);
                }
                int remaining = SBLShufflingList.this.entries.size() - this.pointer;
                if (positions < remaining) {
                    this.pointer += positions;
                } else {
                    positions = remaining;
                    this.pointer = SBLShufflingList.this.entries.size();
                }
                this.last = this.pointer - 1;
                return positions;
            }
        };
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.entries.forEach(entry -> action.accept((Object)entry.get()));
    }

    public Stream<T> stream() {
        return this.entries.stream().map(WeightedEntry::get);
    }

    public static class WeightedEntry<T> {
        private final T object;
        private final int weight;
        private double shuffledWeight;

        WeightedEntry(T object, int weight) {
            this.object = object;
            this.weight = weight;
        }

        double getShuffledWeight() {
            return this.shuffledWeight;
        }

        T get() {
            return this.object;
        }

        int getWeight() {
            return this.weight;
        }

        void setShuffledWeight(float mod) {
            this.shuffledWeight = -Math.pow(mod, 1.0f / (float)this.weight);
        }

        public String toString() {
            return this.object + ":" + this.weight;
        }
    }
}

