/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public interface ITileEntity<T extends TileEntity> {
    public Class<T> getTileEntityClass();

    default public void withTileEntityDo(IBlockReader world, BlockPos pos, Consumer<T> action) {
        this.getTileEntityOptional(world, pos).ifPresent(action);
    }

    default public ActionResultType onTileEntityUse(IBlockReader world, BlockPos pos, Function<T, ActionResultType> action) {
        return this.getTileEntityOptional(world, pos).map(action).orElse(ActionResultType.PASS);
    }

    default public Optional<T> getTileEntityOptional(IBlockReader world, BlockPos pos) {
        return Optional.ofNullable(this.getTileEntity(world, pos));
    }

    @Nullable
    default public T getTileEntity(IBlockReader worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        Class<T> expectedClass = this.getTileEntityClass();
        if (tileEntity == null) {
            return null;
        }
        if (!expectedClass.isInstance(tileEntity)) {
            return null;
        }
        return (T)tileEntity;
    }
}

