/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.CampfireTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class Candelabra
extends Block
implements IWaterLoggable {
    public static final BooleanProperty HANGING = BlockStateProperties.field_222514_j;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final VoxelShape GROUNDED_SHAPE = Stream.of(Block.func_208617_a((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.func_208617_a((double)1.0, (double)5.5, (double)7.0, (double)3.0, (double)7.5, (double)9.0), Block.func_208617_a((double)13.0, (double)8.5, (double)7.0, (double)15.0, (double)12.5, (double)9.0), Block.func_208617_a((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5), Block.func_208617_a((double)1.0, (double)8.5, (double)7.0, (double)3.0, (double)12.5, (double)9.0), Block.func_208617_a((double)3.0, (double)5.5, (double)7.01, (double)13.0, (double)6.5, (double)9.01), Block.func_208617_a((double)12.5, (double)7.5, (double)6.5, (double)15.5, (double)8.5, (double)9.5), Block.func_208617_a((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.func_208617_a((double)13.0, (double)5.5, (double)7.0, (double)15.0, (double)7.5, (double)9.0), Block.func_208617_a((double)6.5, (double)9.5, (double)12.5, (double)9.5, (double)10.5, (double)15.5), Block.func_208617_a((double)0.5, (double)7.5, (double)6.5, (double)3.5, (double)8.5, (double)9.5), Block.func_208617_a((double)7.0, (double)10.5, (double)13.0, (double)9.0, (double)14.5, (double)15.0), Block.func_208617_a((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)1.0, (double)10.5), Block.func_208617_a((double)7.0, (double)10.5, (double)1.0, (double)9.0, (double)14.5, (double)3.0), Block.func_208617_a((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.func_208617_a((double)7.0, (double)7.5, (double)13.0, (double)9.0, (double)9.5, (double)15.0), Block.func_208617_a((double)7.01, (double)7.5, (double)3.0, (double)9.01, (double)8.5, (double)13.0), Block.func_208617_a((double)7.0, (double)7.5, (double)1.0, (double)9.0, (double)9.5, (double)3.0), Block.func_208617_a((double)6.5, (double)9.5, (double)0.5, (double)9.5, (double)10.5, (double)3.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape HANGING_SHAPES = Stream.of(Block.func_208617_a((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.func_208617_a((double)1.0, (double)5.5, (double)7.0, (double)3.0, (double)7.5, (double)9.0), Block.func_208617_a((double)13.0, (double)8.5, (double)7.0, (double)15.0, (double)12.5, (double)9.0), Block.func_208617_a((double)1.0, (double)8.5, (double)7.0, (double)3.0, (double)12.5, (double)9.0), Block.func_208617_a((double)3.0, (double)5.5, (double)7.01, (double)13.0, (double)6.5, (double)9.01), Block.func_208617_a((double)12.5, (double)7.5, (double)6.5, (double)15.5, (double)8.5, (double)9.5), Block.func_208617_a((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.func_208617_a((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.func_208617_a((double)13.0, (double)5.5, (double)7.0, (double)15.0, (double)7.5, (double)9.0), Block.func_208617_a((double)6.5, (double)9.5, (double)12.5, (double)9.5, (double)10.5, (double)15.5), Block.func_208617_a((double)0.5, (double)7.5, (double)6.5, (double)3.5, (double)8.5, (double)9.5), Block.func_208617_a((double)7.0, (double)10.5, (double)13.0, (double)9.0, (double)14.5, (double)15.0), Block.func_208617_a((double)7.0, (double)10.5, (double)1.0, (double)9.0, (double)14.5, (double)3.0), Block.func_208617_a((double)7.0, (double)7.5, (double)13.0, (double)9.0, (double)9.5, (double)15.0), Block.func_208617_a((double)7.01, (double)7.5, (double)3.0, (double)9.01, (double)8.5, (double)13.0), Block.func_208617_a((double)7.0, (double)7.5, (double)1.0, (double)9.0, (double)9.5, (double)3.0), Block.func_208617_a((double)6.5, (double)9.5, (double)0.5, (double)9.5, (double)10.5, (double)3.5), Block.func_208617_a((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)2.0, (double)8.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape GROUNDED_SHAPE_TURNED = Stream.of(Block.func_208617_a((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.func_208617_a((double)7.0, (double)5.5, (double)13.0, (double)9.0, (double)7.5, (double)15.0), Block.func_208617_a((double)7.0, (double)8.5, (double)1.0, (double)9.0, (double)12.5, (double)3.0), Block.func_208617_a((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5), Block.func_208617_a((double)7.0, (double)8.5, (double)13.0, (double)9.0, (double)12.5, (double)15.0), Block.func_208617_a((double)7.0, (double)5.5, (double)3.0, (double)9.01, (double)6.5, (double)13.0), Block.func_208617_a((double)6.5, (double)7.5, (double)0.5, (double)9.5, (double)8.5, (double)3.5), Block.func_208617_a((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.func_208617_a((double)7.0, (double)5.5, (double)1.0, (double)9.0, (double)7.5, (double)3.0), Block.func_208617_a((double)12.5, (double)9.5, (double)6.5, (double)15.5, (double)10.5, (double)9.5), Block.func_208617_a((double)6.5, (double)7.5, (double)12.5, (double)9.5, (double)8.5, (double)15.5), Block.func_208617_a((double)13.0, (double)10.5, (double)7.0, (double)15.0, (double)14.5, (double)9.0), Block.func_208617_a((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)1.0, (double)10.5), Block.func_208617_a((double)1.0, (double)10.5, (double)7.0, (double)3.0, (double)14.5, (double)9.0), Block.func_208617_a((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.func_208617_a((double)13.0, (double)7.5, (double)7.0, (double)15.0, (double)9.5, (double)9.0), Block.func_208617_a((double)3.0, (double)7.5, (double)7.0, (double)13.0, (double)8.5, (double)9.0), Block.func_208617_a((double)1.0, (double)7.5, (double)7.0, (double)3.0, (double)9.5, (double)9.0), Block.func_208617_a((double)0.5, (double)9.5, (double)6.5, (double)3.5, (double)10.5, (double)9.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape HANGING_SHAPES_TURNED = Stream.of(Block.func_208617_a((double)6.5, (double)11.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), Block.func_208617_a((double)7.0, (double)5.5, (double)13.0, (double)9.0, (double)7.5, (double)15.0), Block.func_208617_a((double)7.0, (double)8.5, (double)1.03, (double)9.0, (double)12.5, (double)3.0), Block.func_208617_a((double)7.0, (double)8.5, (double)13.0, (double)9.0, (double)12.5, (double)15.0), Block.func_208617_a((double)7.01, (double)5.5, (double)3.0, (double)9.0, (double)6.5, (double)13.0), Block.func_208617_a((double)6.5, (double)7.5, (double)0.5, (double)9.5, (double)8.5, (double)3.5), Block.func_208617_a((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0), Block.func_208617_a((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.func_208617_a((double)7.0, (double)5.5, (double)1.03, (double)9.0, (double)7.5, (double)3.0), Block.func_208617_a((double)12.5, (double)9.5, (double)6.5, (double)15.5, (double)10.5, (double)9.5), Block.func_208617_a((double)6.5, (double)7.5, (double)12.5, (double)9.5, (double)8.5, (double)15.5), Block.func_208617_a((double)13.0, (double)10.5, (double)7.0, (double)15.0, (double)14.5, (double)9.0), Block.func_208617_a((double)1.0, (double)10.5, (double)7.0, (double)3.0, (double)14.5, (double)9.0), Block.func_208617_a((double)13.0, (double)7.5, (double)7.0, (double)15.0, (double)9.5, (double)9.0), Block.func_208617_a((double)3.0, (double)7.5, (double)7.0, (double)13.0, (double)8.5, (double)9.0), Block.func_208617_a((double)1.0, (double)7.5, (double)7.0, (double)3.0, (double)9.5, (double)9.0), Block.func_208617_a((double)0.5, (double)9.5, (double)6.5, (double)3.5, (double)10.5, (double)9.5), Block.func_208617_a((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)2.0, (double)8.5)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate;
            if (direction.func_176740_k() != Direction.Axis.Y || !(blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return (BlockState)((BlockState)((BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)context.func_195992_f())).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.NORTH || state.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.SOUTH ? (((Boolean)state.func_177229_b((Property)HANGING)).booleanValue() ? HANGING_SHAPES : GROUNDED_SHAPE) : ((Boolean)state.func_177229_b((Property)HANGING) != false ? HANGING_SHAPES_TURNED : GROUNDED_SHAPE_TURNED);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Random random = new Random();
        if (itemstack.func_77973_b() == Items.field_151033_d && Candelabra.canBeLit(state)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
            itemstack.func_222118_a(1, (LivingEntity)player, player1 -> player1.func_213334_d(handIn));
            return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    public static boolean canBeLit(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) == false && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) == false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public Candelabra(AbstractBlock.Properties properties) {
        super(properties.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HANGING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HorizontalBlock.field_185512_D, HANGING, WATERLOGGED, LIT});
    }

    public static void extinguish(IWorld world, BlockPos pos, BlockState state) {
        TileEntity tileentity;
        if (world.func_201670_d()) {
            for (int i = 0; i < 20; ++i) {
                Candelabra.spawnSmokeParticles((World)world, pos, true);
            }
        }
        if ((tileentity = world.func_175625_s(pos)) instanceof CampfireTileEntity) {
            ((CampfireTileEntity)tileentity).func_213986_d();
        }
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            boolean flag = (Boolean)state.func_177229_b((Property)LIT);
            if (flag) {
                if (!worldIn.func_201670_d()) {
                    worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                Candelabra.extinguish(worldIn, pos, state);
            }
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public void func_220066_a(World worldIn, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        if (!worldIn.field_72995_K && projectile.func_70027_ad()) {
            boolean flag;
            Entity entity = projectile.func_234616_v_();
            boolean bl = flag = entity == null || entity instanceof PlayerEntity || ForgeEventFactory.getMobGriefingEvent((World)worldIn, (Entity)entity);
            if (flag && !((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && !((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
                BlockPos blockpos = hit.func_216350_a();
                worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
            }
        }
    }

    public static void spawnSmokeParticles(World worldIn, BlockPos pos, boolean spawnExtraSmoke) {
        Random random = worldIn.func_201674_k();
        BasicParticleType basicparticletype = ParticleTypes.field_218417_ae;
        worldIn.func_217404_b((IParticleData)basicparticletype, true, (double)pos.func_177958_n() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + random.nextDouble() + random.nextDouble(), (double)pos.func_177952_p() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    public static boolean isLit(BlockState state) {
        return state.func_235901_b_((Property)LIT) && (Boolean)state.func_177229_b((Property)LIT) != false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = Candelabra.getBlockConnected(state).func_176734_d();
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d());
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.func_177229_b((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.hexerei.candelabra_shift"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.hexerei.candelabra"));
        }
        super.func_190948_a(stack, world, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            if (rand.nextInt(10) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 0.5f + rand.nextFloat() / 2.0f, rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (!((Boolean)state.func_177229_b((Property)HANGING)).booleanValue()) {
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0625f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0625f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
            }
            if (state.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.EAST || state.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.WEST) {
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + 0.5f + 0.375f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f + 0.375f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + 0.5f - 0.375f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f - 0.375f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.875f), (double)((float)pos.func_177952_p() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.875f), (double)((float)pos.func_177952_p() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.875f), (double)((float)pos.func_177952_p() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.875f), (double)((float)pos.func_177952_p() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
            }
            if (state.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.NORTH || state.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.SOUTH) {
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f + 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.0f), (double)((float)pos.func_177952_p() + 0.5f - 0.375f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + 0.5f + 0.375f), (double)((float)pos.func_177956_o() + 0.875f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f + 0.375f), (double)((float)pos.func_177956_o() + 0.875f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)((float)pos.func_177958_n() + 0.5f - 0.375f), (double)((float)pos.func_177956_o() + 0.875f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.01, (rand.nextDouble() - 0.5) / 100.0);
                }
                if (rand.nextInt(3) == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)((float)pos.func_177958_n() + 0.5f - 0.375f), (double)((float)pos.func_177956_o() + 0.875f), (double)((float)pos.func_177952_p() + 0.5f), (rand.nextDouble() - 0.5) / 100.0, (rand.nextDouble() + 0.5) * 0.035, (rand.nextDouble() - 0.5) / 100.0);
                }
            }
        }
    }
}

