/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.tileentity.CandleDipperTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CandleDipper
extends Block
implements ITileEntity<CandleDipperTile>,
IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SHAPE = Stream.of(Block.func_208617_a((double)14.0, (double)1.0, (double)4.0, (double)16.0, (double)6.0, (double)12.0), Block.func_208617_a((double)13.0, (double)-1.0, (double)3.5, (double)17.0, (double)1.0, (double)6.5), Block.func_208617_a((double)13.0, (double)-1.0, (double)9.5, (double)17.0, (double)1.0, (double)12.5), Block.func_208617_a((double)-1.0, (double)-1.0, (double)9.5, (double)3.0, (double)1.0, (double)12.5), Block.func_208617_a((double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)6.0, (double)12.0), Block.func_208617_a((double)-1.0, (double)-1.0, (double)3.5, (double)3.0, (double)1.0, (double)6.5), Block.func_208617_a((double)2.0, (double)-1.0, (double)2.0, (double)14.0, (double)0.0, (double)14.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape SHAPE_TURNED = Stream.of(Block.func_208617_a((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)6.0, (double)2.0), Block.func_208617_a((double)3.5, (double)-1.0, (double)-1.0, (double)6.5, (double)1.0, (double)3.0), Block.func_208617_a((double)9.5, (double)-1.0, (double)-1.0, (double)12.5, (double)1.0, (double)3.0), Block.func_208617_a((double)9.5, (double)-1.0, (double)13.0, (double)12.5, (double)1.0, (double)17.0), Block.func_208617_a((double)4.0, (double)1.0, (double)14.0, (double)12.0, (double)6.0, (double)16.0), Block.func_208617_a((double)3.5, (double)-1.0, (double)13.0, (double)6.5, (double)1.0, (double)17.0), Block.func_208617_a((double)2.0, (double)-1.0, (double)2.0, (double)14.0, (double)0.0, (double)14.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        if (this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) && context.func_195991_k().func_180495_p(context.func_195995_a().func_177977_b()).func_177230_c() instanceof MixingCauldron) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)context.func_195992_f());
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.NORTH || state.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.SOUTH ? SHAPE : SHAPE_TURNED;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Random random = new Random();
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CandleDipperTile) {
            int check = ((CandleDipperTile)tileEntity).interactDipper(player, hit);
            System.out.println(check);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public CandleDipper(AbstractBlock.Properties properties) {
        super(properties.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HorizontalBlock.field_185512_D, WATERLOGGED});
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MixingCauldron;
    }

    protected static Direction getBlockConnected(BlockState state) {
        return Direction.DOWN;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.hexerei.candle_dipper_shift"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.hexerei.candle_dipper"));
        }
        super.func_190948_a(stack, world, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        TileEntity te = ((TileEntityType)ModTileEntities.CANDLE_DIPPER_TILE.get()).func_200968_a();
        return te;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public Class<CandleDipperTile> getTileEntityClass() {
        return CandleDipperTile.class;
    }
}

