/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.tileentity.CofferTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;

public class Coffer
extends Block
implements ITileEntity<CofferTile>,
IWaterLoggable {
    public static final IntegerProperty ANGLE = IntegerProperty.func_177719_a((String)"angle", (int)0, (int)180);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SHAPE = Stream.of(Block.func_208617_a((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)4.0, (double)12.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    public static final VoxelShape SHAPE_TURNED = Stream.of(Block.func_208617_a((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)4.0, (double)14.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)context.func_195992_f())).func_206870_a((Property)ANGLE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        if (p_220053_1_.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.EAST || p_220053_1_.func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.WEST) {
            return SHAPE_TURNED;
        }
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (!worldIn.func_201670_d()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof CofferTile) {
                INamedContainerProvider containerProvider = this.createContainerProvider(worldIn, pos);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, (BlockPos)tileEntity.func_174877_v());
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return ActionResultType.SUCCESS;
    }

    public Coffer(AbstractBlock.Properties properties) {
        super(properties.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HorizontalBlock.field_185512_D, ANGLE, WATERLOGGED});
    }

    public void setAngle(World worldIn, BlockPos pos, BlockState state, int angle) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ANGLE, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)angle, (int)0, (int)180))), 2);
    }

    public int getAngle(World worldIn, BlockPos pos) {
        return (Integer)worldIn.func_180495_p(pos).func_177229_b((Property)ANGLE);
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (player instanceof FakePlayer) {
            return;
        }
        if (world instanceof ServerWorld) {
            ItemStack cloneItemStack = this.func_185473_a((IBlockReader)world, pos, state);
            world.func_175655_b(pos, false);
            if (world.func_180495_p(pos) != state && !world.func_201670_d()) {
                if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == Items.field_190931_a) {
                    player.func_184611_a(Hand.MAIN_HAND, cloneItemStack);
                } else {
                    player.field_71071_by.func_191975_a(world, cloneItemStack);
                }
            }
        }
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        if (world instanceof ServerWorld) {
            ItemStack cloneItemStack = this.func_185473_a((IBlockReader)world, pos, state);
            if (world.func_180495_p(pos) != state && !world.func_201670_d()) {
                world.func_217376_c((Entity)new ItemEntity(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() - 0.5f), (double)((float)pos.func_177952_p() + 0.5f), cloneItemStack));
            }
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack item = new ItemStack((IItemProvider)this);
        Optional<TileEntity> tileEntityOptional = Optional.ofNullable(this.getTileEntity(worldIn, pos));
        CompoundNBT tag = item.func_196082_o();
        CompoundNBT inv = tileEntityOptional.map(coffer -> coffer.itemHandler.serializeNBT()).orElse(new CompoundNBT());
        tag.func_218657_a("Inventory", (INBT)inv);
        ITextComponent customName = tileEntityOptional.map(CofferTile::func_200201_e).orElse(null);
        if (customName != null) {
            item.func_200302_a(customName);
        }
        return item;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            ((CofferTile)tileentity).field_213909_b = stack.func_200301_q();
        }
        if (worldIn.func_201670_d()) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> te.readInventory(stack.func_196082_o().func_74775_l("Inventory")));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT inv = stack.func_196082_o().func_74775_l("Inventory");
        ListNBT tagList = inv.func_150295_c("Items", 10);
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("\u00a7e--------------\u00a7r"));
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT itemTags = tagList.func_150305_b(i);
                TranslationTextComponent itemText = new TranslationTextComponent(ItemStack.func_199557_a((CompoundNBT)itemTags).func_77977_a());
                int countText = ItemStack.func_199557_a((CompoundNBT)itemTags).func_190916_E();
                itemText.func_240702_b_(" x" + countText);
                tooltip.add((ITextComponent)itemText);
            }
            if (tagList.size() < 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("Can be placed in the world."));
                tooltip.add((ITextComponent)new TranslationTextComponent("Can store items and be moved like a shulker box."));
                tooltip.add((ITextComponent)new TranslationTextComponent("Can be renamed."));
                tooltip.add((ITextComponent)new TranslationTextComponent("Punch the Coffer to pick up directly to your inventory."));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("\u00a7e--------------\u00a7r"));
            for (int i = 0; i < Math.min(tagList.size(), 3); ++i) {
                CompoundNBT itemTags = tagList.func_150305_b(i);
                TranslationTextComponent itemText = new TranslationTextComponent(ItemStack.func_199557_a((CompoundNBT)itemTags).func_77977_a());
                int countText = ItemStack.func_199557_a((CompoundNBT)itemTags).func_190916_E();
                itemText.func_240702_b_(" x" + countText);
                tooltip.add((ITextComponent)itemText);
            }
            if (tagList.size() > 3) {
                tooltip.add((ITextComponent)new TranslationTextComponent(". . . "));
                tooltip.add((ITextComponent)new TranslationTextComponent(""));
                tooltip.add((ITextComponent)new TranslationTextComponent("Hold \u00a7eSHIFT\u00a7r to see more"));
            } else if (tagList.size() < 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.hexerei.coffer"));
            }
        }
        super.func_190948_a(stack, world, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
    }

    private INamedContainerProvider createContainerProvider(final World worldIn, final BlockPos pos) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                if (((CofferTile)worldIn.func_175625_s((BlockPos)pos)).field_213909_b != null) {
                    return new TranslationTextComponent(((CofferTile)worldIn.func_175625_s((BlockPos)pos)).field_213909_b.getString());
                }
                return new TranslationTextComponent("screen.hexerei.coffer");
            }

            @Nullable
            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new CofferContainer(i, worldIn, pos, playerInventory, playerEntity);
            }
        };
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        TileEntity te = ((TileEntityType)ModTileEntities.COFFER_TILE.get()).func_200968_a();
        return te;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public Class<CofferTile> getTileEntityClass() {
        return CofferTile.class;
    }
}

