/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.CreatureAITargetItems;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.DirectPathNavigator;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.ITargetsDroppedItems;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CrowEntity
extends AnimalEntity
implements ITargetsDroppedItems {
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(CrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> FLIGHT_LOOK_YAW = EntityDataManager.func_187226_a(CrowEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> ATTACK_TICK = EntityDataManager.func_187226_a(CrowEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(CrowEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public boolean aiItemFlag = false;
    private boolean isLandNavigator;
    private int timeFlying;
    private BlockPos orbitPos = null;
    private double orbitDist = 5.0;
    private boolean orbitClockwise = false;
    private boolean fallFlag = false;
    private int flightLookCooldown = 0;
    private float targetFlightLookYaw;
    private int heldItemTime = 0;
    public int treasureSitTime;
    public UUID feederUUID = null;

    public CrowEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, 16.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
        this.switchNavigator(false);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187660_W;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187666_Z;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187663_X;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, (double)0.2f);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Flying", this.isFlying());
        compound.func_74757_a("Sitting", this.isSitting());
        if (this.feederUUID != null) {
            compound.func_186854_a("FeederUUID", this.feederUUID);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFlying(compound.func_74767_n("Flying"));
        this.setSitting(compound.func_74767_n("Sitting"));
        if (compound.func_186855_b("FeederUUID")) {
            this.feederUUID = compound.func_186857_a("FeederUUID");
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151080_bb, Items.field_151081_bc, Items.field_185163_cU, Items.field_151014_N}), false){

            public boolean func_75250_a() {
                return !CrowEntity.this.aiItemFlag && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(5, (Goal)new AIWanderIdle());
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, CreatureEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new AITargetItems((CreatureEntity)this, false, false, 15, 16));
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == Items.field_151080_bb;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new MoveHelper(this);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
        this.field_70180_af.func_187214_a(ATTACK_TICK, (Object)0);
        this.field_70180_af.func_187214_a(FLIGHT_LOOK_YAW, (Object)Float.valueOf(0.0f));
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sitting);
    }

    public float getFlightLookYaw() {
        return ((Float)this.field_70180_af.func_187225_a(FLIGHT_LOOK_YAW)).floatValue();
    }

    public void setFlightLookYaw(float yaw) {
        this.field_70180_af.func_187227_b(FLIGHT_LOOK_YAW, (Object)Float.valueOf(yaw));
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.func_70631_g_()) {
            flying = false;
        }
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float yMot = (float)(-((double)((float)this.func_213322_ci().field_72448_b) * 57.2957763671875));
        float absYaw = Math.abs(this.field_70177_z - this.field_70126_B);
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFlying()) {
                float lookYawDist = Math.abs(this.getFlightLookYaw() - this.targetFlightLookYaw);
                if (this.flightLookCooldown > 0) {
                    --this.flightLookCooldown;
                }
                if (this.flightLookCooldown == 0 && this.field_70146_Z.nextInt(4) == 0 && lookYawDist < 0.5f) {
                    this.targetFlightLookYaw = MathHelper.func_76131_a((float)(this.field_70146_Z.nextFloat() * 120.0f - 60.0f), (float)-60.0f, (float)60.0f);
                    this.flightLookCooldown = 3 + this.field_70146_Z.nextInt(15);
                }
                if (this.getFlightLookYaw() < this.targetFlightLookYaw && lookYawDist > 0.5f) {
                    this.setFlightLookYaw(this.getFlightLookYaw() + Math.min(lookYawDist, 4.0f));
                }
                if (this.getFlightLookYaw() > this.targetFlightLookYaw && lookYawDist > 0.5f) {
                    this.setFlightLookYaw(this.getFlightLookYaw() - Math.min(lookYawDist, 4.0f));
                }
                if (this.field_70122_E && !this.func_203005_aq() && this.timeFlying > 30) {
                    this.setFlying(false);
                }
                ++this.timeFlying;
                this.func_189654_d(true);
                if (this.func_184218_aH() || this.func_70880_s()) {
                    this.setFlying(false);
                }
            } else {
                this.fallFlag = false;
                this.timeFlying = 0;
                this.func_189654_d(false);
            }
            if (this.isFlying() && this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (!this.isFlying() && !this.isLandNavigator) {
                this.switchNavigator(true);
            }
        }
        if (!this.func_184614_ca().func_190926_b()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 200 && this.canTargetItem(this.func_184614_ca())) {
                this.heldItemTime = 0;
                this.func_70691_i(4.0f);
                this.func_184185_a(SoundEvents.field_187537_bA, this.func_70599_aP(), this.func_70647_i());
                if (this.func_184614_ca().hasContainerItem()) {
                    this.func_199701_a_(this.func_184614_ca().getContainerItem());
                }
                this.eatItemEffect(this.func_184614_ca());
                this.func_184614_ca().func_190918_g(1);
            }
        } else {
            this.heldItemTime = 0;
        }
        if (this.treasureSitTime > 0) {
            --this.treasureSitTime;
        }
        if (this.isSitting() && this.func_203005_aq()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)0.02f, 0.0));
        }
    }

    public void eatItem() {
        this.heldItemTime = 200;
    }

    private void eatItemEffect(ItemStack heldItemMainhand) {
        for (int i = 0; i < 2 + this.field_70146_Z.nextInt(2); ++i) {
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            float radius = this.func_213311_cf() * 0.65f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            ItemParticleData data = new ItemParticleData(ParticleTypes.field_197591_B, heldItemMainhand);
            if (heldItemMainhand.func_77973_b() instanceof BlockItem) {
                data = new BlockParticleData(ParticleTypes.field_197611_d, ((BlockItem)heldItemMainhand.func_77973_b()).func_179223_d().func_176223_P());
            }
            this.field_70170_p.func_195594_a((IParticleData)data, this.func_226277_ct_() + extraX, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.6f), this.func_226281_cx_() + extraZ, d0, d1, d2);
        }
    }

    public Vector3d getBlockInViewAway(Vector3d fleePos, float radiusAdd) {
        float radius = 5.0f + radiusAdd + (float)this.func_70681_au().nextInt(5);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, 0.0, fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getCrowGround(radialPos);
        int distFromGround = (int)this.func_226278_cu_() - ground.func_177956_o();
        int flightHeight = 8 + this.func_70681_au().nextInt(4);
        BlockPos newPos = ground.func_177981_b(distFromGround > 3 ? flightHeight : this.func_70681_au().nextInt(4) + 8);
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 1.0) {
            return Vector3d.func_237489_a_((Vector3i)newPos);
        }
        return null;
    }

    public Vector3d getBlockGrounding(Vector3d fleePos) {
        float radius = 10 + this.func_70681_au().nextInt(15);
        float neg = this.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.field_70761_aq;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.func_70681_au().nextFloat() * neg;
        double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * MathHelper.func_76134_b((float)angle);
        BlockPos radialPos = new BlockPos(fleePos.func_82615_a() + extraX, this.func_226278_cu_(), fleePos.func_82616_c() + extraZ);
        BlockPos ground = this.getCrowGround(radialPos);
        if (ground.func_177956_o() == 0) {
            return this.func_213303_ch();
        }
        ground = this.func_233580_cy_();
        while (ground.func_177956_o() > 2 && this.field_70170_p.func_175623_d(ground)) {
            ground = ground.func_177977_b();
        }
        if (!this.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)ground.func_177984_a()))) {
            return Vector3d.func_237489_a_((Vector3i)ground);
        }
        return null;
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.func_233580_cy_();
        while (position.func_177956_o() > 0 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return !this.field_70170_p.func_204610_c(position).func_206888_e() || position.func_177956_o() <= 0;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (!this.func_184614_ca().func_190926_b() && type != ActionResultType.SUCCESS) {
            this.func_199701_a_(this.func_184614_ca().func_77946_l());
            this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private Vector3d getOrbitVec(Vector3d vector3d, float gatheringCircleDist) {
        Vector3d pos;
        float angle = (float)Math.PI / 180 * (float)this.orbitDist * (float)(this.orbitClockwise ? -this.field_70173_aa : this.field_70173_aa);
        double extraX = gatheringCircleDist * MathHelper.func_76126_a((float)angle);
        double extraZ = gatheringCircleDist * MathHelper.func_76134_b((float)angle);
        if (this.orbitPos != null && this.field_70170_p.func_175623_d(new BlockPos(pos = new Vector3d((double)this.orbitPos.func_177958_n() + extraX, (double)(this.orbitPos.func_177956_o() + this.field_70146_Z.nextInt(2)), (double)this.orbitPos.func_177952_p() + extraZ)))) {
            return pos;
        }
        return null;
    }

    public BlockPos getCrowGround(BlockPos in) {
        BlockPos position = new BlockPos((double)in.func_177958_n(), this.func_226278_cu_(), (double)in.func_177952_p());
        while (position.func_177956_o() < 256 && !this.field_70170_p.func_204610_c(position).func_206888_e()) {
            position = position.func_177984_a();
        }
        while (position.func_177956_o() > 2 && this.field_70170_p.func_175623_d(position)) {
            position = position.func_177977_b();
        }
        return position;
    }

    public void func_213352_e(Vector3d vec3d) {
        if (this.isSitting()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        PlayerEntity player;
        ItemStack duplicate = e.func_92059_d().func_77946_l();
        duplicate.func_190920_e(1);
        if (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(this.func_184586_b(Hand.MAIN_HAND), 0.0f);
        }
        if (e.func_200214_m() != null && (e.func_92059_d().func_77973_b() == Items.field_151014_N || e.func_92059_d().func_77973_b() == Items.field_151080_bb || e.func_92059_d().func_77973_b() == Items.field_151081_bc || e.func_92059_d().func_77973_b() == Items.field_185163_cU) && (player = this.field_70170_p.func_217371_b(e.func_200214_m())) != null) {
            this.feederUUID = e.func_200214_m();
        }
        this.setFlying(true);
        this.func_184611_a(Hand.MAIN_HAND, duplicate);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.func_77973_b().equals(Items.field_151014_N) && !this.isSitting();
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        return (AgeableEntity)((EntityType)ModEntityTypes.CROW.get()).func_200721_a((World)world);
    }

    private class AITargetItems
    extends CreatureAITargetItems {
        public AITargetItems(CreatureEntity creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
            super(creature, checkSight, onlyNearby, tickThreshold, radius);
            this.executionChance = 1;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            ((CrowEntity)this.field_75299_d).aiItemFlag = false;
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !((CrowEntity)this.field_75299_d).isSitting() && (this.field_75299_d.func_70638_az() == null || !this.field_75299_d.func_70638_az().func_70089_S());
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && !((CrowEntity)this.field_75299_d).isSitting() && (this.field_75299_d.func_70638_az() == null || !this.field_75299_d.func_70638_az().func_70089_S());
        }

        @Override
        protected void moveTo() {
            CrowEntity crow = (CrowEntity)this.field_75299_d;
            if (this.targetEntity != null) {
                crow.aiItemFlag = true;
                if (this.field_75299_d.func_70032_d((Entity)this.targetEntity) < 2.0f) {
                    crow.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.5);
                }
                if (this.field_75299_d.func_70032_d((Entity)this.targetEntity) > 8.0f || crow.isFlying()) {
                    crow.setFlying(true);
                    float f = (float)(crow.func_226277_ct_() - this.targetEntity.func_226277_ct_());
                    float f1 = 1.8f;
                    float f2 = (float)(crow.func_226281_cx_() - this.targetEntity.func_226281_cx_());
                    float xzDist = MathHelper.func_76129_c((float)(f * f + f2 * f2));
                    if (!crow.func_70685_l((Entity)this.targetEntity)) {
                        crow.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), 1.0 + crow.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.5);
                    } else {
                        if (xzDist < 5.0f) {
                            f1 = 0.0f;
                        }
                        crow.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), (double)f1 + this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.5);
                    }
                } else {
                    this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.5);
                }
            }
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            this.moveTo();
        }
    }

    class MoveHelper
    extends MovementController {
        private final CrowEntity parentEntity;

        public MoveHelper(CrowEntity bird) {
            super((MobEntity)bird);
            this.parentEntity = bird;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d5 = vector3d.func_72433_c();
                if (d5 < 0.3) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_186678_a(0.5));
                } else {
                    double d1 = this.field_75647_c - this.parentEntity.func_226278_cu_();
                    float yScale = d1 > 0.0 || CrowEntity.this.fallFlag ? 1.0f : 0.7f;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.03 / d5)));
                    Vector3d vector3d1 = this.parentEntity.func_213322_ci();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                }
            }
        }
    }

    private class AIWanderIdle
    extends Goal {
        protected final CrowEntity crow;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;
        private int orbitResetCooldown = 0;
        private int maxOrbitTime = 360;
        private int orbitTime = 0;

        public AIWanderIdle() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.crow = CrowEntity.this;
        }

        public boolean func_75250_a() {
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.crow.func_70638_az() != null && this.crow.func_70638_az().func_70089_S() && !this.crow.func_184207_aI() || this.crow.isSitting() || this.crow.func_184218_aH()) {
                return false;
            }
            if (this.crow.func_70681_au().nextInt(20) != 0 && !this.crow.isFlying() || this.crow.aiItemFlag) {
                return false;
            }
            if (this.crow.func_70631_g_()) {
                this.flightTarget = false;
            } else if (this.crow.func_203005_aq()) {
                this.flightTarget = true;
            } else if (this.crow.func_233570_aj_()) {
                this.flightTarget = CrowEntity.this.field_70146_Z.nextInt(10) == 0;
            } else {
                if (this.orbitResetCooldown == 0 && CrowEntity.this.field_70146_Z.nextInt(6) == 0) {
                    this.orbitResetCooldown = 100 + CrowEntity.this.field_70146_Z.nextInt(300);
                    this.crow.orbitPos = this.crow.func_233580_cy_();
                    this.crow.orbitDist = 4 + CrowEntity.this.field_70146_Z.nextInt(5);
                    this.crow.orbitClockwise = CrowEntity.this.field_70146_Z.nextBoolean();
                    this.orbitTime = 0;
                    this.maxOrbitTime = (int)(180.0f + 360.0f * CrowEntity.this.field_70146_Z.nextFloat());
                }
                this.flightTarget = CrowEntity.this.field_70146_Z.nextInt(5) != 0 && this.crow.timeFlying < 400;
            }
            Vector3d lvt_1_1_ = this.getPosition();
            if (lvt_1_1_ == null) {
                return false;
            }
            this.x = lvt_1_1_.field_72450_a;
            this.y = lvt_1_1_.field_72448_b;
            this.z = lvt_1_1_.field_72449_c;
            return true;
        }

        public void func_75246_d() {
            if (this.orbitResetCooldown > 0) {
                --this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown < 0) {
                ++this.orbitResetCooldown;
            }
            if (this.orbitResetCooldown > 0 && this.crow.orbitPos != null) {
                if (this.orbitTime < this.maxOrbitTime && !this.crow.func_203005_aq()) {
                    ++this.orbitTime;
                } else {
                    this.orbitTime = 0;
                    this.crow.orbitPos = null;
                    this.orbitResetCooldown = -400 - CrowEntity.this.field_70146_Z.nextInt(400);
                }
            }
            if (this.crow.field_70123_F && !this.crow.field_70122_E) {
                this.func_75251_c();
            }
            if (this.flightTarget) {
                this.crow.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else if (this.crow.isFlying() && !this.crow.field_70122_E) {
                if (!this.crow.func_203005_aq()) {
                    // empty if block
                }
            } else {
                this.crow.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
            if (!this.flightTarget && CrowEntity.this.isFlying()) {
                this.crow.fallFlag = true;
                if (this.crow.field_70122_E) {
                    this.crow.setFlying(false);
                    this.orbitTime = 0;
                    this.crow.orbitPos = null;
                    this.orbitResetCooldown = -400 - CrowEntity.this.field_70146_Z.nextInt(400);
                }
            }
            if (CrowEntity.this.isFlying() && (!CrowEntity.this.field_70170_p.func_175623_d(this.crow.func_226270_aj_()) || this.crow.field_70122_E) && !this.crow.func_203005_aq() && this.crow.timeFlying > 30) {
                this.crow.setFlying(false);
                this.orbitTime = 0;
                this.crow.orbitPos = null;
                this.orbitResetCooldown = -400 - CrowEntity.this.field_70146_Z.nextInt(400);
            }
        }

        @Nullable
        protected Vector3d getPosition() {
            Vector3d vector3d = this.crow.func_213303_ch();
            if (this.orbitResetCooldown > 0 && this.crow.orbitPos != null) {
                return this.crow.getOrbitVec(vector3d, 4 + CrowEntity.this.field_70146_Z.nextInt(4));
            }
            if (this.crow.func_184207_aI() || this.crow.isOverWaterOrVoid()) {
                this.flightTarget = true;
            }
            if (this.flightTarget) {
                if (this.crow.timeFlying < 340 || this.crow.func_184207_aI() || this.crow.isOverWaterOrVoid()) {
                    return this.crow.getBlockInViewAway(vector3d, 0.0f);
                }
                return this.crow.getBlockGrounding(vector3d);
            }
            return RandomPositionGenerator.func_75463_a((CreatureEntity)this.crow, (int)10, (int)7);
        }

        public boolean func_75253_b() {
            if (this.flightTarget) {
                return this.crow.isFlying() && this.crow.func_70092_e(this.x, this.y, this.z) > 4.0;
            }
            return !this.crow.func_70661_as().func_75500_f() && !this.crow.func_184207_aI();
        }

        public void func_75249_e() {
            if (this.flightTarget) {
                this.crow.setFlying(true);
                this.crow.func_70605_aq().func_75642_a(this.x, this.y, this.z, 1.0);
            } else {
                this.crow.func_70661_as().func_75492_a(this.x, this.y, this.z, 1.0);
            }
        }

        public void func_75251_c() {
            this.crow.func_70661_as().func_75499_g();
            super.func_75251_c();
        }
    }
}

