/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.AbstractPigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.FoodHandler;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.IBirdAlteration;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.IPigeonFoodHandler;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.InteractionHandler;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.MasterHurtByTargetGoal;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.MasterHurtTargetGoal;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.MoveToSpecificBlockGoal;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonFollowMasterGoal;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonLocationStorage;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonReviveStorage;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonWanderGoal;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.Skill;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.SkillInstance;
import net.joefoxe.hexerei.util.Cache;
import net.joefoxe.hexerei.util.DataKey;
import net.joefoxe.hexerei.util.DimensionDependantArg;
import net.joefoxe.hexerei.util.EnumMode;
import net.joefoxe.hexerei.util.NBTUtilities;
import net.joefoxe.hexerei.util.PigeonAttributes;
import net.joefoxe.hexerei.util.PigeonLevel;
import net.joefoxe.hexerei.util.SerializersHexerei;
import net.joefoxe.hexerei.util.StatsTracker;
import net.joefoxe.hexerei.util.WorldUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.DataSerializerEntry;

public class PigeonEntity
extends AbstractPigeonEntity {
    private static final DataParameter<Optional<ITextComponent>> LAST_KNOWN_NAME = EntityDataManager.func_187226_a(PigeonEntity.class, (IDataSerializer)DataSerializers.field_200544_f);
    private static final DataParameter<Byte> PIGEON_FLAGS = EntityDataManager.func_187226_a(PigeonEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> HUNGER_INT = EntityDataManager.func_187226_a(PigeonEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<ItemStack> BONE_VARIANT = EntityDataManager.func_187226_a(PigeonEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final Cache<DataParameter<List<SkillInstance>>> SKILLS = Cache.make(() -> EntityDataManager.func_187226_a(PigeonEntity.class, (IDataSerializer)((DataSerializerEntry)SerializersHexerei.SKILL_SERIALIZER.get()).getSerializer()));
    private static final Cache<DataParameter<PigeonLevel>> PIGEON_LEVEL = Cache.make(() -> EntityDataManager.func_187226_a(PigeonEntity.class, (IDataSerializer)((DataSerializerEntry)SerializersHexerei.PIGEON_LEVEL_SERIALIZER.get()).getSerializer()));
    private static final Cache<DataParameter<EnumMode>> MODE = Cache.make(() -> EntityDataManager.func_187226_a(PigeonEntity.class, (IDataSerializer)((DataSerializerEntry)SerializersHexerei.MODE_SERIALIZER.get()).getSerializer()));
    private static final Cache<DataParameter<DimensionDependantArg<Optional<BlockPos>>>> BIRD_COFFER_LOCATION = Cache.make(() -> EntityDataManager.func_187226_a(PigeonEntity.class, (IDataSerializer)((DataSerializerEntry)SerializersHexerei.COFFER_LOC_SERIALIZER.get()).getSerializer()));
    private final Cache<Integer> spendablePoints = Cache.make(this::getSpendablePointsInternal);
    private final List<IBirdAlteration> alterations = new ArrayList<IBirdAlteration>(4);
    private final List<IPigeonFoodHandler> foodHandlers = new ArrayList<IPigeonFoodHandler>(4);
    public final Map<Integer, Object> objects = new HashMap<Integer, Object>();
    public final StatsTracker statsTracker = new StatsTracker();
    private int hungerTick;
    private int prevHungerTick;
    private int healingTick;
    private int prevHealingTick;
    protected BlockPos targetBlock;

    public static final void initDataParameters() {
        SKILLS.get();
        PIGEON_LEVEL.get();
        MODE.get();
        BIRD_COFFER_LOCATION.get();
    }

    public PigeonEntity(EntityType<? extends PigeonEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70903_f(false);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKILLS.get(), new ArrayList(4));
        this.field_70180_af.func_187214_a(LAST_KNOWN_NAME, Optional.empty());
        this.field_70180_af.func_187214_a(PIGEON_FLAGS, (Object)0);
        this.field_70180_af.func_187214_a(MODE.get(), (Object)EnumMode.DOCILE);
        this.field_70180_af.func_187214_a(HUNGER_INT, (Object)Float.valueOf(60.0f));
        this.field_70180_af.func_187214_a(PIGEON_LEVEL.get(), (Object)new PigeonLevel(0));
        this.field_70180_af.func_187214_a(BIRD_COFFER_LOCATION.get(), new DimensionDependantArg(() -> DataSerializers.field_187201_k));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveToSpecificBlockGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new PigeonWanderGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new PigeonFollowMasterGoal(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new MasterHurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new MasterHurtTargetGoal(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
    }

    public void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_192793_eq;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_192794_er;
    }

    protected void playEatingSound() {
        this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public float func_70599_aP() {
        return 0.4f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S()) {
            boolean inWater = this.func_70090_H();
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 40 == 0) {
                PigeonLocationStorage.get(this.field_70170_p).getOrCreateData(this).update(this);
                if (this.func_70902_q() != null) {
                    this.setOwnersName(this.func_70902_q().func_200200_C_());
                }
            }
        }
        this.alterations.forEach(alter -> alter.tick(this));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.prevHealingTick = this.healingTick;
            this.healingTick += 8;
            for (IBirdAlteration alter2 : this.alterations) {
                ActionResult<Integer> result = alter2.healingTick(this, this.healingTick - this.prevHealingTick);
                if (!result.func_188397_a().func_226247_b_()) continue;
                this.healingTick = (Integer)result.func_188398_b() + this.prevHealingTick;
            }
            if (this.healingTick >= 6000) {
                if (this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_70691_i(1.0f);
                }
                this.healingTick = 0;
            }
        }
        this.alterations.forEach(alter -> alter.livingTick(this));
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        Optional<IPigeonFoodHandler> foodHandler = FoodHandler.getMatch(this, stack, (Entity)player);
        if (foodHandler.isPresent()) {
            this.playEatingSound();
            return foodHandler.get().consume(this, stack, (Entity)player);
        }
        ActionResultType interactResult = InteractionHandler.getMatch(this, stack, player, hand, this.field_70170_p);
        if (interactResult != ActionResultType.PASS) {
            return interactResult;
        }
        for (IBirdAlteration alter : this.alterations) {
            ActionResultType result = alter.processInteract(this, this.field_70170_p, player, hand);
            if (result == ActionResultType.PASS) continue;
            return result;
        }
        ActionResultType actionresulttype = super.func_230254_b_(player, hand);
        if ((!actionresulttype.func_226246_a_() || this.func_70631_g_()) && this.canInteract((LivingEntity)player)) {
            this.func_70661_as().func_75499_g();
            this.setTargetBlock(null);
            return ActionResultType.SUCCESS;
        }
        return actionresulttype;
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean func_213336_c(LivingEntity target) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IBirdAlteration alter : this.alterations) {
            ActionResultType result = alter.canAttack(this, target);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        if (target instanceof CreeperEntity) {
            return false;
        }
        return super.func_213336_c(target);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (this.isMode(EnumMode.DOCILE)) {
            return false;
        }
        for (IBirdAlteration alter : this.alterations) {
            ActionResultType result = alter.shouldAttackEntity(this, target, owner);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        if (target instanceof WolfEntity) {
            WolfEntity wolfentity = (WolfEntity)target;
            return !wolfentity.func_70909_n() || wolfentity.func_70902_q() != owner;
        }
        if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
            return false;
        }
        if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
            return false;
        }
        return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        for (IBirdAlteration alter : this.alterations) {
            ActionResult<Float> result = alter.attackEntityFrom(this, source, amount);
            if (result.func_188397_a() == ActionResultType.FAIL) {
                return false;
            }
            amount = ((Float)result.func_188398_b()).floatValue();
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76364_f();
        if (entity instanceof PlayerEntity && !this.canPlayersAttack()) {
            return false;
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity target) {
        boolean flag;
        for (IBirdAlteration alter : this.alterations) {
            ActionResultType result = alter.attackEntityAsMob(this, target);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        ModifiableAttributeInstance attackDamageInst = this.func_110148_a(Attributes.field_233823_f_);
        Set critModifiers = null;
        if (this.func_110148_a((Attribute)PigeonAttributes.CRIT_CHANCE.get()).func_111126_e() > this.field_70146_Z.nextDouble()) {
            critModifiers = this.func_110148_a((Attribute)PigeonAttributes.CRIT_BONUS.get()).func_225505_c_();
            critModifiers.forEach(arg_0 -> ((ModifiableAttributeInstance)attackDamageInst).func_233767_b_(arg_0));
        }
        int damage = (int)attackDamageInst.func_111126_e();
        if (critModifiers != null) {
            critModifiers.forEach(arg_0 -> ((ModifiableAttributeInstance)attackDamageInst).func_111124_b(arg_0));
        }
        if (flag = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)damage)) {
            this.func_174815_a((LivingEntity)this, target);
            this.statsTracker.increaseDamageDealt(damage);
            if (critModifiers != null) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71452_i.func_199282_a(target, (IParticleData)ParticleTypes.field_197614_g));
            }
        }
        return flag;
    }

    public void func_191956_a(Entity killed, int scoreValue, DamageSource damageSource) {
        super.func_191956_a(killed, scoreValue, damageSource);
        this.statsTracker.incrementKillCount(killed);
    }

    public boolean func_184583_d(DamageSource source) {
        for (IBirdAlteration alter : this.alterations) {
            ActionResultType result = alter.canBlockDamageSource(this, source);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_184583_d(source);
    }

    public void func_70015_d(int second) {
        for (IBirdAlteration alter : this.alterations) {
            ActionResult<Integer> result = alter.setFire(this, second);
            if (!result.func_188397_a().func_226247_b_()) continue;
            second = (Integer)result.func_188398_b();
        }
        super.func_70015_d(second);
    }

    public boolean func_230279_az_() {
        for (IBirdAlteration alter : this.alterations) {
            ActionResultType result = alter.isImmuneToFire(this);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_230279_az_();
    }

    public boolean func_180431_b(DamageSource source) {
        for (IBirdAlteration alter : this.alterations) {
            ActionResultType result = alter.isInvulnerableTo(this, source);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_180431_b(source);
    }

    public boolean func_190530_aW() {
        for (IBirdAlteration alter : this.alterations) {
            ActionResultType result = alter.isInvulnerable(this);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_190530_aW();
    }

    public boolean func_184603_cC() {
        return super.func_184603_cC();
    }

    public boolean func_70687_e(EffectInstance effectIn) {
        for (IBirdAlteration alter : this.alterations) {
            ActionResultType result = alter.isPotionApplicable(this, effectIn);
            if (result.func_226247_b_()) {
                return true;
            }
            if (result != ActionResultType.FAIL) continue;
            return false;
        }
        return super.func_70687_e(effectIn);
    }

    public void func_184221_a(UUID uniqueIdIn) {
        UUID oldUniqueId = this.func_110124_au();
        if (uniqueIdIn.equals(oldUniqueId)) {
            return;
        }
        super.func_184221_a(uniqueIdIn);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            PigeonLocationStorage.get(this.field_70170_p).remove(oldUniqueId);
            PigeonLocationStorage.get(this.field_70170_p).getOrCreateData(this).update(this);
        }
    }

    public void func_193101_c(PlayerEntity player) {
        super.func_193101_c(player);
        this.setOwnersName(player.func_200200_C_());
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(80.0);
            this.func_70606_j(80.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(80.0);
        }
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(6.0);
    }

    public void func_184754_b(@Nullable UUID uuid) {
        super.func_184754_b(uuid);
        if (uuid == null) {
            this.setOwnersName((ITextComponent)null);
        }
    }

    public AgeableEntity func_241840_a(ServerWorld worldIn, AgeableEntity partner) {
        PigeonEntity child = (PigeonEntity)((EntityType)ModEntityTypes.PIGEON.get()).func_200721_a((World)worldIn);
        UUID uuid = this.func_70902_q().func_110124_au();
        if (uuid != null) {
            child.func_184754_b(uuid);
            child.func_70903_f(true);
        }
        if (partner instanceof PigeonEntity) {
            child.setLevel(this.getLevel().combine(((PigeonEntity)partner).getLevel()));
        }
        return child;
    }

    public boolean func_94059_bO() {
        return this.func_145818_k_() || super.func_94059_bO();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.alterations == null) {
            return super.getCapability(cap, side);
        }
        for (IBirdAlteration alter : this.alterations) {
            LazyOptional<T> result = alter.getCapability(this, cap, side);
            if (result == null) continue;
            return result;
        }
        return super.getCapability(cap, side);
    }

    public Entity changeDimension(ServerWorld worldIn, ITeleporter teleporter) {
        Entity transportedEntity = super.changeDimension(worldIn, teleporter);
        if (transportedEntity instanceof PigeonEntity) {
            PigeonLocationStorage.get(this.field_70170_p).getOrCreateData(this).update((PigeonEntity)transportedEntity);
        }
        return transportedEntity;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
    }

    public void revive() {
        super.revive();
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ != 19 || this.field_70170_p == null || !this.field_70170_p.field_72995_K) {
            // empty if block
        }
        super.func_70609_aI();
    }

    public void func_70645_a(DamageSource cause) {
        this.alterations.forEach(alter -> alter.onDeath(this, cause));
        super.func_70645_a(cause);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            PigeonReviveStorage.get(this.field_70170_p).putData(this);
            PigeonLocationStorage.get(this.field_70170_p).remove(this);
        }
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.alterations.forEach(alter -> alter.invalidateCapabilities(this));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ListNBT skillList = new ListNBT();
        List<SkillInstance> skills = this.getSkillMap();
        for (int i = 0; i < skills.size(); ++i) {
            CompoundNBT skillTag = new CompoundNBT();
            skills.get(i).writeInstance(this, skillTag);
            skillList.add((Object)skillTag);
        }
        compound.func_218657_a("skills", (INBT)skillList);
        compound.func_74778_a("mode", this.getMode().getSaveName());
        this.getOwnersName().ifPresent(comp -> NBTUtilities.putTextComponent(compound, "lastKnownOwnerName", comp));
        compound.func_74757_a("willObey", this.willObeyOthers());
        compound.func_74757_a("friendlyFire", this.canPlayersAttack());
        compound.func_74768_a("level_normal", this.getLevel().getLevel(PigeonLevel.Type.NORMAL));
        NBTUtilities.writeItemStack(compound, "fetchItem", this.getBoneVariant());
        DimensionDependantArg cofferData = (DimensionDependantArg)this.field_70180_af.func_187225_a(BIRD_COFFER_LOCATION.get());
        if (!cofferData.isEmpty()) {
            ListNBT bedsList = new ListNBT();
            for (Map.Entry entry : cofferData.entrySet()) {
                CompoundNBT bedNBT = new CompoundNBT();
                NBTUtilities.putResourceLocation(bedNBT, "dim", entry.getKey().func_240901_a_());
                NBTUtilities.putBlockPos(bedNBT, "pos", (Optional)entry.getValue());
                bedsList.add((Object)bedNBT);
            }
            compound.func_218657_a("coffers", (INBT)bedsList);
        }
        this.statsTracker.writeAdditional(compound);
        this.alterations.forEach(alter -> alter.onWrite(this, compound));
    }

    /*
     * Exception decompiling
     */
    public void func_70020_e(CompoundNBT compound) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$TooOptimisticMatchException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.getString(SwitchStringRewriter.java:404)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.access$600(SwitchStringRewriter.java:53)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter$SwitchStringMatchResultCollector.collectMatches(SwitchStringRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.KleeneN.match(KleeneN.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.MatchSequence.match(MatchSequence.java:26)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.matchutil.ResetAfterTest.match(ResetAfterTest.java:23)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewriteComplex(SwitchStringRewriter.java:201)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchStringRewriter.rewrite(SwitchStringRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:881)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        List<SkillInstance> skillMap = this.getSkillMap();
        skillMap.clear();
        if (compound.func_150297_b("skills", 9)) {
            ListNBT skillList = compound.func_150295_c("skills", 10);
            for (int i = 0; i < skillList.size(); ++i) {
                SkillInstance.readInstance(this, skillList.func_150305_b(i)).ifPresent(skillMap::add);
            }
        }
        this.markDataParameterDirty(SKILLS.get(), false);
        this.recalculateAlterationsCache();
        this.spendablePoints.markForRefresh();
        try {
            for (IBirdAlteration inst : this.alterations) {
                inst.init(this);
            }
        }
        catch (Exception e) {
            Hexerei.LOGGER.error("Failed to init alteration: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            if (compound.func_150297_b("mode", 8)) {
                this.setMode(EnumMode.bySaveName(compound.func_74779_i("mode")));
            }
            if (compound.func_150297_b("fetchItem", 10)) {
                this.setBoneVariant(NBTUtilities.readItemStack(compound, "fetchItem"));
            }
            this.setOwnersName(NBTUtilities.getTextComponent(compound, "lastKnownOwnerName"));
            this.setWillObeyOthers(compound.func_74767_n("willObey"));
            this.setCanPlayersAttack(compound.func_74767_n("friendlyFire"));
        }
        catch (Exception e) {
            Hexerei.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            if (compound.func_150297_b("level_normal", 99)) {
                this.getLevel().setLevel(compound.func_74762_e("level_normal"));
                this.markDataParameterDirty(PIGEON_LEVEL.get());
            }
        }
        catch (Exception e) {
            Hexerei.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        DimensionDependantArg<Optional<BlockPos>> cofferData = ((DimensionDependantArg)this.field_70180_af.func_187225_a(BIRD_COFFER_LOCATION.get())).copyEmpty();
        try {
            if (compound.func_150297_b("coffers", 9)) {
                ListNBT bedsList = compound.func_150295_c("coffers", 10);
                for (int i = 0; i < bedsList.size(); ++i) {
                    CompoundNBT bedNBT = bedsList.func_150305_b(i);
                    ResourceLocation loc = NBTUtilities.getResourceLocation(bedNBT, "dim");
                    RegistryKey type = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)loc);
                    Optional<BlockPos> pos = NBTUtilities.getBlockPos(bedNBT, "pos");
                    cofferData.put((RegistryKey<World>)type, pos);
                }
            }
        }
        catch (Exception e) {
            Hexerei.LOGGER.error("Failed to load coffers: " + e.getMessage());
            e.printStackTrace();
        }
        this.field_70180_af.func_187227_b(BIRD_COFFER_LOCATION.get(), cofferData);
        try {
            this.statsTracker.readAdditional(compound);
        }
        catch (Exception e) {
            Hexerei.LOGGER.error("Failed to load stats tracker: " + e.getMessage());
            e.printStackTrace();
        }
        this.alterations.forEach(alter -> {
            try {
                alter.onRead(this, compound);
            }
            catch (Exception e) {
                Hexerei.LOGGER.error("Failed to load alteration: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (SKILLS.get().equals(key)) {
            this.recalculateAlterationsCache();
            for (IBirdAlteration inst : this.alterations) {
                inst.init(this);
            }
        }
        if (SKILLS.get().equals(key)) {
            this.spendablePoints.markForRefresh();
        }
        if (PIGEON_LEVEL.get().equals(key)) {
            this.spendablePoints.markForRefresh();
        }
    }

    public void recalculateAlterationsCache() {
        this.alterations.clear();
        this.foodHandlers.clear();
    }

    @Override
    public boolean canInteract(LivingEntity livingEntity) {
        return this.willObeyOthers() || this.func_152114_e(livingEntity);
    }

    public Optional<ITextComponent> getOwnersName() {
        return (Optional)this.field_70180_af.func_187225_a(LAST_KNOWN_NAME);
    }

    public void setOwnersName(@Nullable ITextComponent comp) {
        this.setOwnersName(Optional.ofNullable(comp));
    }

    public void setOwnersName(Optional<ITextComponent> collar) {
        this.field_70180_af.func_187227_b(LAST_KNOWN_NAME, collar);
    }

    public static Cache<DataParameter<EnumMode>> getMODE() {
        return MODE;
    }

    @Override
    public EnumMode getMode() {
        return (EnumMode)((Object)this.field_70180_af.func_187225_a(MODE.get()));
    }

    public boolean isMode(EnumMode ... modes) {
        EnumMode mode = this.getMode();
        for (EnumMode test : modes) {
            if (mode != test) continue;
            return true;
        }
        return false;
    }

    public void setMode(EnumMode collar) {
        this.field_70180_af.func_187227_b(MODE.get(), (Object)collar);
    }

    public Optional<BlockPos> getBedPos() {
        return this.getBedPos((RegistryKey<World>)this.field_70170_p.func_234923_W_());
    }

    public Optional<BlockPos> getBedPos(RegistryKey<World> registryKey) {
        return ((DimensionDependantArg)this.field_70180_af.func_187225_a(BIRD_COFFER_LOCATION.get())).getOrDefault(registryKey, Optional.empty());
    }

    public void setBedPos(@Nullable BlockPos pos) {
        this.setBedPos((RegistryKey<World>)this.field_70170_p.func_234923_W_(), pos);
    }

    public void setBedPos(RegistryKey<World> registryKey, @Nullable BlockPos pos) {
        this.setBedPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBedPos(RegistryKey<World> registryKey, Optional<BlockPos> pos) {
        this.field_70180_af.func_187227_b(BIRD_COFFER_LOCATION.get(), ((DimensionDependantArg)this.field_70180_af.func_187225_a(BIRD_COFFER_LOCATION.get())).copy().set(registryKey, pos));
    }

    @Override
    public PigeonLevel getLevel() {
        return (PigeonLevel)this.field_70180_af.func_187225_a(PIGEON_LEVEL.get());
    }

    public void setLevel(PigeonLevel level) {
        this.field_70180_af.func_187227_b(PIGEON_LEVEL.get(), (Object)level);
    }

    @Override
    public void increaseLevel(PigeonLevel.Type typeIn) {
        this.getLevel().incrementLevel(typeIn);
        this.markDataParameterDirty(PIGEON_LEVEL.get());
    }

    public void setBoneVariant(ItemStack stack) {
        this.field_70180_af.func_187227_b(BONE_VARIANT, (Object)stack);
    }

    public ItemStack getBoneVariant() {
        return (ItemStack)this.field_70180_af.func_187225_a(BONE_VARIANT);
    }

    private boolean getPigeonFlag(int bit) {
        return ((Byte)this.field_70180_af.func_187225_a(PIGEON_FLAGS) & bit) != 0;
    }

    private void setPigeonFlag(int bits, boolean flag) {
        byte c = (Byte)this.field_70180_af.func_187225_a(PIGEON_FLAGS);
        this.field_70180_af.func_187227_b(PIGEON_FLAGS, (Object)((byte)(flag ? c | bits : c & ~bits)));
    }

    public void setWillObeyOthers(boolean obeyOthers) {
        this.setPigeonFlag(2, obeyOthers);
    }

    public boolean willObeyOthers() {
        return this.getPigeonFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setPigeonFlag(4, flag);
    }

    public boolean canPlayersAttack() {
        return this.getPigeonFlag(4);
    }

    public List<SkillInstance> getSkillMap() {
        return (List)this.field_70180_af.func_187225_a(SKILLS.get());
    }

    public void setSkillMap(List<SkillInstance> map) {
        this.field_70180_af.func_187227_b(SKILLS.get(), map);
    }

    public ActionResultType setSkillLevel(Skill skill, int level) {
        if (0 > level || level > skill.getMaxLevel()) {
            return ActionResultType.FAIL;
        }
        List<SkillInstance> activeSkills = this.getSkillMap();
        SkillInstance inst = null;
        for (SkillInstance activeInst : activeSkills) {
            if (!activeInst.of(skill)) continue;
            inst = activeInst;
            break;
        }
        if (inst == null) {
            if (level == 0) {
                return ActionResultType.PASS;
            }
            inst = skill.getDefault(level);
            activeSkills.add(inst);
            inst.init(this);
        } else {
            int previousLevel = inst.level();
            if (previousLevel == level) {
                return ActionResultType.PASS;
            }
            inst.setLevel(level);
            inst.set(this, previousLevel);
            if (level == 0) {
                activeSkills.remove(inst);
            }
        }
        this.markDataParameterDirty(SKILLS.get());
        return ActionResultType.SUCCESS;
    }

    public <T> void markDataParameterDirty(DataParameter<T> key) {
        this.markDataParameterDirty(key, true);
    }

    public <T> void markDataParameterDirty(DataParameter<T> key, boolean notify) {
        if (notify) {
            this.func_184206_a(key);
        }
        EntityDataManager.DataEntry dataentry = this.field_70180_af.func_187219_c(key);
        dataentry.func_187208_a(true);
        this.field_70180_af.field_187237_f = true;
    }

    @Override
    public Optional<SkillInstance> getSkill(Skill skillIn) {
        List<SkillInstance> activeSkills = this.getSkillMap();
        for (SkillInstance activeInst : activeSkills) {
            if (!activeInst.of(skillIn)) continue;
            return Optional.of(activeInst);
        }
        return Optional.empty();
    }

    @Override
    public int getLevel(Skill skillIn) {
        return this.getSkill(skillIn).map(SkillInstance::level).orElse(0);
    }

    @Override
    public <T> void setData(DataKey<T> key, T value) {
        if (key.isFinal() && this.hasData(key)) {
            throw new RuntimeException("Key is final but was tried to be set again.");
        }
        this.objects.put(key.getIndex(), value);
    }

    @Override
    public <T> void setDataIfEmpty(DataKey<T> key, T value) {
        if (!this.hasData(key)) {
            this.objects.put(key.getIndex(), value);
        }
    }

    @Override
    public <T> T getData(DataKey<T> key) {
        return (T)this.objects.get(key.getIndex());
    }

    @Override
    public <T> T getDataOrGet(DataKey<T> key, Supplier<T> other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other.get();
    }

    @Override
    public <T> T getDataOrDefault(DataKey<T> key, T other) {
        if (this.hasData(key)) {
            return this.getData(key);
        }
        return other;
    }

    @Override
    public <T> boolean hasData(DataKey<T> key) {
        return this.objects.containsKey(key.getIndex());
    }

    @Override
    public void untame() {
        this.func_70903_f(false);
        this.field_70699_by.func_75499_g();
        this.func_70606_j(8.0f);
        this.getSkillMap().clear();
        this.markDataParameterDirty(SKILLS.get());
        this.func_184754_b(null);
        this.setWillObeyOthers(false);
        this.setMode(EnumMode.DOCILE);
    }

    public boolean canSpendPoints(int amount) {
        return this.getSpendablePoints() >= amount;
    }

    private final int getSpendablePointsInternal() {
        int totalPoints = 15 + this.getLevel().getLevel(PigeonLevel.Type.NORMAL);
        for (SkillInstance entry : this.getSkillMap()) {
            totalPoints -= entry.getSkill().getCummulativeCost(entry.level());
        }
        return totalPoints;
    }

    public int getSpendablePoints() {
        return this.spendablePoints.get();
    }

    public boolean func_70067_L() {
        return super.func_70067_L();
    }

    public boolean func_70104_M() {
        return super.func_70104_M();
    }

    @Override
    public List<IPigeonFoodHandler> getFoodHandlers() {
        return this.foodHandlers;
    }

    public void setTargetBlock(BlockPos pos) {
        this.targetBlock = pos;
    }

    public BlockPos getTargetBlock() {
        return this.targetBlock;
    }
}

