/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.custom.AbstractPigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.IPigeonFoodHandler;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.IPigeonFoodPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class FoodHandler {
    private static final List<IPigeonFoodHandler> HANDLERS = Collections.synchronizedList(new ArrayList(4));
    private static final List<IPigeonFoodPredicate> DYN_PREDICATES = Collections.synchronizedList(new ArrayList(2));

    public static void registerHandler(IPigeonFoodHandler handler) {
        HANDLERS.add(handler);
    }

    public static void registerDynPredicate(IPigeonFoodPredicate handler) {
        DYN_PREDICATES.add(handler);
    }

    public static Optional<IPigeonFoodPredicate> isFood(ItemStack stackIn) {
        for (IPigeonFoodPredicate predicate : DYN_PREDICATES) {
            if (!predicate.isFood(stackIn)) continue;
            return Optional.of(predicate);
        }
        if (stackIn.func_77973_b() instanceof IPigeonFoodHandler && ((IPigeonFoodHandler)stackIn.func_77973_b()).isFood(stackIn)) {
            return Optional.of((IPigeonFoodHandler)stackIn.func_77973_b());
        }
        for (IPigeonFoodHandler handler : HANDLERS) {
            if (!handler.isFood(stackIn)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }

    public static Optional<IPigeonFoodHandler> getMatch(@Nullable AbstractPigeonEntity birdIn, ItemStack stackIn, @Nullable Entity entityIn) {
        for (IPigeonFoodHandler handler : birdIn.getFoodHandlers()) {
            if (!handler.canConsume(birdIn, stackIn, entityIn)) continue;
            return Optional.of(handler);
        }
        if (stackIn.func_77973_b() instanceof IPigeonFoodHandler && ((IPigeonFoodHandler)stackIn.func_77973_b()).canConsume(birdIn, stackIn, entityIn)) {
            return Optional.of((IPigeonFoodHandler)stackIn.func_77973_b());
        }
        for (IPigeonFoodHandler handler : HANDLERS) {
            if (!handler.canConsume(birdIn, stackIn, entityIn)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }
}

