/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.custom.PigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.IBirdData;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonLocationStorage;
import net.joefoxe.hexerei.util.NBTUtilities;
import net.joefoxe.hexerei.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PigeonLocationData
implements IBirdData {
    private final PigeonLocationStorage storage;
    private final UUID uuid;
    @Nullable
    private UUID ownerId;
    @Nullable
    private Vector3d position;
    @Nullable
    private RegistryKey<World> dimension;
    @Nullable
    private ITextComponent name;
    @Nullable
    private ITextComponent ownerName;
    private PigeonEntity pigeon;
    private LivingEntity owner;

    protected PigeonLocationData(PigeonLocationStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getBirdId() {
        return this.uuid;
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return this.ownerId;
    }

    @Override
    public String getBirdName() {
        return this.name == null ? "" : this.name.getString();
    }

    @Override
    public String getOwnerName() {
        return this.ownerName == null ? "" : this.ownerName.getString();
    }

    public void populate(PigeonEntity pigeonIn) {
        this.update(pigeonIn);
    }

    public void update(PigeonEntity pigeonIn) {
        this.ownerId = pigeonIn.func_184753_b();
        this.position = pigeonIn.func_213303_ch();
        this.dimension = pigeonIn.field_70170_p.func_234923_W_();
        this.name = pigeonIn.func_200200_C_();
        this.ownerName = pigeonIn.getOwnersName().orElse(null);
        this.pigeon = pigeonIn;
        this.storage.func_76185_a();
    }

    public void read(CompoundNBT compound) {
        this.ownerId = NBTUtilities.getUniqueId(compound, "ownerId");
        this.position = NBTUtilities.getVector3d(compound);
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)NBTUtilities.getResourceLocation(compound, "dimension"));
        this.name = NBTUtilities.getTextComponent(compound, "name_text_component");
    }

    public CompoundNBT write(CompoundNBT compound) {
        NBTUtilities.putUniqueId(compound, "ownerId", this.ownerId);
        NBTUtilities.putVector3d(compound, this.position);
        NBTUtilities.putResourceLocation(compound, "dimension", this.dimension.func_240901_a_());
        NBTUtilities.putTextComponent(compound, "name_text_component", this.name);
        return compound;
    }

    public static PigeonLocationData from(PigeonLocationStorage storageIn, PigeonEntity pigeonIn) {
        PigeonLocationData locationData = new PigeonLocationData(storageIn, pigeonIn.func_110124_au());
        locationData.populate(pigeonIn);
        return locationData;
    }

    @Nullable
    public Optional<LivingEntity> getOwner(@Nullable World worldIn) {
        if (worldIn == null) {
            return Optional.ofNullable(this.owner);
        }
        MinecraftServer server = worldIn.func_73046_m();
        if (server == null) {
            throw new IllegalArgumentException("worldIn must be of ServerWorld");
        }
        for (ServerWorld world : server.func_212370_w()) {
            LivingEntity possibleOwner = WorldUtil.getCachedEntity((World)world, LivingEntity.class, this.owner, this.uuid);
            if (possibleOwner == null) continue;
            this.owner = possibleOwner;
            return Optional.of(this.owner);
        }
        this.owner = null;
        return Optional.empty();
    }

    @Nullable
    public Optional<PigeonEntity> getPigeon(@Nullable World worldIn) {
        if (worldIn == null) {
            return Optional.ofNullable(this.pigeon);
        }
        MinecraftServer server = worldIn.func_73046_m();
        if (server == null) {
            throw new IllegalArgumentException("worldIn must be of ServerWorld");
        }
        for (ServerWorld world : server.func_212370_w()) {
            PigeonEntity possiblePigeon = WorldUtil.getCachedEntity((World)world, PigeonEntity.class, this.pigeon, this.uuid);
            if (possiblePigeon == null) continue;
            this.pigeon = possiblePigeon;
            return Optional.of(this.pigeon);
        }
        this.pigeon = null;
        return Optional.empty();
    }

    public boolean shouldDisplay(World worldIn, PlayerEntity playerIn, Hand handIn) {
        return playerIn.func_184812_l_();
    }

    @Nullable
    public ITextComponent getName(@Nullable World worldIn) {
        return this.getPigeon(worldIn).map(Entity::func_145748_c_).orElse(this.name);
    }

    @Nullable
    public Vector3d getPos(@Nullable ServerWorld worldIn) {
        return this.getPigeon((World)worldIn).map(Entity::func_213303_ch).orElse(this.position);
    }

    @Nullable
    public Vector3d getPos() {
        return this.position;
    }

    @Nullable
    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public String toString() {
        return "PigeonLocationData [uuid=" + this.uuid + ", owner=" + this.ownerId + ", position=" + this.position + ", dimension=" + this.dimension + ", name=" + this.name + "]";
    }
}

