/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai;

import com.google.common.base.Strings;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.joefoxe.hexerei.client.renderer.entity.custom.PigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.IBirdData;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonReviveData;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonReviveStorage;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.UUIDArgument;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PigeonReviveCommand {
    public static final DynamicCommandExceptionType COLOR_INVALID = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("command.pigeonrevive.invalid", new Object[]{arg}));
    public static final DynamicCommandExceptionType SPAWN_EXCEPTION = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("command.pigeonrevive.exception", new Object[]{arg}));
    public static final Dynamic2CommandExceptionType TOO_MANY_OPTIONS = new Dynamic2CommandExceptionType((arg1, arg2) -> new TranslationTextComponent("command.pigeonrevive.imprecise", new Object[]{arg1, arg2}));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"pigeon").requires(s -> s.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"revive").then(Commands.func_197057_a((String)"byuuid").then(Commands.func_197056_a((String)"pigeon_owner", (ArgumentType)UUIDArgument.uuid()).suggests(PigeonReviveCommand.getOwnerIdSuggestionsRevive()).then(Commands.func_197056_a((String)"pigeon_uuid", (ArgumentType)UUIDArgument.uuid()).suggests(PigeonReviveCommand.getPigeonIdSuggestionsRevive()).executes(c -> PigeonReviveCommand.respawn((CommandContext<CommandSource>)c)))))).then(Commands.func_197057_a((String)"byname").then(Commands.func_197056_a((String)"owner_name", (ArgumentType)StringArgumentType.string()).suggests(PigeonReviveCommand.getOwnerNameSuggestionsRevive()).then(Commands.func_197056_a((String)"pigeon_name", (ArgumentType)StringArgumentType.string()).suggests(PigeonReviveCommand.getPigeonNameSuggestionsRevive()).executes(c -> PigeonReviveCommand.respawn2((CommandContext<CommandSource>)c)))))));
    }

    public static void registerSerializers() {
        ArgumentTypes.func_218136_a((String)HexereiUtil.getResourcePath("uuid"), UUIDArgument.class, (IArgumentSerializer)new ArgumentSerializer(UUIDArgument::uuid));
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getOwnerIdSuggestionsRevive() {
        return (context, builder) -> PigeonReviveCommand.getOwnerIdSuggestions(PigeonReviveStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    private static <S extends ISuggestionProvider> CompletableFuture<Suggestions> getOwnerIdSuggestions(Collection<? extends IBirdData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSource) {
            return ISuggestionProvider.func_197005_b((Iterable)possibilities.stream().map(IBirdData::getOwnerId).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof ISuggestionProvider) {
            return ((ISuggestionProvider)context.getSource()).func_197009_a(context, builder);
        }
        return Suggestions.empty();
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getPigeonIdSuggestionsRevive() {
        return (context, builder) -> PigeonReviveCommand.getPigeonIdSuggestions(PigeonReviveStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    private static <S extends ISuggestionProvider> CompletableFuture<Suggestions> getPigeonIdSuggestions(Collection<? extends IBirdData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSource) {
            UUID ownerId = (UUID)context.getArgument("pigeon_owner", UUID.class);
            if (ownerId == null) {
                return Suggestions.empty();
            }
            return ISuggestionProvider.func_197005_b((Iterable)possibilities.stream().filter(data -> ownerId.equals(data.getOwnerId())).map(IBirdData::getBirdId).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof ISuggestionProvider) {
            return ((ISuggestionProvider)context.getSource()).func_197009_a(context, builder);
        }
        return Suggestions.empty();
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getOwnerNameSuggestionsRevive() {
        return (context, builder) -> PigeonReviveCommand.getOwnerNameSuggestions(PigeonReviveStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    public static <S extends ISuggestionProvider> CompletableFuture<Suggestions> getOwnerNameSuggestions(Collection<? extends IBirdData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSource) {
            return ISuggestionProvider.func_197005_b((Iterable)possibilities.stream().map(IBirdData::getOwnerName).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof ISuggestionProvider) {
            return ((ISuggestionProvider)context.getSource()).func_197009_a(context, builder);
        }
        return Suggestions.empty();
    }

    private static <S extends ISuggestionProvider> SuggestionProvider<S> getPigeonNameSuggestionsRevive() {
        return (context, builder) -> PigeonReviveCommand.getPigeonNameSuggestions(PigeonReviveStorage.get((World)((CommandSource)context.getSource()).func_197023_e()).getAll(), context, builder);
    }

    public static <S extends ISuggestionProvider> CompletableFuture<Suggestions> getPigeonNameSuggestions(Collection<? extends IBirdData> possibilities, CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSource) {
            String ownerName = (String)context.getArgument("owner_name", String.class);
            if (ownerName == null) {
                return Suggestions.empty();
            }
            return ISuggestionProvider.func_197005_b((Iterable)possibilities.stream().filter(data -> ownerName.equals(data.getOwnerName())).map(IBirdData::getBirdName).filter(str -> !Strings.isNullOrEmpty((String)str)).collect(Collectors.toList()), (SuggestionsBuilder)builder);
        }
        if (context.getSource() instanceof ISuggestionProvider) {
            return ((ISuggestionProvider)context.getSource()).func_197009_a(context, builder);
        }
        return Suggestions.empty();
    }

    private static int respawn(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource source = (CommandSource)ctx.getSource();
        source.func_197035_h();
        ServerWorld world = source.func_197023_e();
        UUID ownerUuid = (UUID)ctx.getArgument("pigeon_owner", UUID.class);
        UUID uuid = (UUID)ctx.getArgument("pigeon_uuid", UUID.class);
        PigeonReviveStorage respawnStorage = PigeonReviveStorage.get((World)world);
        PigeonReviveData respawnData = respawnStorage.getData(uuid);
        if (respawnData == null) {
            throw COLOR_INVALID.create((Object)uuid.toString());
        }
        return PigeonReviveCommand.respawn(respawnStorage, respawnData, source);
    }

    private static int respawn2(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        CommandSource source = (CommandSource)ctx.getSource();
        source.func_197035_h();
        ServerWorld world = source.func_197023_e();
        String ownerName = (String)ctx.getArgument("owner_name", String.class);
        String pigeonName = (String)ctx.getArgument("pigeon_name", String.class);
        PigeonReviveStorage respawnStorage = PigeonReviveStorage.get((World)world);
        List respawnData = respawnStorage.getPigeons(ownerName).filter(data -> data.getBirdName().equalsIgnoreCase(pigeonName)).collect(Collectors.toList());
        if (respawnData.isEmpty()) {
            throw COLOR_INVALID.create((Object)pigeonName);
        }
        if (respawnData.size() > 1) {
            StringJoiner joiner = new StringJoiner(", ");
            for (PigeonReviveData data2 : respawnData) {
                joiner.add(Objects.toString(data2.getBirdId()));
            }
            throw TOO_MANY_OPTIONS.create((Object)joiner.toString(), (Object)respawnData.size());
        }
        return PigeonReviveCommand.respawn(respawnStorage, (PigeonReviveData)respawnData.get(0), source);
    }

    private static int respawn(PigeonReviveStorage respawnStorage, PigeonReviveData respawnData, CommandSource source) throws CommandSyntaxException {
        PigeonEntity pigeon = respawnData.respawn(source.func_197023_e(), (PlayerEntity)source.func_197035_h(), source.func_197035_h().func_233580_cy_().func_177984_a());
        if (pigeon != null) {
            respawnStorage.remove(respawnData.getBirdId());
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.pigeonrevive.uuid.success", new Object[]{respawnData.getBirdName()}), false);
            return 1;
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.pigeonrevive.uuid.failure", new Object[]{respawnData.getBirdName()}), false);
        return 0;
    }
}

