/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.joefoxe.hexerei.Hexerei;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber
public class HexConfig {
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue JARS_ONLY_HOLD_HERBS;

    public static void refreshServer() {
        Hexerei.LOGGER.debug("Refreshing Server Config");
        JARS_ONLY_HOLD_HERBS.get();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        Hexerei.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        Hexerei.LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        Hexerei.LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
        System.out.println("config check");
        JARS_ONLY_HOLD_HERBS.get();
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
    }

    @SubscribeEvent
    public static void onReload(ModConfig.Reloading configEvent) {
        HexConfig.refreshServer();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Settings");
        builder.pop();
        builder.push("Herb Jar Settings");
        JARS_ONLY_HOLD_HERBS = builder.comment("Disabling allows jars to hold any item").translation("hexerei.config.jars_only_hold_herbs").define("jars_only_hold_herbs", true);
        builder.pop();
        COMMON_CONFIG = builder.build();
    }
}

