/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.IMixingCauldronRecipe;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.state.properties.LiquidType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MixingCauldronRecipe
implements IMixingCauldronRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final LiquidType liquid;
    private final LiquidType liquidOutput;
    private final int fluidLevelsConsumed;

    public MixingCauldronRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, LiquidType liquid, LiquidType liquidOutput, int fluidLevelsConsumed) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.liquid = liquid;
        this.liquidOutput = liquidOutput;
        this.fluidLevelsConsumed = fluidLevelsConsumed;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return ((Ingredient)this.recipeItems.get(0)).test(inv.func_70301_a(0)) && ((Ingredient)this.recipeItems.get(1)).test(inv.func_70301_a(1)) && ((Ingredient)this.recipeItems.get(2)).test(inv.func_70301_a(2)) && ((Ingredient)this.recipeItems.get(3)).test(inv.func_70301_a(3)) && ((Ingredient)this.recipeItems.get(4)).test(inv.func_70301_a(4)) && ((Ingredient)this.recipeItems.get(5)).test(inv.func_70301_a(5)) && ((Ingredient)this.recipeItems.get(6)).test(inv.func_70301_a(6)) && ((Ingredient)this.recipeItems.get(7)).test(inv.func_70301_a(7));
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public LiquidType getLiquid() {
        return this.liquid;
    }

    public LiquidType getLiquidOutput() {
        return this.liquidOutput;
    }

    public int getFluidLevelsConsumed() {
        return this.fluidLevelsConsumed;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)ModBlocks.MIXING_CAULDRON.get());
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.MIXING_SERIALIZER.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MixingCauldronRecipe> {
        public MixingCauldronRecipe read(ResourceLocation recipeId, JsonObject json) {
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            String liquid = JSONUtils.func_151200_h((JsonObject)json, (String)"liquid");
            String liquidOutput = JSONUtils.func_151200_h((JsonObject)json, (String)"liquidOutput");
            int fluidLevelsConsumed = JSONUtils.func_151203_m((JsonObject)json, (String)"fluidLevelsConsumed");
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.func_191197_a((int)8, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.func_199802_a((JsonElement)ingredients.get(i)));
            }
            return new MixingCauldronRecipe(recipeId, output, (NonNullList<Ingredient>)inputs, LiquidType.valueOf(liquid.toUpperCase(Locale.ROOT)), LiquidType.valueOf(liquidOutput.toUpperCase(Locale.ROOT)), fluidLevelsConsumed);
        }

        @Nullable
        public MixingCauldronRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            NonNullList inputs = NonNullList.func_191197_a((int)buffer.readInt(), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            return new MixingCauldronRecipe(recipeId, output, (NonNullList<Ingredient>)inputs, (LiquidType)buffer.func_179257_a(LiquidType.class), (LiquidType)buffer.func_179257_a(LiquidType.class), buffer.readInt());
        }

        public void write(PacketBuffer buffer, MixingCauldronRecipe recipe) {
            buffer.writeInt(recipe.func_192400_c().size());
            for (Ingredient ing : recipe.func_192400_c()) {
                ing.func_199564_a(buffer);
            }
            buffer.writeItemStack(recipe.func_77571_b(), false);
            buffer.func_179249_a((Enum)recipe.getLiquid());
            buffer.func_179249_a((Enum)recipe.getLiquidOutput());
            buffer.writeInt(recipe.getFluidLevelsConsumed());
        }
    }

    public static class MixingCauldronRecipeType
    implements IRecipeType<MixingCauldronRecipe> {
        public String toString() {
            return TYPE_ID.toString();
        }
    }
}

