/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.state.properties.LiquidType;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CauldronParticle
extends SpriteTexturedParticle {
    public static final Vector3d[] CUBE = new Vector3d[]{new Vector3d(0.5, 0.1, -0.5), new Vector3d(0.5, 0.1, 0.5), new Vector3d(-0.5, 0.1, 0.5), new Vector3d(-0.5, 0.1, -0.5), new Vector3d(-0.5, -0.1, -0.5), new Vector3d(-0.5, -0.1, 0.5), new Vector3d(0.5, -0.1, 0.5), new Vector3d(0.5, -0.1, -0.5), new Vector3d(-0.5, -0.1, 0.5), new Vector3d(-0.5, 0.1, 0.5), new Vector3d(0.5, 0.1, 0.5), new Vector3d(0.5, -0.1, 0.5), new Vector3d(0.5, -0.1, -0.5), new Vector3d(0.5, 0.1, -0.5), new Vector3d(-0.5, 0.1, -0.5), new Vector3d(-0.5, -0.1, -0.5), new Vector3d(-0.5, -0.1, -0.5), new Vector3d(-0.5, 0.1, -0.5), new Vector3d(-0.5, 0.1, 0.5), new Vector3d(-0.5, -0.1, 0.5), new Vector3d(0.5, -0.1, 0.5), new Vector3d(0.5, 0.1, 0.5), new Vector3d(0.5, 0.1, -0.5), new Vector3d(0.5, -0.1, -0.5)};
    public static final Vector3d[] CUBE_NORMALS = new Vector3d[]{new Vector3d(0.0, 0.1, 0.0), new Vector3d(0.0, -0.5, 0.0), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5)};
    private static final IParticleRenderType renderType = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.disableTexture();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.enableLighting();
            RenderSystem.enableColorMaterial();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        }

        public void func_217599_a(Tessellator tesselator) {
            tesselator.func_78381_a();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableLighting();
            RenderSystem.enableTexture();
        }
    };
    protected float scale;
    protected float rotationDirection;
    protected float rotation;

    public CauldronParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.rotation = 0.0f;
        Random random = new Random();
        this.setScale(0.2f);
        this.setRotationDirection(random.nextFloat() - 0.5f);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.func_187115_a(scale * 0.5f, scale * 0.5f);
    }

    public void setRotationDirection(float rotationDirection) {
        this.rotationDirection = rotationDirection;
    }

    public void func_189213_a() {
        this.rotation = this.rotationDirection * 0.1f + this.rotation;
        super.func_189213_a();
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d projectedView = renderInfo.func_216785_c();
        float lerpedX = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - projectedView.func_82615_a());
        float lerpedY = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - projectedView.func_82617_b());
        float lerpedZ = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - projectedView.func_82616_c());
        int light = 0xF000F0;
        double ageMultiplier = 1.0 - Math.pow(this.field_70546_d, 3.0) / Math.pow(this.field_70547_e, 3.0);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                Vector3d vec = CUBE[i * 4 + j];
                vec = vec.func_178785_b(this.rotation).func_186678_a((double)this.scale * ageMultiplier).func_72441_c((double)lerpedX, (double)lerpedY, (double)lerpedZ);
                Vector3d normal = CUBE_NORMALS[i];
                buffer.func_225588_a_((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c, this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as, 0.0f, 0.0f, 0, light, (float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c);
            }
        }
    }

    public IParticleRenderType func_217558_b() {
        return renderType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CauldronParticle cauldronParticle = new CauldronParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            Random random = new Random();
            Color color = new Color(BiomeColors.func_228363_c_((IBlockDisplayReader)worldIn, (BlockPos)new BlockPos(x, y, z)));
            BlockState blockStateAtPos = worldIn.func_180495_p(new BlockPos(x, y - 0.5, z));
            if (blockStateAtPos.func_177230_c() == ModBlocks.MIXING_CAULDRON.get()) {
                float colorOffset;
                if (blockStateAtPos.func_177229_b(MixingCauldron.FLUID) == LiquidType.WATER) {
                    colorOffset = random.nextFloat() * 0.1f;
                    cauldronParticle.func_70538_b((float)color.getRed() / 450.0f + colorOffset, (float)color.getGreen() / 450.0f + colorOffset, (float)color.getBlue() / 450.0f + colorOffset);
                }
                if (blockStateAtPos.func_177229_b(MixingCauldron.FLUID) == LiquidType.MILK) {
                    colorOffset = random.nextFloat() * 0.05f;
                    cauldronParticle.func_70538_b(0.85f + colorOffset, 0.85f + colorOffset, 0.85f + colorOffset);
                }
                if (blockStateAtPos.func_177229_b(MixingCauldron.FLUID) == LiquidType.TALLOW) {
                    colorOffset = random.nextFloat() * 0.05f;
                    cauldronParticle.func_70538_b(0.53f + colorOffset, 0.53f + colorOffset, 0.41f + colorOffset);
                }
                if (blockStateAtPos.func_177229_b(MixingCauldron.FLUID) == LiquidType.LAVA) {
                    cauldronParticle.func_70538_b(0.8f + random.nextFloat() * 0.1f, 0.24f + random.nextFloat() * 0.5f, random.nextFloat() * 0.3f);
                }
                if (blockStateAtPos.func_177229_b(MixingCauldron.FLUID) == LiquidType.QUICKSILVER) {
                    colorOffset = random.nextFloat() * 0.15f;
                    cauldronParticle.func_70538_b(0.12f + colorOffset, 0.12f + colorOffset, 0.12f + colorOffset);
                }
                if (blockStateAtPos.func_177229_b(MixingCauldron.FLUID) == LiquidType.BLOOD) {
                    colorOffset = random.nextFloat() * 0.25f;
                    cauldronParticle.func_70538_b(0.12f + colorOffset, 0.0f, 0.0f);
                }
            }
            cauldronParticle.func_82338_g(2.0f);
            cauldronParticle.func_217568_a(this.spriteSet);
            return cauldronParticle;
        }
    }
}

