/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.Random;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.state.properties.LiquidType;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class CandleDipperTile
extends TileEntity
implements ITickableTileEntity {
    public float numberOfCandles;
    public Vector3d candlePos1;
    public Vector3d candlePos2;
    public Vector3d candlePos3;
    public int candlePos1Slot;
    public int candlePos2Slot;
    public int candlePos3Slot;
    public boolean candle1Dunking = false;
    public boolean candle2Dunking = false;
    public boolean candle3Dunking = false;
    public int candle1DippedTimes = 0;
    public int candle2DippedTimes = 0;
    public int candle3DippedTimes = 0;
    public int candle1DunkingCooldown = 60;
    public int candle2DunkingCooldown = 60;
    public int candle3DunkingCooldown = 60;
    public int candleDunkingCooldownMax = 200;
    public int candleDunkingCooldownStart = 60;
    public int candleDunkingTimeMax;
    public int candle1DunkingTime = this.candleDunkingTimeMax = 200;
    public int candle2DunkingTime = this.candleDunkingTimeMax;
    public int candle3DunkingTime = this.candleDunkingTimeMax;
    public Vector3d closestPlayerPos;
    public double closestDist;
    public final double maxDist = 8.0;

    public CandleDipperTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.candlePos1 = new Vector3d(0.5, 0.5, 0.5);
        this.candlePos2 = new Vector3d(0.5, 0.5, 0.5);
        this.candlePos3 = new Vector3d(0.5, 0.5, 0.5);
    }

    public CandleDipperTile() {
        this((TileEntityType)ModTileEntities.CANDLE_DIPPER_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        if (nbt.func_150297_b("candlePos1Slot", 3)) {
            this.candlePos1Slot = nbt.func_74762_e("candlePos1Slot");
        }
        if (nbt.func_150297_b("candlePos2Slot", 3)) {
            this.candlePos2Slot = nbt.func_74762_e("candlePos2Slot");
        }
        if (nbt.func_150297_b("candlePos3Slot", 3)) {
            this.candlePos3Slot = nbt.func_74762_e("candlePos3Slot");
        }
        if (nbt.func_150297_b("candle1DippedTimes", 3)) {
            this.candle1DippedTimes = nbt.func_74762_e("candle1DippedTimes");
        }
        if (nbt.func_150297_b("candle2DippedTimes", 3)) {
            this.candle2DippedTimes = nbt.func_74762_e("candle2DippedTimes");
        }
        if (nbt.func_150297_b("candle3DippedTimes", 3)) {
            this.candle3DippedTimes = nbt.func_74762_e("candle3DippedTimes");
        }
        if (nbt.func_150297_b("candle1DunkingCooldown", 3)) {
            this.candle1DunkingCooldown = nbt.func_74762_e("candle1DunkingCooldown");
        }
        if (nbt.func_150297_b("candle2DunkingCooldown", 3)) {
            this.candle2DunkingCooldown = nbt.func_74762_e("candle2DunkingCooldown");
        }
        if (nbt.func_150297_b("candle3DunkingCooldown", 3)) {
            this.candle3DunkingCooldown = nbt.func_74762_e("candle3DunkingCooldown");
        }
        if (nbt.func_150297_b("candle1DunkingTime", 3)) {
            this.candle1DunkingTime = nbt.func_74762_e("candle1DunkingTime");
        }
        if (nbt.func_150297_b("candle2DunkingTime", 3)) {
            this.candle2DunkingTime = nbt.func_74762_e("candle2DunkingTime");
        }
        if (nbt.func_150297_b("candle3DunkingTime", 3)) {
            this.candle3DunkingTime = nbt.func_74762_e("candle3DunkingTime");
        }
        if (nbt.func_150297_b("candle1Dunking", 3)) {
            boolean bl = this.candle1Dunking = nbt.func_74762_e("candle1Dunking") == 1;
        }
        if (nbt.func_150297_b("candle2Dunking", 3)) {
            boolean bl = this.candle2Dunking = nbt.func_74762_e("candle2Dunking") == 1;
        }
        if (nbt.func_150297_b("candle3Dunking", 3)) {
            this.candle3Dunking = nbt.func_74762_e("candle3Dunking") == 1;
        }
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("candlePos1Slot", this.candlePos1Slot);
        compound.func_74768_a("candlePos2Slot", this.candlePos2Slot);
        compound.func_74768_a("candlePos3Slot", this.candlePos3Slot);
        compound.func_74768_a("candle1DippedTimes", this.candle1DippedTimes);
        compound.func_74768_a("candle2DippedTimes", this.candle2DippedTimes);
        compound.func_74768_a("candle3DippedTimes", this.candle3DippedTimes);
        compound.func_74768_a("candle1DunkingCooldown", this.candle1DunkingCooldown);
        compound.func_74768_a("candle2DunkingCooldown", this.candle2DunkingCooldown);
        compound.func_74768_a("candle3DunkingCooldown", this.candle3DunkingCooldown);
        compound.func_74768_a("candle1DunkingTime", this.candle1DunkingTime);
        compound.func_74768_a("candle2DunkingTime", this.candle2DunkingTime);
        compound.func_74768_a("candle3DunkingTime", this.candle3DunkingTime);
        compound.func_74768_a("candle1Dunking", this.candle1Dunking ? 1 : 0);
        compound.func_74768_a("candle2Dunking", this.candle2Dunking ? 1 : 0);
        compound.func_74768_a("candle3Dunking", this.candle3Dunking ? 1 : 0);
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.func_213303_ch().func_82615_a() - (double)pos.func_177958_n() - 0.5;
        double deltaY = entity.func_213303_ch().func_82617_b() - (double)pos.func_177956_o() - 0.5;
        double deltaZ = entity.func_213303_ch().func_82616_c() - (double)pos.func_177952_p() - 0.5;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public static double getDistance(float x1, float y1, float x2, float y2) {
        double deltaX = x2 - x1;
        double deltaY = y2 - y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public double func_145833_n() {
        return 4096.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = super.getRenderBoundingBox().func_72314_b(5.0, 5.0, 5.0);
        return aabb;
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    private float moveToAngle(float input, float movedTo, float speed) {
        float distance = movedTo - input;
        if (Math.abs(distance) <= speed) {
            return movedTo;
        }
        input = distance > 0.0f ? (Math.abs(distance) < 180.0f ? (input += speed) : (input -= speed)) : (Math.abs(distance) < 180.0f ? (input -= speed) : (input += speed));
        if (input < -90.0f) {
            input += 360.0f;
        }
        if (input > 270.0f) {
            input -= 360.0f;
        }
        return input;
    }

    public float getAngle(Vector3d pos) {
        float angle = (float)Math.toDegrees(Math.atan2(pos.func_82616_c() - (double)this.func_174877_v().func_177952_p() - 0.5, pos.func_82615_a() - (double)this.func_174877_v().func_177958_n() - 0.5));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getSpeed(double pos, double posTo) {
        return (float)((double)0.01f + (double)0.1f * (Math.abs(pos - posTo) / 3.0));
    }

    public Vector3d rotateAroundVec(Vector3d vector3dCenter, float rotation, Vector3d vector3d) {
        Vector3d newVec = vector3d.func_178788_d(vector3dCenter);
        newVec = newVec.func_178785_b(rotation / 180.0f * (float)Math.PI);
        newVec = newVec.func_178787_e(vector3dCenter);
        return newVec;
    }

    public int interactDipper(PlayerEntity player, BlockRayTraceResult hit) {
        if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == Items.field_151007_F) {
            Random rand = new Random();
            if (this.candlePos1Slot == 0) {
                this.candlePos1Slot = 1;
                this.candle1DunkingCooldown = this.candleDunkingCooldownStart;
                this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184586_b(Hand.MAIN_HAND).func_190918_g(1);
                }
                return 1;
            }
            if (this.candlePos2Slot == 0) {
                this.candlePos2Slot = 1;
                this.candle2DunkingCooldown = this.candleDunkingCooldownStart;
                this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184586_b(Hand.MAIN_HAND).func_190918_g(1);
                }
                return 1;
            }
            if (this.candlePos3Slot == 0) {
                this.candlePos3Slot = 1;
                this.candle3DunkingCooldown = this.candleDunkingCooldownStart;
                this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184586_b(Hand.MAIN_HAND).func_190918_g(1);
                }
                return 1;
            }
        } else if (player.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            Random rand = new Random();
            if (this.candlePos1Slot != 0 && this.candle1DippedTimes >= 3) {
                this.candle1DippedTimes = 0;
                this.candlePos1Slot = 0;
                this.candle1DunkingTime = this.candleDunkingTimeMax;
                this.candle1Dunking = false;
                this.candle1DunkingCooldown = this.candleDunkingCooldownMax;
                player.field_71071_by.func_191975_a(this.field_145850_b, new ItemStack((IItemProvider)ModBlocks.CANDLE.get()));
                this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                return 1;
            }
            if (this.candlePos2Slot != 0 && this.candle2DippedTimes >= 3) {
                this.candle2DippedTimes = 0;
                this.candlePos2Slot = 0;
                this.candle2DunkingTime = this.candleDunkingTimeMax;
                this.candle2Dunking = false;
                this.candle2DunkingCooldown = this.candleDunkingCooldownMax;
                player.field_71071_by.func_191975_a(this.field_145850_b, new ItemStack((IItemProvider)ModBlocks.CANDLE.get()));
                this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                return 1;
            }
            if (this.candlePos3Slot != 0 && this.candle3DippedTimes >= 3) {
                this.candle3DippedTimes = 0;
                this.candlePos3Slot = 0;
                this.candle3DunkingTime = this.candleDunkingTimeMax;
                this.candle3Dunking = false;
                this.candle3DunkingCooldown = this.candleDunkingCooldownMax;
                player.field_71071_by.func_191975_a(this.field_145850_b, new ItemStack((IItemProvider)ModBlocks.CANDLE.get()));
                this.field_145850_b.func_184133_a((PlayerEntity)null, this.field_174879_c, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 1.0f, rand.nextFloat() * 0.4f + 1.0f);
                return 1;
            }
        }
        return 0;
    }

    public void func_73660_a() {
        this.closestPlayerPos = null;
        this.closestDist = 8.0;
        this.numberOfCandles = 0.0f;
        Vector3d targetPos1 = new Vector3d(0.25, 0.0, 0.0625);
        Vector3d targetPos2 = new Vector3d(0.5, 0.0, 0.0625);
        Vector3d targetPos3 = new Vector3d(0.75, 0.0, 0.0625);
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (blockState.func_177230_c() instanceof MixingCauldron) {
            float dist;
            if (this.candlePos1Slot > 0 && this.candle1DippedTimes < 3) {
                if ((Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL) > 0 && blockState.func_177229_b(MixingCauldron.FLUID) == LiquidType.TALLOW) {
                    --this.candle1DunkingCooldown;
                }
                if (this.candle1DunkingCooldown <= 0) {
                    this.candle1DunkingCooldown = this.candleDunkingCooldownMax;
                    this.candle1Dunking = true;
                }
                targetPos1 = new Vector3d(targetPos1.func_82615_a(), 0.3125 + Math.sin((float)this.field_145850_b.func_82737_E() / 16.0f) / 32.0, 0.5);
            }
            if (this.candlePos2Slot > 0 && this.candle2DippedTimes < 3) {
                if ((Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL) > 0 && blockState.func_177229_b(MixingCauldron.FLUID) == LiquidType.TALLOW) {
                    --this.candle2DunkingCooldown;
                }
                if (this.candle2DunkingCooldown <= 0) {
                    this.candle2DunkingCooldown = this.candleDunkingCooldownMax;
                    this.candle2Dunking = true;
                }
                targetPos2 = new Vector3d(targetPos2.func_82615_a(), 0.3125 + Math.sin(((float)this.field_145850_b.func_82737_E() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (this.candlePos3Slot > 0 && this.candle3DippedTimes < 3) {
                if ((Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL) > 0 && blockState.func_177229_b(MixingCauldron.FLUID) == LiquidType.TALLOW) {
                    --this.candle3DunkingCooldown;
                }
                if (this.candle3DunkingCooldown <= 0) {
                    this.candle3DunkingCooldown = this.candleDunkingCooldownMax;
                    this.candle3Dunking = true;
                }
                targetPos3 = new Vector3d(targetPos3.func_82615_a(), 0.3125 + Math.sin(((float)this.field_145850_b.func_82737_E() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (this.candle1Dunking) {
                if ((Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL) > 0 && blockState.func_177229_b(MixingCauldron.FLUID) == LiquidType.TALLOW) {
                    --this.candle1DunkingTime;
                }
                this.candle1DunkingCooldown = this.candleDunkingCooldownMax;
                if (this.candle1DunkingTime <= 0) {
                    this.candle1DunkingTime = this.candleDunkingTimeMax;
                    this.candle1Dunking = false;
                    this.candle1DunkingCooldown = this.candleDunkingCooldownStart;
                    ++this.candle1DippedTimes;
                    this.chanceDecreaseLevel(0.16f);
                }
                dist = 3 - (Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL);
                if ((Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL) == 0) {
                    dist = -2.0f;
                }
                targetPos1 = new Vector3d(targetPos1.func_82615_a(), (double)(-(dist * 3.0f) / 16.0f) + Math.sin((float)this.field_145850_b.func_82737_E() / 16.0f) / 32.0, 0.5);
            }
            if (this.candle2Dunking) {
                if ((Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL) > 0 && blockState.func_177229_b(MixingCauldron.FLUID) == LiquidType.TALLOW) {
                    --this.candle2DunkingTime;
                }
                this.candle2DunkingCooldown = this.candleDunkingCooldownMax;
                if (this.candle2DunkingTime <= 0) {
                    this.candle2DunkingTime = this.candleDunkingTimeMax;
                    this.candle2Dunking = false;
                    this.candle2DunkingCooldown = this.candleDunkingCooldownStart;
                    ++this.candle2DippedTimes;
                    this.chanceDecreaseLevel(0.16f);
                }
                dist = 3 - (Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL);
                if ((Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL) == 0) {
                    dist = -2.0f;
                }
                targetPos2 = new Vector3d(targetPos2.func_82615_a(), (double)(-(dist * 3.0f) / 16.0f) + Math.sin(((float)this.field_145850_b.func_82737_E() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (this.candle3Dunking) {
                if ((Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL) > 0 && blockState.func_177229_b(MixingCauldron.FLUID) == LiquidType.TALLOW) {
                    --this.candle3DunkingTime;
                }
                this.candle3DunkingCooldown = this.candleDunkingCooldownMax;
                if (this.candle3DunkingTime <= 0) {
                    this.candle3DunkingTime = this.candleDunkingTimeMax;
                    this.candle3Dunking = false;
                    this.candle3DunkingCooldown = this.candleDunkingCooldownStart;
                    ++this.candle3DippedTimes;
                    this.chanceDecreaseLevel(0.16f);
                }
                dist = 3 - (Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL);
                if ((Integer)blockState.func_177229_b((Property)MixingCauldron.LEVEL) == 0) {
                    dist = -2.0f;
                }
                targetPos3 = new Vector3d(targetPos3.func_82615_a(), (double)(-(dist * 3.0f) / 16.0f) + Math.sin(((float)this.field_145850_b.func_82737_E() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (this.candle1DippedTimes >= 3) {
                targetPos1 = new Vector3d(targetPos1.func_82615_a(), 0.625 + Math.sin((float)this.field_145850_b.func_82737_E() / 16.0f) / 32.0, 0.5);
            }
            if (this.candle2DippedTimes >= 3) {
                targetPos2 = new Vector3d(targetPos2.func_82615_a(), 0.625 + Math.sin(((float)this.field_145850_b.func_82737_E() + 20.0f) / 14.0f) / 32.0, 0.5);
            }
            if (this.candle3DippedTimes >= 3) {
                targetPos3 = new Vector3d(targetPos3.func_82615_a(), 0.625 + Math.sin(((float)this.field_145850_b.func_82737_E() + 40.0f) / 15.0f) / 32.0, 0.5);
            }
            if (this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.NORTH) {
                targetPos1 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 180.0f, targetPos1);
                targetPos2 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 180.0f, targetPos2);
                targetPos3 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 180.0f, targetPos3);
            } else if (this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.SOUTH) {
                targetPos1 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 0.0f, targetPos1);
                targetPos2 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 0.0f, targetPos2);
                targetPos3 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 0.0f, targetPos3);
            } else if (this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.EAST) {
                targetPos1 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 90.0f, targetPos1);
                targetPos2 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 90.0f, targetPos2);
                targetPos3 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 90.0f, targetPos3);
            } else if (this.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D) == Direction.WEST) {
                targetPos1 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 270.0f, targetPos1);
                targetPos2 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 270.0f, targetPos2);
                targetPos3 = this.rotateAroundVec(new Vector3d(0.5, 0.0, 0.5), 270.0f, targetPos3);
            }
            this.candlePos1 = new Vector3d((double)this.moveTo((float)this.candlePos1.field_72450_a, (float)targetPos1.func_82615_a(), this.getSpeed((float)this.candlePos1.field_72450_a, targetPos1.func_82615_a())), (double)this.moveTo((float)this.candlePos1.field_72448_b, (float)targetPos1.func_82617_b(), 0.75f * this.getSpeed((float)this.candlePos1.field_72448_b, targetPos1.func_82617_b())), (double)this.moveTo((float)this.candlePos1.field_72449_c, (float)targetPos1.func_82616_c(), this.getSpeed((float)this.candlePos1.field_72449_c, targetPos1.func_82616_c())));
            this.candlePos2 = new Vector3d((double)this.moveTo((float)this.candlePos2.field_72450_a, (float)targetPos2.func_82615_a(), this.getSpeed((float)this.candlePos2.field_72450_a, targetPos2.func_82615_a())), (double)this.moveTo((float)this.candlePos2.field_72448_b, (float)targetPos2.func_82617_b(), 0.75f * this.getSpeed((float)this.candlePos2.field_72448_b, targetPos2.func_82617_b())), (double)this.moveTo((float)this.candlePos2.field_72449_c, (float)targetPos2.func_82616_c(), this.getSpeed((float)this.candlePos2.field_72449_c, targetPos2.func_82616_c())));
            this.candlePos3 = new Vector3d((double)this.moveTo((float)this.candlePos3.field_72450_a, (float)targetPos3.func_82615_a(), this.getSpeed((float)this.candlePos3.field_72450_a, targetPos3.func_82615_a())), (double)this.moveTo((float)this.candlePos3.field_72448_b, (float)targetPos3.func_82617_b(), 0.75f * this.getSpeed((float)this.candlePos3.field_72448_b, targetPos3.func_82617_b())), (double)this.moveTo((float)this.candlePos3.field_72449_c, (float)targetPos3.func_82616_c(), this.getSpeed((float)this.candlePos3.field_72449_c, targetPos3.func_82616_c())));
        }
    }

    private void chanceDecreaseLevel(float percent) {
        BlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        Random random = new Random();
        if (blockState.func_177230_c() instanceof MixingCauldron && !this.field_145850_b.func_201670_d() && random.nextFloat() <= percent) {
            ((MixingCauldron)blockState.func_177230_c()).subtractLevel(this.field_145850_b, this.field_174879_c.func_177977_b());
        }
    }
}

