/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.container.MixingCauldronContainer;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.state.properties.LiquidType;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiTags;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class MixingCauldronTile
extends LockableLootTileEntity
implements ISidedInventory,
ITickableTileEntity,
IClearable,
INamedContainerProvider {
    public boolean crafting;
    public int craftDelay;
    public float degrees;
    private boolean crafted;
    private boolean extracted = false;
    private int isColliding = 0;
    public static final int craftDelayMax = 100;
    private long tickedGameTime;
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    private static final int[] SLOTS_INPUT = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] SLOTS_OUTPUT = new int[]{8};
    VoxelShape BLOOD_SIGIL_SHAPE = Block.func_208617_a((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    VoxelShape HOPPER_SHAPE = Block.func_208617_a((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public MixingCauldronTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.getTileEntity().func_174877_v()), this.field_145850_b.func_180495_p(this.getTileEntity().func_174877_v()), 2);
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.hexerei.mixing_cauldron");
    }

    public MixingCauldronTile() {
        this((TileEntityType)ModTileEntities.MIXING_CAULDRON_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return compound;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemStack = ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
        if (itemStack.func_190916_E() < 1) {
            itemStack.func_190920_e(1);
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.items.size()) {
            ItemStack itemStack = stack.func_77946_l();
            itemStack.func_190920_e(1);
            this.items.set(index, (Object)itemStack);
        }
        this.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 8) {
            return false;
        }
        if (index == 9 && !stack.func_77973_b().func_206844_a(HexereiTags.Items.SIGILS)) {
            return false;
        }
        return ((ItemStack)this.items.get(index)).func_190926_b();
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_OUTPUT;
        }
        return SLOTS_INPUT;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int getCraftDelay() {
        return this.craftDelay;
    }

    public void setCraftDelay(int delay) {
        this.craftDelay = delay;
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new MixingCauldronContainer(id, this.field_145850_b, this.field_174879_c, player, player.field_70458_d);
    }

    public void func_174888_l() {
        super.func_174888_l();
        this.items.clear();
    }

    public double func_145833_n() {
        return 4096.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = super.getRenderBoundingBox().func_72314_b(5.0, 5.0, 5.0);
        return aabb;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(10){

            protected void onContentsChanged(int slot) {
                MixingCauldronTile.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 8) {
                    return false;
                }
                return slot != 9 || stack.func_77973_b().func_206844_a(HexereiTags.Items.SIGILS);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public Item getItemInSlot(int slot) {
        return ((ItemStack)this.items.get(slot)).func_77973_b();
    }

    public int getCraftMaxDelay() {
        return 100;
    }

    public boolean getCrafted() {
        return this.crafted;
    }

    public int getNumberOfItems() {
        int num = 0;
        for (int i = 0; i < 8; ++i) {
            if (this.items.get(i) == ItemStack.field_190927_a) continue;
            ++num;
        }
        return num;
    }

    private void strikeLightning() {
        if (!this.field_145850_b.func_201670_d()) {
            EntityType.field_200728_aG.func_220331_a((ServerWorld)this.field_145850_b, null, null, this.field_174879_c, SpawnReason.TRIGGERED, true, true);
        }
    }

    public void onEntityCollision(Entity entity) {
        BlockPos blockpos = this.func_174877_v();
        if (entity instanceof ItemEntity) {
            if (VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-blockpos.func_177958_n()), (double)(-blockpos.func_177956_o()), (double)(-blockpos.func_177952_p()))), (VoxelShape)this.HOPPER_SHAPE, (IBooleanFunction)IBooleanFunction.field_223238_i_) && this.captureItem((ItemEntity)entity)) {
                ((MixingCauldron)this.func_195044_w().func_177230_c()).setEmitParticles(2);
            }
        } else if (VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-blockpos.func_177958_n()), (double)(-blockpos.func_177956_o()), (double)(-blockpos.func_177952_p()))), (VoxelShape)this.BLOOD_SIGIL_SHAPE, (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
            if (this.isColliding <= 1 && this.getItemInSlot(9).getItem() == ModItems.BLOOD_SIGIL.get()) {
                Random random = new Random();
                entity.func_70097_a(DamageSource.field_76376_m, 3.0f);
                if (random.nextDouble() > 0.5 && (this.func_195044_w().func_177229_b(MixingCauldron.FLUID) == LiquidType.EMPTY || this.func_195044_w().func_177229_b(MixingCauldron.FLUID) == LiquidType.BLOOD && (Integer)this.func_195044_w().func_177229_b((Property)MixingCauldron.LEVEL) < 3)) {
                    ((MixingCauldron)this.func_195044_w().func_177230_c()).setFillLevel(this.field_145850_b, this.field_174879_c, this.func_195044_w(), (Integer)this.func_195044_w().func_177229_b((Property)MixingCauldron.LEVEL) + 1, LiquidType.BLOOD);
                    entity.func_184185_a(SoundEvents.field_226141_eV_, 1.5f, 1.5f);
                    ((MixingCauldron)this.func_195044_w().func_177230_c()).setEmitParticles(2);
                }
            }
            this.isColliding = 6;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        return super.getCapability(cap);
    }

    public boolean captureItem(ItemEntity itemEntity) {
        boolean flag = false;
        ItemStack itemstack = itemEntity.func_92059_d().func_77946_l();
        if (this.getFirstOpenSlot() >= 0) {
            this.func_70299_a(this.getFirstOpenSlot(), itemstack);
            itemEntity.func_92059_d().func_190918_g(1);
            return true;
        }
        return false;
    }

    public int getFirstOpenSlot() {
        for (int i = 0; i < 8; ++i) {
            if (!((ItemStack)this.items.get(i)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public void craft() {
        Inventory inv = new Inventory(10);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, (ItemStack)this.items.get(i));
        }
        Optional recipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.MIXING_CAULDRON_RECIPE, (IInventory)inv, this.field_145850_b);
        recipe.ifPresent(iRecipe -> {
            ItemStack output = iRecipe.func_77571_b();
            if (!(iRecipe.getLiquid() != this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(MixingCauldron.FLUID) || inv.func_70301_a(8) != ItemStack.field_190927_a && inv.func_70301_a(8).func_190916_E() != 0 || this.crafted || iRecipe.getFluidLevelsConsumed() > (Integer)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)MixingCauldron.LEVEL))) {
                this.crafting = true;
                if (this.craftDelay >= 100) {
                    Random rand = new Random();
                    this.craftTheItem(output);
                    this.func_70296_d();
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a(MixingCauldron.FLUID, (Comparable)((Object)iRecipe.getLiquidOutput())), 3);
                    this.crafted = true;
                    for (int i = 0; i < iRecipe.getFluidLevelsConsumed(); ++i) {
                        ((MixingCauldron)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).subtractLevel(this.field_145850_b, this.field_174879_c);
                    }
                }
            }
        });
        if (this.crafting) {
            this.craftDelay += 2;
        }
        if (this.craftDelay >= 1) {
            --this.craftDelay;
        }
        this.crafting = false;
        if (this.craftDelay > 0) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)MixingCauldron.CRAFT_DELAY, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(this.craftDelay - 1), (int)0, (int)100))), 2);
        }
        if (this.craftDelay < 10) {
            this.crafted = false;
        }
    }

    private void craftTheItem(ItemStack output) {
        Random random;
        if (output.func_77973_b() == ModItems.TALLOW_IMPURITY.get() && (random = new Random()).nextInt(5) != 0) {
            output = ItemStack.field_190927_a;
        }
        this.func_70299_a(0, ItemStack.field_190927_a);
        this.func_70299_a(1, ItemStack.field_190927_a);
        this.func_70299_a(2, ItemStack.field_190927_a);
        this.func_70299_a(3, ItemStack.field_190927_a);
        this.func_70299_a(4, ItemStack.field_190927_a);
        this.func_70299_a(5, ItemStack.field_190927_a);
        this.func_70299_a(6, ItemStack.field_190927_a);
        this.func_70299_a(7, ItemStack.field_190927_a);
        this.func_70299_a(8, output);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.tickedGameTime = this.field_145850_b.func_82737_E();
        this.craft();
        if (this.extracted) {
            this.extracted = false;
            this.func_70296_d();
        }
        --this.isColliding;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

