/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util;

import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.Skill;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.SkillInstance;
import net.joefoxe.hexerei.util.PigeonRegistries;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SkillListSerializer
implements IDataSerializer<List<SkillInstance>> {
    public void write(PacketBuffer buf, List<SkillInstance> value) {
        buf.writeInt(value.size());
        for (SkillInstance inst : value) {
            buf.writeRegistryIdUnsafe(PigeonRegistries.SKILLS, (IForgeRegistryEntry)inst.getSkill());
            inst.writeToBuf(buf);
        }
    }

    public List<SkillInstance> read(PacketBuffer buf) {
        int size = buf.readInt();
        ArrayList<SkillInstance> newInst = new ArrayList<SkillInstance>(size);
        for (int i = 0; i < size; ++i) {
            SkillInstance inst = ((Skill)buf.readRegistryIdUnsafe(PigeonRegistries.SKILLS)).getDefault();
            inst.readFromBuf(buf);
            newInst.add(inst);
        }
        return newInst;
    }

    public DataParameter<List<SkillInstance>> func_187161_a(int id) {
        return new DataParameter(id, (IDataSerializer)this);
    }

    public List<SkillInstance> copyValue(List<SkillInstance> value) {
        ArrayList<SkillInstance> newInst = new ArrayList<SkillInstance>(value.size());
        for (SkillInstance inst : value) {
            newInst.add(inst.copy());
        }
        return newInst;
    }
}

