/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.biome;

import java.util.function.Supplier;
import net.minecraft.client.audio.BackgroundMusicTracks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModBiomes {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"hexerei");
    public static final RegistryObject<Biome> WILLOW_SWAMP = BIOMES.register("willow_swamp", () -> ModBiomes.makeWillowSwampBiome(() -> ConfiguredSurfaceBuilders.field_244189_u, 0.125f, 0.05f));

    private static Biome makeRiftBiome(Supplier<ConfiguredSurfaceBuilder<?>> surfaceBuilder, float depth, float scale) {
        MobSpawnInfo.Builder mobspawninfo$builder = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)mobspawninfo$builder);
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)mobspawninfo$builder);
        mobspawninfo$builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200792_f, 100, 7, 10));
        mobspawninfo$builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_233592_ba_, 50, 4, 4));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder().func_242519_a(surfaceBuilder);
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244136_b);
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244131_B);
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244152_r);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243755_o((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243712_Z((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243720_ad((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243727_ak((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.LAKES, Features.field_243790_P);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(depth).func_205420_b(scale).func_205414_c(1.5f).func_205417_d(0.9f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(-3407872).func_235248_c_(-16777216).func_235239_a_(-65536).func_242539_d(ModBiomes.getSkyColorWithTemperatureModifier(0.8f)).func_242540_e(-3407872).func_242541_f(-3407872).func_235244_a_(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_197595_F, 0.003f)).func_242539_d(-65536).func_235241_a_(SoundEvents.field_232711_f_).func_235243_a_(new MoodSoundAmbience(SoundEvents.field_232844_p_, 6000, 8, 2.0)).func_235242_a_(new SoundAdditionsAmbience(SoundEvents.field_232723_h_, 0.0111)).func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)SoundEvents.field_232762_ir_)).func_235238_a_()).func_242458_a(mobspawninfo$builder.func_242577_b()).func_242457_a(biomegenerationsettings$builder.func_242508_a()).func_242455_a();
    }

    public static Biome makeWillowSwampBiome(Supplier<ConfiguredSurfaceBuilder<?>> surfaceBuilder, float depth, float scale) {
        MobSpawnInfo.Builder mobspawninfo$builder = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243714_a((MobSpawnInfo.Builder)mobspawninfo$builder);
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)mobspawninfo$builder);
        mobspawninfo$builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200743_ai, 1, 1, 1));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder().func_242519_a(surfaceBuilder);
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244144_j);
        biomegenerationsettings$builder.func_242516_a(StructureFeatures.field_244131_B);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243723_ag((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243742_f((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243746_h((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243748_i((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        DefaultBiomeFeatures.func_243750_j((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, Features.field_243791_Q);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243823_aV);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243824_aW);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243817_aP);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243833_af);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243828_aa);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243965_y);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243928_ck);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243852_ay);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243805_aD);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243810_aI);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243882_bb);
        biomegenerationsettings$builder.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243883_bc);
        DefaultBiomeFeatures.func_243730_an((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.SWAMP).func_205421_a(depth).func_205420_b(scale).func_205414_c(0.8f).func_205417_d(0.9f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(6388580).func_235248_c_(2302743).func_235239_a_(12638463).func_242539_d(ModBiomes.getSkyColorWithTemperatureModifier(0.8f)).func_242540_e(6975545).func_242537_a(BiomeAmbience.GrassColorModifier.SWAMP).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(mobspawninfo$builder.func_242577_b()).func_242457_a(biomegenerationsettings$builder.func_242508_a()).func_242455_a();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float lvt_1_1_ = temperature / 3.0f;
        lvt_1_1_ = MathHelper.func_76131_a((float)lvt_1_1_, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - lvt_1_1_ * 0.05f), (float)(0.5f + lvt_1_1_ * 0.1f), (float)1.0f);
    }

    public static void register(IEventBus eventBus) {
        BIOMES.register(eventBus);
    }
}

