/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure.structures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import net.joefoxe.hexerei.Hexerei;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class HexereiAbstractTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    private static final ResourceLocation WILLOW_TREE1 = new ResourceLocation("hexerei:willow_tree1");
    private static final ResourceLocation WILLOW_TREE2 = new ResourceLocation("hexerei:willow_tree2");
    private static final ResourceLocation WILLOW_TREE3 = new ResourceLocation("hexerei:willow_tree3");
    private static final ResourceLocation[] WILLOW_TREE = new ResourceLocation[]{WILLOW_TREE1, WILLOW_TREE2, WILLOW_TREE3};

    public HexereiAbstractTreeFeature(Codec codec) {
        super(codec);
    }

    public static boolean isAirOrLeavesAt(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    public static boolean isAirOrLeavesOrLogsAt(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> state.func_196958_f() || state.func_235714_a_((ITag)BlockTags.field_206952_E) || state.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    private static boolean isDirtOrFarmlandAt(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return HexereiAbstractTreeFeature.func_227250_b_((Block)block) || block == Blocks.field_150458_ak;
        });
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, BaseTreeFeatureConfig config) {
        int i = rand.nextInt(WILLOW_TREE.length);
        if (!HexereiAbstractTreeFeature.isDirtOrFarmlandAt((IWorldGenerationBaseReader)reader, pos.func_177977_b())) {
            return false;
        }
        for (int j = 0; j < 8; ++j) {
            BlockPos upPos = new BlockPos((Vector3i)pos).func_177984_a();
            for (int k = 0; k < j; ++k) {
                upPos = upPos.func_177984_a();
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, upPos)) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, upPos.func_177978_c())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, upPos.func_177968_d())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, upPos.func_177974_f())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, upPos.func_177974_f().func_177978_c())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, upPos.func_177974_f().func_177968_d())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, upPos.func_177976_e())) {
                return false;
            }
            if (!HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, upPos.func_177976_e().func_177978_c())) {
                return false;
            }
            if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, upPos.func_177976_e().func_177968_d())) continue;
            return false;
        }
        if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, pos.func_177977_b().func_177978_c())) {
            return false;
        }
        if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, pos.func_177977_b().func_177968_d())) {
            return false;
        }
        if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, pos.func_177977_b().func_177974_f())) {
            return false;
        }
        if (HexereiAbstractTreeFeature.isAirOrLeavesOrLogsAt((IWorldGenerationBaseReader)reader, pos.func_177977_b().func_177976_e())) {
            return false;
        }
        IntegrityProcessor integrityprocessor = new IntegrityProcessor(0.9f);
        TemplateManager templatemanager = reader.func_201672_e().func_73046_m().func_240792_aT_();
        Template template = templatemanager.func_200220_a(WILLOW_TREE[i]);
        if (template == null) {
            Hexerei.LOGGER.error("Identifier to the specified nbt file was not found! : {}", (Object)WILLOW_TREE[i]);
            return false;
        }
        Rotation rotation = Rotation.func_222466_a((Random)rand);
        BlockPos halfLengths = new BlockPos(template.func_186259_a().func_177958_n() / 2, template.func_186259_a().func_177956_o() / 2, template.func_186259_a().func_177952_p() / 2);
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)pos);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(rotation).func_207665_a(halfLengths).func_186222_a(false);
        Optional processor = reader.func_201672_e().func_73046_m().func_244267_aX().func_243612_b(Registry.field_243554_aw).func_241873_b(new ResourceLocation("hexerei", "mangrove_tree/mangrove_tree_legs"));
        processor.orElse(ProcessorLists.field_244101_a).func_242919_a().forEach(arg_0 -> ((PlacementSettings)placementsettings).func_215222_a(arg_0));
        template.func_237152_b_((IServerWorld)reader, (BlockPos)mutable.func_189533_g((Vector3i)pos).func_196234_d(-halfLengths.func_177958_n(), 0, -halfLengths.func_177952_p()), placementsettings, rand);
        return true;
    }
}

