/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure.structures;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public class StructureUtils {
    private static final Map<BlockState, Boolean> IS_FULLCUBE_MAP = new HashMap<BlockState, Boolean>();

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(IWorldReader world, BlockPos pos, BlockState state) {
        if (!IS_FULLCUBE_MAP.containsKey(state)) {
            boolean isFullCube = Block.func_208062_a((VoxelShape)state.func_196951_e((IBlockReader)world, pos)) || state.func_177230_c() instanceof LeavesBlock;
            IS_FULLCUBE_MAP.put(state, isFullCube);
        }
        return IS_FULLCUBE_MAP.get(state);
    }

    public static BlockState orientateChest(IServerWorld blockView, BlockPos blockPos, BlockState blockState) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        Direction bestDirection = (Direction)blockState.func_177229_b((Property)HorizontalBlock.field_185512_D);
        for (Direction facing : Direction.Plane.HORIZONTAL) {
            mutable.func_189533_g((Vector3i)blockPos).func_189536_c(facing);
            if (!StructureUtils.isFullCube((IWorldReader)blockView, (BlockPos)mutable, blockView.func_180495_p((BlockPos)mutable))) continue;
            bestDirection = facing;
            mutable.func_189534_c(facing.func_176734_d(), 2);
            if (blockView.func_180495_p((BlockPos)mutable).func_185904_a().func_76220_a()) continue;
            break;
        }
        return (BlockState)blockState.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)bestDirection.func_176734_d());
    }

    public static boolean serializeAndCompareFeature(ConfiguredFeature<?, ?> configuredFeature1, ConfiguredFeature<?, ?> configuredFeature2) {
        Optional configuredFeatureJSON1 = ConfiguredFeature.field_242763_a.encode(configuredFeature1, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        Optional configuredFeatureJSON2 = ConfiguredFeature.field_242763_a.encode(configuredFeature2, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).get().left();
        if (!configuredFeatureJSON1.isPresent() || !configuredFeatureJSON2.isPresent()) {
            return false;
        }
        return configuredFeatureJSON1.equals(configuredFeatureJSON2);
    }

    public static int getFirstLandYFromPos(IWorldReader worldView, BlockPos pos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        mutable.func_189533_g((Vector3i)pos);
        IChunk currentChunk = worldView.func_217349_x((BlockPos)mutable);
        BlockState currentState = currentChunk.func_180495_p((BlockPos)mutable);
        while (mutable.func_177956_o() >= 0 && StructureUtils.isReplaceableByStructures(currentState)) {
            mutable.func_189536_c(Direction.DOWN);
            currentState = currentChunk.func_180495_p((BlockPos)mutable);
        }
        return mutable.func_177956_o();
    }

    private static boolean isReplaceableByStructures(BlockState blockState) {
        return blockState.func_196958_f() || blockState.func_185904_a().func_76224_d() || blockState.func_185904_a().func_76222_j();
    }

    public static void centerAllPieces(BlockPos targetPos, List<StructurePiece> pieces) {
        if (pieces.isEmpty()) {
            return;
        }
        Vector3i structureCenter = pieces.get(0).func_74874_b().func_215126_f();
        int xOffset = targetPos.func_177958_n() - structureCenter.func_177958_n();
        int zOffset = targetPos.func_177952_p() - structureCenter.func_177952_p();
        for (StructurePiece structurePiece : pieces) {
            structurePiece.func_181138_a(xOffset, 0, zOffset);
        }
    }
}

