/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.impl.BloodMagicAPI;

@Mod.EventBusSubscriber(modid="bloodmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    @SubscribeEvent
    public static void onCommonReload(ModConfig.ModConfigEvent ev) {
        if (ev.getConfig().getSpec().equals((Object)COMMON_SPEC)) {
            BloodMagic.handleConfigValues(BloodMagicAPI.INSTANCE);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> wellOfSuffering;
        public final ForgeConfigSpec.IntValue sacrificialDaggerConversion;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> sacrificialValues;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> teleposerBlacklist;
        public final ForgeConfigSpec.BooleanValue makeDungeonRitualCreativeOnly;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Stops the listed entities from being used in the Well of Suffering.", "Use the registry name of the entity. Vanilla entities do not require the modid."}).push("Blacklist");
            this.wellOfSuffering = builder.defineList("wellOfSuffering", (List)ImmutableList.of(), obj -> true);
            builder.comment(new String[]{"Stops the listed blocks from being teleported using the Teleposer and similar means.", "Use the registry name of the block. Vanilla blocks do not require the modid.", "Pack makers or mod makers can also add blocks to the blacklist by adding them to the Tag \"bloodmagic:teleposer_blacklist\"."});
            this.teleposerBlacklist = builder.defineList("teleposerBlacklist", (List)ImmutableList.of(), obj -> true);
            builder.pop();
            builder.comment("Amount of LP the Sacrificial Dagger should provide for each damage dealt.").push("Config Values");
            this.sacrificialDaggerConversion = builder.defineInRange("sacrificialDaggerConversion", 100, 0, 10000);
            builder.comment(new String[]{"Declares the amount of LP gained per HP sacrificed for the given entity.", "Setting the value to 0 will blacklist it.", "Use the registry name of the entity followed by a ';' and then the value you want.", "Vanilla entities do not require the modid."});
            this.sacrificialValues = builder.defineList("sacrificialValues", (List)ImmutableList.of((Object)"villager;100", (Object)"slime;15", (Object)"enderman;10", (Object)"cow;100", (Object)"chicken;100", (Object)"horse;100", (Object)"sheep;100", (Object)"wolf;100", (Object)"ocelot;100", (Object)"pig;100", (Object)"rabbit;100"), obj -> true);
            builder.comment(new String[]{"State that the dungeon spawning ritual can only be activated when using a Creative Activation Crystal.", "Used on servers for if you do not trust your players to not destroy other people's bases."});
            this.makeDungeonRitualCreativeOnly = builder.define("makeDungeonRitualCreativeOnly", false);
            builder.pop();
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.DoubleValue demonWillGaugeX;
        public final ForgeConfigSpec.DoubleValue demonWillGaugeY;
        public final ForgeConfigSpec.DoubleValue bloodAltarGaugeX;
        public final ForgeConfigSpec.DoubleValue bloodAltarGaugeY;
        public final ForgeConfigSpec.DoubleValue bloodAltarAdvGaugeX;
        public final ForgeConfigSpec.DoubleValue bloodAltarAdvGaugeY;
        public final ForgeConfigSpec.DoubleValue incenseGaugeX;
        public final ForgeConfigSpec.DoubleValue incenseGaugeY;
        public final ForgeConfigSpec.DoubleValue holdingX;
        public final ForgeConfigSpec.DoubleValue holdingY;
        public final ForgeConfigSpec.BooleanValue alwaysRenderRoutingLines;
        public final ForgeConfigSpec.BooleanValue sigilHoldingSkipsEmptySlots;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Always render the beams between routing nodes.", "If disabled, the beams will only render while the Node Router is held."}).push("client");
            this.alwaysRenderRoutingLines = builder.define("alwaysRenderRoutingLines", false);
            builder.comment(new String[]{"When cycling through slots, the Sigil of Holding will skip over empty slots and move to the next occupied one.", "If disabled, it will behave identically to the default hotbar."});
            this.sigilHoldingSkipsEmptySlots = builder.define("sigilHoldingSkipsEmptySlots", false);
            builder.pop();
            builder.comment("Settings for the position of the Demon Will Gauge HUD element.").push("hud");
            this.demonWillGaugeX = builder.defineInRange("DemonWillGaugePosX", 0.01, 0.0, 1.0);
            this.demonWillGaugeY = builder.defineInRange("DemonWillGaugePosY", 0.01, 0.0, 1.0);
            builder.comment("Settings for the position of the basic Blood Altar info HUD element.");
            this.bloodAltarGaugeX = builder.defineInRange("bloodAltarGaugeX", 0.01, 0.0, 1.0);
            this.bloodAltarGaugeY = builder.defineInRange("bloodAltarGaugeY", 0.01, 0.0, 1.0);
            builder.comment("Settings for the position of the advanced Blood Altar info HUD element.");
            this.bloodAltarAdvGaugeX = builder.defineInRange("bloodAltarAdvGaugeX", 0.01, 0.0, 1.0);
            this.bloodAltarAdvGaugeY = builder.defineInRange("bloodAltarAdvGaugeY", 0.01, 0.0, 1.0);
            builder.comment("Settings for the position of the Incense Altar info HUD element.");
            this.incenseGaugeX = builder.defineInRange("incenseGaugeX", 0.01, 0.0, 1.0);
            this.incenseGaugeY = builder.defineInRange("incenseGaugeY", 0.01, 0.0, 1.0);
            builder.comment("Settings for the position of the Sigil of Holding info HUD element.");
            this.holdingX = builder.defineInRange("holdingX", (double)0.72f, 0.0, 1.0);
            this.holdingY = builder.defineInRange("holdingY", 1.0, 0.0, 1.0);
            builder.pop();
        }
    }
}

