/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render;

import java.util.Arrays;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class BloodMagicRenderer {
    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static class Model2D {
        public double minX;
        public double minY;
        public double maxX;
        public double maxY;
        public ResourceLocation resource;

        public double sizeX() {
            return this.maxX - this.minX;
        }

        public double sizeY() {
            return this.maxY - this.minY;
        }

        public void setTexture(ResourceLocation resource) {
            this.resource = resource;
        }
    }

    public static class Model3D {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public final TextureAtlasSprite[] textures = new TextureAtlasSprite[6];
        public final boolean[] renderSides = new boolean[]{true, true, true, true, true, true, false};

        public double sizeX() {
            return this.maxX - this.minX;
        }

        public double sizeY() {
            return this.maxY - this.minY;
        }

        public double sizeZ() {
            return this.maxZ - this.minZ;
        }

        public void setSideRender(Direction side, boolean value) {
            this.renderSides[side.ordinal()] = value;
        }

        public boolean shouldSideRender(Direction side) {
            return this.renderSides[side.ordinal()];
        }

        public void setTexture(TextureAtlasSprite tex) {
            Arrays.fill(this.textures, tex);
        }

        public void setTextures(TextureAtlasSprite down, TextureAtlasSprite up, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite west, TextureAtlasSprite east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
        }
    }
}

