/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render.alchemyarray;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;
import wayoftime.bloodmagic.client.render.RenderResizableQuadrilateral;
import wayoftime.bloodmagic.client.render.alchemyarray.AlchemyArrayRenderer;
import wayoftime.bloodmagic.tile.TileAlchemyArray;

public class BindingAlchemyCircleRenderer
extends AlchemyArrayRenderer {
    public static final int numberOfSweeps = 5;
    public static final int startTime = 50;
    public static final int sweepTime = 40;
    public static final int inwardRotationTime = 50;
    public static final float arcLength = (float)Math.sqrt(8.0 - 8.0 * Math.cos(2.5132741228718345));
    public static final float theta2 = 0.31415927f;
    public static final int endTime = 300;
    public final ResourceLocation[] arraysResources = new ResourceLocation[5];
    public float offsetFromFace = -0.9f;

    public BindingAlchemyCircleRenderer() {
        super(new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindingarray.png"));
        this.arraysResources[0] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
        this.arraysResources[1] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
        this.arraysResources[2] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
        this.arraysResources[3] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
        this.arraysResources[4] = new ResourceLocation("bloodmagic", "textures/models/alchemyarrays/bindinglightningarray.png");
    }

    public float getRotation(int circle, float craftTime) {
        float offset = 2.0f;
        if (circle == -1 && craftTime >= offset) {
            return (craftTime - offset) * 360.0f * 2.0f / 5.0f / 40.0f;
        }
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.5);
            return modifier * 0.5f;
        }
        return 0.0f;
    }

    public float getSecondaryRotation(int circle, float craftTime) {
        float offset = 50.0f;
        if (craftTime >= offset) {
            float modifier = (float)Math.pow(craftTime - offset, 1.7);
            return modifier * 0.5f;
        }
        return 0.0f;
    }

    public float getVerticalOffset(int circle, float craftTime) {
        if (circle >= 0 && circle <= 4) {
            if (craftTime >= 5.0f) {
                if (craftTime <= 40.0f) {
                    return (float)(0.4 * Math.pow((craftTime - 5.0f) / 35.0f, 3.0));
                }
                return 0.4f;
            }
            return 0.0f;
        }
        if (craftTime >= 5.0f) {
            if (craftTime <= 40.0f) {
                return (float)(0.4 * Math.pow((craftTime - 5.0f) / 35.0f, 3.0));
            }
            return 0.4f;
        }
        return 0.0f;
    }

    public float getInwardRotation(int circle, float craftTime) {
        float offset = 250.0f;
        if (craftTime >= offset) {
            if (craftTime <= offset + 50.0f) {
                return 1.8f * (craftTime - offset);
            }
            return 90.0f;
        }
        return 0.0f;
    }

    @Override
    public void renderAt(TileAlchemyArray tileArray, double x, double y, double z, float craftTime, MatrixStack matrixStack, IRenderTypeBuffer renderer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        float rot = this.getRotation(-1, craftTime);
        float secondaryRot = this.getSecondaryRotation(craftTime);
        float size = 3.0f;
        Direction dirRotation = tileArray.getRotation();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)this.getVerticalOffset(craftTime), 0.0);
        matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), -dirRotation.func_185119_l(), true));
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), rot, true));
        IVertexBuilder twoDBuffer = renderer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.arrayResource));
        BloodMagicRenderer.Model2D arrayModel = new BloodMagicRenderer.Model2D();
        arrayModel.minX = -0.5;
        arrayModel.maxX = 0.5;
        arrayModel.minY = -0.5;
        arrayModel.maxY = 0.5;
        arrayModel.resource = this.arrayResource;
        matrixStack.func_227862_a_(size, size, size);
        RenderResizableQuadrilateral.INSTANCE.renderSquare(arrayModel, matrixStack, twoDBuffer, -1, combinedLightIn, combinedOverlayIn);
        matrixStack.func_227865_b_();
        for (int i = 0; i < 5; ++i) {
            matrixStack.func_227860_a_();
            float newSize = 1.0f;
            float distance = BindingAlchemyCircleRenderer.getDistanceOfCircle(i, craftTime);
            float angle = BindingAlchemyCircleRenderer.getAngleOfCircle(i, craftTime);
            float rotation = this.getRotation(i, craftTime);
            matrixStack.func_227861_a_((double)distance * Math.sin(angle), (double)this.getVerticalOffset(i, craftTime), (double)(-distance) * Math.cos(angle));
            matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), (float)(i * 360 / 5), true));
            matrixStack.func_227863_a_(new Quaternion(Direction.NORTH.func_229386_k_(), this.getInwardRotation(i, craftTime), true));
            matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), rotation, true));
            twoDBuffer = renderer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.arraysResources[i]));
            arrayModel.resource = this.arraysResources[i];
            matrixStack.func_227862_a_(newSize, newSize, newSize);
            RenderResizableQuadrilateral.INSTANCE.renderSquare(arrayModel, matrixStack, twoDBuffer, -1, combinedLightIn, combinedOverlayIn);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    public static float getAngleOfCircle(int circle, float craftTime) {
        if (circle >= 0 && circle <= 4) {
            float originalAngle = (float)((double)(circle * 2) * Math.PI / 5.0);
            double sweep = (craftTime - 50.0f) / 40.0f;
            if (sweep >= 0.0 && sweep < 5.0) {
                float offset = (int)sweep * 40 + 50;
                originalAngle = (float)((double)originalAngle + (2.5132741228718345 * (double)((int)sweep) + (double)BindingAlchemyCircleRenderer.getAngle(craftTime - offset, (int)sweep)));
            } else if (sweep >= 5.0) {
                originalAngle = (float)((double)originalAngle + (Math.PI * 4 + (double)((craftTime - 200.0f - 50.0f) * 2.0f) * Math.PI * 2.0 / 5.0 / 40.0));
            }
            return originalAngle;
        }
        return 0.0f;
    }

    public static float getAngle(float craftTime, int sweep) {
        float rDP = craftTime / 40.0f * arcLength;
        float rEnd = (float)Math.sqrt((double)(rDP * rDP + 4.0f) - (double)(2.0f * rDP * 2.0f) * Math.cos(0.3141592741012573));
        return (float)Math.acos((4.0f + rEnd * rEnd - rDP * rDP) / (2.0f * rEnd * 2.0f));
    }

    public static float getDistanceOfCircle(int circle, float craftTime) {
        double sweep = (craftTime - 50.0f) / 40.0f;
        if (sweep >= 0.0 && sweep < 5.0) {
            float offset = (int)sweep * 40 + 50;
            float angle = BindingAlchemyCircleRenderer.getAngle(craftTime - offset, (int)sweep);
            float thetaPrime = (float)(2.827433379488536 - (double)angle);
            return (float)(2.0 * Math.sin(0.3141592741012573) / Math.sin(thetaPrime));
        }
        if (sweep >= 5.0 && craftTime < 300.0f) {
            return 2.0f - 2.0f * (craftTime - 50.0f - 200.0f) / 50.0f;
        }
        if (craftTime >= 300.0f) {
            return 0.0f;
        }
        return 2.0f;
    }
}

