/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.render.alchemyarray;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import wayoftime.bloodmagic.client.render.BloodMagicRenderer;
import wayoftime.bloodmagic.client.render.RenderResizableQuadrilateral;
import wayoftime.bloodmagic.client.render.alchemyarray.AlchemyArrayRenderer;
import wayoftime.bloodmagic.tile.TileAlchemyArray;

public class NightAlchemyCircleRenderer
extends AlchemyArrayRenderer {
    private final ResourceLocation symbolResource;
    private final ResourceLocation circleResource;

    public NightAlchemyCircleRenderer(ResourceLocation arrayResource, ResourceLocation symbolResource, ResourceLocation circleResource) {
        super(arrayResource);
        this.symbolResource = symbolResource;
        this.circleResource = circleResource;
    }

    @Override
    public float getRotation(float craftTime) {
        return 0.0f;
    }

    @Override
    public float getSecondaryRotation(float craftTime) {
        float offset = 2.0f;
        if (craftTime >= offset) {
            float modifier = (craftTime - offset) * (craftTime - offset) * 0.05f;
            return modifier * 1.0f;
        }
        return 0.0f;
    }

    public float getTertiaryRotation(float craftTime) {
        float offset = 60.0f;
        if (craftTime >= offset) {
            float modifier = (craftTime - offset) * (craftTime - offset) * 0.15f;
            return modifier * 1.0f;
        }
        return 0.0f;
    }

    @Override
    public float getVerticalOffset(float craftTime) {
        return -0.4f;
    }

    @Override
    public float getSizeModifier(float craftTime) {
        return 1.0f;
    }

    public float getSecondarySizeModifier(float craftTime) {
        if (craftTime >= 100.0f) {
            if (craftTime <= 160.0f) {
                return (float)(1.0 * Math.pow((craftTime - 100.0f) / 60.0f, 3.0)) + 1.0f;
            }
            return 2.0f;
        }
        return 1.0f;
    }

    public float getTertiarySizeModifier(float craftTime) {
        return 1.0f;
    }

    public float getSymbolVerticaloffset(float craftTime) {
        if (craftTime >= 40.0f) {
            if (craftTime <= 100.0f) {
                return (float)(-0.4 + 0.4 * Math.pow((craftTime - 40.0f) / 60.0f, 3.0));
            }
            if (craftTime <= 140.0f) {
                return 0.01f * (craftTime - 100.0f);
            }
            return 0.4f;
        }
        return -0.4f;
    }

    public float getCentralCircleOffset(float craftTime) {
        if (craftTime >= 40.0f) {
            if (craftTime <= 100.0f) {
                return (float)(-0.4 + 0.4 * Math.pow((craftTime - 40.0f) / 60.0f, 3.0));
            }
            return 0.0f;
        }
        return -0.4f;
    }

    public float getSymbolPitch(float craftTime) {
        if (craftTime > 70.0f) {
            if (craftTime <= 100.0f) {
                return 90.0f * (craftTime - 70.0f) / 30.0f;
            }
            return 90.0f;
        }
        return 0.0f;
    }

    public float getCentralCirclePitch(float craftTime) {
        if (craftTime > 70.0f) {
            if (craftTime <= 150.0f) {
                return 360.0f * (craftTime - 70.0f) / 80.0f;
            }
            return 360.0f;
        }
        return 0.0f;
    }

    public float moonDisplacement(float craftTime) {
        if (craftTime > 40.0f) {
            if (craftTime <= 100.0f) {
                return (float)(2.0 * Math.pow((craftTime - 40.0f) / 60.0f, 3.0));
            }
            return 2.0f;
        }
        return 0.0f;
    }

    public float moonArc(float craftTime) {
        if (craftTime > 100.0f) {
            if (craftTime <= 200.0f) {
                return 180.0f * (craftTime - 100.0f) / 100.0f;
            }
            return 180.0f;
        }
        return 0.0f;
    }

    @Override
    public void renderAt(TileAlchemyArray tileArray, double x, double y, double z, float craftTime, MatrixStack matrixStack, IRenderTypeBuffer renderer, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        float rot = this.getRotation(craftTime);
        float secondaryRot = this.getSecondaryRotation(craftTime);
        float tertiaryRot = this.getTertiaryRotation(craftTime);
        float size = 1.0f * this.getSizeModifier(craftTime);
        Direction rotation = tileArray.getRotation();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)this.getVerticalOffset(craftTime), 0.0);
        matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), -rotation.func_185119_l(), true));
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(new Quaternion(Direction.NORTH.func_229386_k_(), rot, true));
        matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), secondaryRot, true));
        IVertexBuilder twoDBuffer = renderer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.arrayResource));
        BloodMagicRenderer.Model2D arrayModel = new BloodMagicRenderer.Model2D();
        arrayModel.minX = -0.5;
        arrayModel.maxX = 0.5;
        arrayModel.minY = -0.5;
        arrayModel.maxY = 0.5;
        arrayModel.resource = this.arrayResource;
        matrixStack.func_227862_a_(size, size, size);
        RenderResizableQuadrilateral.INSTANCE.renderSquare(arrayModel, matrixStack, twoDBuffer, -1, 0xF000F0, combinedOverlayIn);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        float pitch = this.getSymbolPitch(craftTime);
        float secondarySize = 1.0f * this.getSecondarySizeModifier(craftTime);
        int colorWanted = -1;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)this.getCentralCircleOffset(craftTime), 0.0);
        matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), -rotation.func_185119_l(), true));
        matrixStack.func_227860_a_();
        pitch = this.getCentralCirclePitch(craftTime);
        matrixStack.func_227863_a_(new Quaternion(Direction.WEST.func_229386_k_(), pitch, true));
        matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), -secondaryRot, true));
        twoDBuffer = renderer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.circleResource));
        arrayModel = new BloodMagicRenderer.Model2D();
        arrayModel.minX = -0.5;
        arrayModel.maxX = 0.5;
        arrayModel.minY = -0.5;
        arrayModel.maxY = 0.5;
        arrayModel.resource = this.circleResource;
        float tertiarySize = 1.0f * this.getTertiarySizeModifier(craftTime);
        matrixStack.func_227862_a_(tertiarySize, tertiarySize, tertiarySize);
        colorWanted = -1;
        RenderResizableQuadrilateral.INSTANCE.renderSquare(arrayModel, matrixStack, twoDBuffer, colorWanted, 0xF000F0, combinedOverlayIn);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, (double)this.getCentralCircleOffset(craftTime), 0.0);
        matrixStack.func_227863_a_(new Quaternion(Direction.UP.func_229386_k_(), -rotation.func_185119_l(), true));
        matrixStack.func_227863_a_(new Quaternion(Direction.SOUTH.func_229386_k_(), this.moonArc(craftTime), true));
        matrixStack.func_227861_a_((double)this.moonDisplacement(craftTime), 0.0, 0.0);
        matrixStack.func_227860_a_();
        pitch = this.getSymbolPitch(craftTime);
        matrixStack.func_227863_a_(new Quaternion(Direction.WEST.func_229386_k_(), pitch, true));
        matrixStack.func_227863_a_(new Quaternion(Direction.NORTH.func_229386_k_(), tertiaryRot, true));
        twoDBuffer = renderer.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.symbolResource));
        arrayModel = new BloodMagicRenderer.Model2D();
        arrayModel.minX = -0.5;
        arrayModel.maxX = 0.5;
        arrayModel.minY = -0.5;
        arrayModel.maxY = 0.5;
        arrayModel.resource = this.symbolResource;
        secondarySize = 1.0f;
        matrixStack.func_227862_a_(secondarySize, secondarySize, secondarySize);
        colorWanted = -1;
        RenderResizableQuadrilateral.INSTANCE.renderSquare(arrayModel, matrixStack, twoDBuffer, colorWanted, 0xF000F0, combinedOverlayIn);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }
}

