/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneLampBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import wayoftime.bloodmagic.api.compat.IAltarReader;
import wayoftime.bloodmagic.common.block.BloodstoneBlock;
import wayoftime.bloodmagic.tile.TileAltar;
import wayoftime.bloodmagic.util.Utils;

public class BlockAltar
extends Block {
    protected static final VoxelShape BODY = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public boolean isRedstoneActive = false;

    public BlockAltar() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.0f, 5.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BODY;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileAltar();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        this.isRedstoneActive = false;
        TileAltar altar = (TileAltar)world.func_175625_s(pos);
        Block blockdown = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        int redstoneMode = 0;
        if (blockdown instanceof BloodstoneBlock) {
            redstoneMode = 1;
        }
        if (blockdown instanceof RedstoneLampBlock) {
            redstoneMode = 2;
            this.isRedstoneActive = true;
        }
        return altar.getAnalogSignalStrength(redstoneMode);
    }

    public boolean func_149744_f(BlockState iBlockState) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction dir) {
        boolean isOutputOn = false;
        TileEntity tileentity = blockReader.func_175625_s(pos);
        if (tileentity instanceof TileAltar) {
            TileAltar altar = (TileAltar)tileentity;
            isOutputOn = altar.getOutputState();
        }
        int OUTPUT_POWER_WHEN_ON = 15;
        return isOutputOn ? 15 : 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockReader, BlockPos pos, Direction dir) {
        return 0;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        TileAltar altar = (TileAltar)world.func_175625_s(pos);
        if (altar == null || player.func_225608_bj_()) {
            return ActionResultType.FAIL;
        }
        ItemStack playerItem = player.func_184586_b(hand);
        if (playerItem.func_77973_b() instanceof IAltarReader) {
            playerItem.func_77973_b().func_77659_a(world, player, hand);
            return ActionResultType.SUCCESS;
        }
        if (Utils.insertItemToTile(altar, player)) {
            altar.startCycle();
        } else {
            altar.setActive();
        }
        world.func_184138_a(pos, state, state, 3);
        return ActionResultType.SUCCESS;
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        TileAltar altar = (TileAltar)world.func_175625_s(blockPos);
        if (altar != null) {
            altar.dropItems();
        }
        super.func_176206_d(world, blockPos, blockState);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileAltar) {
                ((TileAltar)tileentity).dropItems();
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

