/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;

public class BlockNetherrackSoil
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.field_208133_ah;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public BlockNetherrackSoil(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.UP && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177984_a());
        return !blockstate.func_185904_a().func_76220_a() || blockstate.func_177230_c() instanceof FenceGateBlock || blockstate.func_177230_c() instanceof MovingPistonBlock;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return !this.func_176223_P().func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a()) ? Blocks.field_150424_aL.func_176223_P() : super.func_196258_a(context);
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
            BlockNetherrackSoil.turnToDirt(state, (World)worldIn, pos);
        }
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int i = (Integer)state.func_177229_b((Property)MOISTURE);
        if (!BlockNetherrackSoil.hasLifeEssence((IWorldReader)worldIn, pos) && !worldIn.func_175727_C(pos.func_177984_a())) {
            if (i > 0) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops((IBlockReader)worldIn, pos)) {
                BlockNetherrackSoil.turnToDirt(state, (World)worldIn, pos);
            }
        } else if (i < 7) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public static void turnToDirt(BlockState state, World worldIn, BlockPos pos) {
        worldIn.func_175656_a(pos, BlockNetherrackSoil.func_199601_a((BlockState)state, (BlockState)Blocks.field_150424_aL.func_176223_P(), (World)worldIn, (BlockPos)pos));
    }

    private boolean hasCrops(IBlockReader worldIn, BlockPos pos) {
        BlockState plant = worldIn.func_180495_p(pos.func_177984_a());
        BlockState state = worldIn.func_180495_p(pos);
        return plant.func_177230_c() instanceof IPlantable && state.canSustainPlant(worldIn, pos, Direction.UP, (IPlantable)plant.func_177230_c());
    }

    private static boolean hasLifeEssence(IWorldReader worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (!worldIn.func_204610_c(blockpos).func_206884_a(BloodMagicTags.LIFE_ESSENCE)) continue;
            return true;
        }
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{MOISTURE});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

