/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockRoutingNode
extends Block {
    public static final BooleanProperty UP = BooleanProperty.func_177716_a((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.func_177716_a((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public BlockRoutingNode() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(2.0f, 5.0f).harvestTool(ToolType.PICKAXE).harvestLevel(2));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState returnState = super.func_196258_a(context);
        for (Direction dir : Direction.values()) {
            BlockPos attachedPos = blockpos.func_177972_a(dir);
            BlockState attachedState = iblockreader.func_180495_p(attachedPos);
            BooleanProperty prop = UP;
            switch (dir) {
                case DOWN: {
                    prop = DOWN;
                    break;
                }
                case EAST: {
                    prop = EAST;
                    break;
                }
                case NORTH: {
                    prop = NORTH;
                    break;
                }
                case SOUTH: {
                    prop = SOUTH;
                    break;
                }
                case UP: {
                    prop = UP;
                    break;
                }
                case WEST: {
                    prop = WEST;
                }
            }
            returnState = (BlockState)returnState.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(this.canConnect(attachedState, attachedState.func_224755_d((IBlockReader)iblockreader, attachedPos, dir.func_176734_d()), dir)));
        }
        return returnState;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState returnState = stateIn;
        for (Direction dir : Direction.values()) {
            BlockPos attachedPos = currentPos.func_177972_a(dir);
            BlockState attachedState = worldIn.func_180495_p(attachedPos);
            BooleanProperty prop = UP;
            switch (dir) {
                case DOWN: {
                    prop = DOWN;
                    break;
                }
                case EAST: {
                    prop = EAST;
                    break;
                }
                case NORTH: {
                    prop = NORTH;
                    break;
                }
                case SOUTH: {
                    prop = SOUTH;
                    break;
                }
                case UP: {
                    prop = UP;
                    break;
                }
                case WEST: {
                    prop = WEST;
                }
            }
            returnState = (BlockState)returnState.func_206870_a((Property)prop, (Comparable)Boolean.valueOf(this.canConnect(attachedState, attachedState.func_224755_d((IBlockReader)worldIn, attachedPos, dir.func_176734_d()), dir)));
        }
        return returnState;
    }

    public boolean canConnect(BlockState state, boolean isSideSolid, Direction direction) {
        return state.func_185904_a().func_76218_k() && isSideSolid;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }
}

