/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.potion.BloodMagicPotions;

public class PotionEffectRecipeBuilder
extends BloodMagicRecipeBuilder<PotionEffectRecipeBuilder> {
    private final List<Ingredient> input;
    private final Effect outputEffect;
    private final int baseDuration;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;

    protected PotionEffectRecipeBuilder(List<Ingredient> input, Effect outputEffect, int baseDuration, int syphon, int ticks, int minimumTier) {
        super(PotionEffectRecipeBuilder.bmSerializer("flask_potioneffect"));
        this.outputEffect = outputEffect;
        this.baseDuration = baseDuration;
        this.input = input;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static PotionEffectRecipeBuilder potionEffect(Effect outputEffect, int baseDuration, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new PotionEffectRecipeBuilder(inputList, outputEffect, baseDuration, syphon, ticks, minimumTier);
    }

    public PotionEffectRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 5) {
            this.input.add(ing);
        }
        return this;
    }

    @Override
    protected PotionEffectRecipeResult getResult(ResourceLocation id) {
        return new PotionEffectRecipeResult(id);
    }

    public class PotionEffectRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected PotionEffectRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            if (PotionEffectRecipeBuilder.this.input.size() > 0) {
                JsonArray mainArray = new JsonArray();
                for (Ingredient ing : PotionEffectRecipeBuilder.this.input) {
                    JsonElement jsonObj = ing.func_200304_c();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            json.addProperty("syphon", (Number)PotionEffectRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)PotionEffectRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)PotionEffectRecipeBuilder.this.minimumTier);
            json.addProperty("effect", BloodMagicPotions.getRegistryName(PotionEffectRecipeBuilder.this.outputEffect).toString());
            json.addProperty("baseDuration", (Number)PotionEffectRecipeBuilder.this.baseDuration);
        }
    }
}

