/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.potion.BloodMagicPotions;

public class PotionTransformRecipeBuilder
extends BloodMagicRecipeBuilder<PotionTransformRecipeBuilder> {
    private final List<Ingredient> input;
    private final List<Pair<Effect, Integer>> outputEffectList;
    private final List<Effect> inputEffectList;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;

    protected PotionTransformRecipeBuilder(List<Ingredient> input, Effect outputEffect, int baseDuration, Effect inputEffect, int syphon, int ticks, int minimumTier) {
        this(input, new ArrayList<Pair<Effect, Integer>>(), new ArrayList<Effect>(), syphon, ticks, minimumTier);
        this.outputEffectList.add((Pair<Effect, Integer>)Pair.of((Object)outputEffect, (Object)baseDuration));
        this.addInputEffect(inputEffect);
    }

    protected PotionTransformRecipeBuilder(List<Ingredient> input, List<Pair<Effect, Integer>> outputEffectList, List<Effect> inputEffectList, int syphon, int ticks, int minimumTier) {
        super(PotionTransformRecipeBuilder.bmSerializer("flask_potiontransform"));
        this.outputEffectList = outputEffectList;
        this.inputEffectList = inputEffectList;
        this.input = input;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static PotionTransformRecipeBuilder potionTransform(Effect outputEffect, int baseDuration, Effect inputEffect, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new PotionTransformRecipeBuilder(inputList, outputEffect, baseDuration, inputEffect, syphon, ticks, minimumTier);
    }

    public PotionTransformRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 5) {
            this.input.add(ing);
        }
        return this;
    }

    public PotionTransformRecipeBuilder addInputEffect(Effect effect) {
        if (!this.inputEffectList.contains(effect)) {
            this.inputEffectList.add(effect);
        }
        return this;
    }

    @Override
    protected PotionTransformRecipeResult getResult(ResourceLocation id) {
        return new PotionTransformRecipeResult(id);
    }

    public class PotionTransformRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected PotionTransformRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            JsonElement jsonObj;
            JsonArray mainArray;
            if (PotionTransformRecipeBuilder.this.input.size() > 0) {
                mainArray = new JsonArray();
                for (Ingredient ing : PotionTransformRecipeBuilder.this.input) {
                    jsonObj = ing.func_200304_c();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            if (PotionTransformRecipeBuilder.this.outputEffectList.size() > 0) {
                mainArray = new JsonArray();
                for (Pair outputEffect : PotionTransformRecipeBuilder.this.outputEffectList) {
                    jsonObj = new JsonObject();
                    jsonObj.addProperty("effect", BloodMagicPotions.getRegistryName((Effect)outputEffect.getKey()).toString());
                    jsonObj.addProperty("baseDuration", (Number)outputEffect.getValue());
                    mainArray.add(jsonObj);
                }
                json.add("outputEffect", (JsonElement)mainArray);
            }
            if (PotionTransformRecipeBuilder.this.inputEffectList.size() > 0) {
                mainArray = new JsonArray();
                for (int i = 0; i < PotionTransformRecipeBuilder.this.inputEffectList.size(); ++i) {
                    String effectStr = BloodMagicPotions.getRegistryName((Effect)PotionTransformRecipeBuilder.this.inputEffectList.get(i)).toString();
                    mainArray.add(effectStr);
                }
                json.add("inputEffect", (JsonElement)mainArray);
            }
            json.addProperty("syphon", (Number)PotionTransformRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)PotionTransformRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)PotionTransformRecipeBuilder.this.minimumTier);
        }
    }
}

