/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.altar.IBloodAltar;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.util.helper.PlayerSacrificeHelper;

public class ItemBloodProvider
extends Item {
    protected final String tooltipBase;
    public final int lpProvided;

    public ItemBloodProvider(String name, int lpProvided) {
        super(new Item.Properties().func_200917_a(64).func_200916_a(BloodMagic.TAB));
        this.tooltipBase = "tooltip.bloodmagic.blood_provider." + name + ".";
        this.lpProvided = lpProvided;
    }

    public ItemBloodProvider(String name) {
        this(name, 0);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return super.func_77659_a(world, player, hand);
        }
        IBloodAltar altarEntity = PlayerSacrificeHelper.getAltar(world, player.func_233580_cy_());
        if (altarEntity != null) {
            double posX = player.func_226277_ct_();
            double posY = player.func_226278_cu_();
            double posZ = player.func_226281_cx_();
            world.func_184148_a(player, posX, posY, posZ, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, posX + Math.random() - Math.random(), posY + Math.random() - Math.random(), posZ + Math.random() - Math.random(), 0.0, 0.0, 0.0);
            }
            if (!world.field_72995_K && PlayerHelper.isFakePlayer(player)) {
                return super.func_77659_a(world, player, hand);
            }
            altarEntity.fillMainTank(this.lpProvided);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent(this.tooltipBase + "desc").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

