/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.routing;

import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.BasicFilterKey;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.ItemCompositeFilter;
import wayoftime.bloodmagic.util.GhostItemHelper;
import wayoftime.bloodmagic.util.Utils;

public class ItemStandardFilter
extends ItemCompositeFilter {
    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            Utils.setUUID(stack);
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, buf -> buf.writeItemStack(stack, false));
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack filterStack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        int whitelistState;
        boolean isWhitelist;
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.basicfilter.desc").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
        if (filterStack.func_77978_p() == null) {
            return;
        }
        List<ItemStack> nestedFilters = this.getNestedFilters(filterStack);
        if (nestedFilters.size() > 0) {
            boolean sneaking = Screen.func_231173_s_();
            if (!sneaking) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.extraInfo").func_240699_a_(TextFormatting.BLUE));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.contained_filters").func_240699_a_(TextFormatting.BLUE));
                for (ItemStack nestedStack : nestedFilters) {
                    tooltip.add(nestedStack.func_200301_q());
                }
            }
        }
        boolean bl = isWhitelist = (whitelistState = this.getCurrentButtonState(filterStack, "blackwhitelist", 0)) == 0;
        if (isWhitelist) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.whitelist").func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.blacklist").func_240699_a_(TextFormatting.GRAY));
        }
        InventoryFilter inv = new InventoryFilter(filterStack);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (isWhitelist) {
                int amount = GhostItemHelper.getItemGhostAmount(stack);
                if (amount > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.count", new Object[]{amount, stack.func_200301_q()}));
                    continue;
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.filter.all", new Object[]{stack.func_200301_q()}));
                continue;
            }
            tooltip.add(stack.func_200301_q());
        }
    }

    @Override
    public IFilterKey getFilterKey(ItemStack filterStack, int slot, ItemStack ghostStack, int amount) {
        return new BasicFilterKey(ghostStack, amount);
    }
}

