/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.soul;

import java.util.List;
import java.util.Locale;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillGem;
import wayoftime.bloodmagic.api.compat.IMultiWillTool;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class ItemSoulGem
extends Item
implements IDemonWillGem,
IMultiWillTool {
    private final int maxWill;
    private final String name;

    public ItemSoulGem(String name, int maxWill) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(BloodMagic.TAB));
        this.name = name;
        this.maxWill = maxWill;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (EnumDemonWillType type : EnumDemonWillType.values()) {
                ItemStack stack = new ItemStack((IItemProvider)this);
                this.setCurrentType(type, stack);
                this.setWill(type, stack, this.maxWill);
                items.add((Object)stack);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EnumDemonWillType type = this.getCurrentType(stack);
        double drain = Math.min(this.getWill(type, stack), (double)(this.getMaxWill(type, stack) / 10));
        double filled = PlayerDemonWillHandler.addDemonWill(type, player, drain, stack);
        this.drainWill(type, stack, filled, true);
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        EnumDemonWillType type = this.getCurrentType(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.soulGem." + this.name).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.will", new Object[]{ChatUtil.DECIMAL_FORMAT.format(this.getWill(type, stack))}).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.currentType." + this.getCurrentType(stack).name().toLowerCase(Locale.ROOT)).func_240699_a_(TextFormatting.GRAY));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        EnumDemonWillType type = this.getCurrentType(stack);
        double maxWill = this.getMaxWill(type, stack);
        if (maxWill <= 0.0) {
            return 1.0;
        }
        return 1.0 - this.getWill(type, stack) / maxWill;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        EnumDemonWillType type = this.getCurrentType(stack);
        double maxWill = this.getMaxWill(type, stack);
        if (maxWill <= 0.0) {
            return 1;
        }
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)this.getWill(type, stack) / (float)maxWill) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public ItemStack fillDemonWillGem(ItemStack soulGemStack, ItemStack soulStack) {
        if (soulStack != null && soulStack.func_77973_b() instanceof IDemonWill) {
            EnumDemonWillType thisType = this.getCurrentType(soulGemStack);
            if (thisType != ((IDemonWill)soulStack.func_77973_b()).getType(soulStack)) {
                return soulStack;
            }
            IDemonWill soul = (IDemonWill)soulStack.func_77973_b();
            double soulsLeft = this.getWill(thisType, soulGemStack);
            if (soulsLeft < (double)this.getMaxWill(thisType, soulGemStack)) {
                double newSoulsLeft = Math.min(soulsLeft + soul.getWill(thisType, soulStack), (double)this.getMaxWill(thisType, soulGemStack));
                soul.drainWill(thisType, soulStack, newSoulsLeft - soulsLeft);
                this.setWill(thisType, soulGemStack, newSoulsLeft);
                if (soul.getWill(thisType, soulStack) <= 0.0) {
                    return ItemStack.field_190927_a;
                }
            }
        }
        return soulStack;
    }

    @Override
    public double getWill(EnumDemonWillType type, ItemStack soulGemStack) {
        if (!type.equals((Object)this.getCurrentType(soulGemStack))) {
            return 0.0;
        }
        CompoundNBT tag = soulGemStack.func_77978_p();
        return tag.func_74769_h("souls");
    }

    @Override
    public void setWill(EnumDemonWillType type, ItemStack soulGemStack, double souls) {
        this.setCurrentType(type, soulGemStack);
        CompoundNBT tag = soulGemStack.func_77978_p();
        tag.func_74780_a("souls", souls);
    }

    @Override
    public double drainWill(EnumDemonWillType type, ItemStack soulGemStack, double drainAmount, boolean doDrain) {
        EnumDemonWillType currentType = this.getCurrentType(soulGemStack);
        if (currentType != type) {
            return 0.0;
        }
        double souls = this.getWill(type, soulGemStack);
        double soulsDrained = Math.min(drainAmount, souls);
        if (doDrain) {
            this.setWill(type, soulGemStack, souls - soulsDrained);
        }
        return soulsDrained;
    }

    @Override
    public int getMaxWill(EnumDemonWillType type, ItemStack soulGemStack) {
        EnumDemonWillType currentType = this.getCurrentType(soulGemStack);
        if (!type.equals((Object)currentType) && currentType != EnumDemonWillType.DEFAULT) {
            return 0;
        }
        return this.maxWill;
    }

    @Override
    public EnumDemonWillType getCurrentType(ItemStack soulGemStack) {
        NBTHelper.checkNBT(soulGemStack);
        CompoundNBT tag = soulGemStack.func_77978_p();
        if (!tag.func_74764_b("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf(tag.func_74779_i("demonWillType").toUpperCase(Locale.ROOT));
    }

    public void setCurrentType(EnumDemonWillType type, ItemStack soulGemStack) {
        NBTHelper.checkNBT(soulGemStack);
        CompoundNBT tag = soulGemStack.func_77978_p();
        if (type == EnumDemonWillType.DEFAULT) {
            if (tag.func_74764_b("demonWillType")) {
                tag.func_82580_o("demonWillType");
            }
            return;
        }
        tag.func_74778_a("demonWillType", type.toString());
    }

    @Override
    public double fillWill(EnumDemonWillType type, ItemStack stack, double fillAmount, boolean doFill) {
        if (!type.equals((Object)this.getCurrentType(stack)) && this.getWill(this.getCurrentType(stack), stack) > 0.0) {
            return 0.0;
        }
        double current = this.getWill(type, stack);
        double maxWill = this.getMaxWill(type, stack);
        double filled = Math.min(fillAmount, maxWill - current);
        if (doFill) {
            this.setWill(type, stack, filled + current);
        }
        return filled;
    }
}

