/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.util.ISlotHelper;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;
import wayoftime.bloodmagic.impl.BloodMagicAPI;

public class CuriosCompat {
    public void setupSlots(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.NECKLACE.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("living_armour_socket").size(0).icon(BloodMagic.rl("item/curios_empty_living_armour_socket")).build());
    }

    public void registerInventory() {
        BloodMagicAPI.INSTANCE.registerInventoryProvider("curiosInventory", player -> this.getCuriosInventory((PlayerEntity)player));
    }

    public NonNullList<ItemStack> getCuriosInventory(PlayerEntity player) {
        IItemHandler itemHandler = (IItemHandler)CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).resolve().get();
        NonNullList inventory = NonNullList.func_191196_a();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            inventory.add((Object)itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public int recalculateCuriosSlots(PlayerEntity player) {
        ISlotHelper slotHelper = CuriosApi.getSlotHelper();
        if (LivingUtil.hasFullSet(player)) {
            int curiosLevel;
            LivingStats stats = LivingStats.fromPlayer(player);
            int n = curiosLevel = stats != null ? stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_CURIOS_SOCKET.get())).getKey()) : 0;
            if (curiosLevel == 0) {
                slotHelper.setSlotsForType("living_armour_socket", (LivingEntity)player, 0);
            } else {
                int slotCount = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_CURIOS_SOCKET.get())).getBonusValue("slots", curiosLevel).intValue();
                slotHelper.setSlotsForType("living_armour_socket", (LivingEntity)player, slotCount);
            }
            return curiosLevel;
        }
        slotHelper.setSlotsForType("living_armour_socket", (LivingEntity)player, 0);
        return 0;
    }
}

