/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.arc;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.tags.BloodMagicTags;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ARCFurnaceRecipeCategory
implements IRecipeCategory<FurnaceRecipe> {
    private static final int OUTPUT_SLOT = 0;
    private static final int INPUT_SLOT = 1;
    private static final int CATALYST_SLOT = 2;
    public static final ResourceLocation UID = BloodMagic.rl("arcfurnace");
    public static final ResourceLocation BACKGROUNDRL = BloodMagic.rl("gui/jei/arc.png");
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public ARCFurnaceRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get()));
        this.background = guiHelper.createDrawable(BACKGROUNDRL, 0, 0, 157, 43);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return TextHelper.localize("jei.bloodmagic.recipe.arcfurnace", new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull FurnaceRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        recipeLayout.getItemStacks().init(0, false, 53, 16);
        recipeLayout.getItemStacks().init(1, true, 0, 5);
        recipeLayout.getItemStacks().init(2, true, 21, 16);
        guiItemStacks.set(ingredients);
    }

    public Class<? extends FurnaceRecipe> getRecipeClass() {
        return FurnaceRecipe.class;
    }

    public void setIngredients(FurnaceRecipe recipe, IIngredients ingredients) {
        NonNullList inputIngList = recipe.func_192400_c();
        inputIngList.add(Ingredient.func_199805_a(BloodMagicTags.ARC_TOOL_FURNACE));
        ingredients.setInputIngredients((List)inputIngList);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void draw(FurnaceRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        FluidStack outputStack = FluidStack.EMPTY;
        ClientHandler.handleGuiTank(matrixStack, outputStack, outputStack.getAmount(), 140, 7, 16, 36, 157, 6, 18, 38, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), null);
        FluidStack inputStack = FluidStack.EMPTY;
        ClientHandler.handleGuiTank(matrixStack, inputStack, inputStack.getAmount(), 1, 26, 16, 16, 175, 26, 18, 18, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), null);
    }
}

