/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.arc;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.util.handler.event.ClientHandler;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ARCRecipeCategory
implements IRecipeCategory<RecipeARC> {
    private static final int OUTPUT_SLOT = 0;
    private static final int INPUT_SLOT = 4;
    private static final int CATALYST_SLOT = 5;
    public static final ResourceLocation UID = BloodMagic.rl("arc");
    public static final ResourceLocation BACKGROUNDRL = BloodMagic.rl("gui/jei/arc.png");
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public ARCRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get()));
        this.background = guiHelper.createDrawable(BACKGROUNDRL, 0, 0, 157, 43);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return TextHelper.localize("jei.bloodmagic.recipe.arc", new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipeARC recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        recipeLayout.getItemStacks().init(0, false, 53, 16);
        recipeLayout.getItemStacks().init(1, false, 75, 16);
        recipeLayout.getItemStacks().init(2, false, 97, 16);
        recipeLayout.getItemStacks().init(3, false, 119, 16);
        recipeLayout.getItemStacks().init(4, true, 0, 5);
        recipeLayout.getItemStacks().init(5, true, 21, 16);
        guiItemStacks.set(ingredients);
    }

    public Class<? extends RecipeARC> getRecipeClass() {
        return RecipeARC.class;
    }

    public void setIngredients(RecipeARC recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getAllListedOutputs());
    }

    public void draw(RecipeARC recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        double[] chanceArray = recipe.getAllOutputChances();
        String[] infoString = new String[chanceArray.length];
        for (int i = 0; i < infoString.length; ++i) {
            infoString[i] = chanceArray[i] >= 1.0 ? "" : (chanceArray[i] < 0.01 ? "<1%" : "" + (int)(chanceArray[i] * 100.0) + "%");
            mc.field_71466_p.func_238405_a_(matrixStack, infoString[i], (float)(86 + 22 * i - mc.field_71466_p.func_78256_a(infoString[i]) / 2), 5.0f, Color.white.getRGB());
        }
        FluidStack outputStack = recipe.getFluidOutput();
        ClientHandler.handleGuiTank(matrixStack, outputStack, outputStack.getAmount(), 140, 7, 16, 36, 157, 6, 18, 38, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), null);
        if (recipe.getFluidIngredient() != null) {
            List inputFluids = recipe.getFluidIngredient().getRepresentations();
            FluidStack inputStack = (FluidStack)inputFluids.get(0);
            ClientHandler.handleGuiTank(matrixStack, inputStack, inputStack.getAmount(), 1, 26, 16, 16, 175, 26, 18, 18, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), null);
        }
    }

    public List<ITextComponent> getTooltipStrings(RecipeARC recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        FluidStack outputStack = recipe.getFluidOutput();
        if (!outputStack.isEmpty()) {
            ClientHandler.handleGuiTank(null, outputStack, -1, 140, 8, 16, 34, 157, 7, 18, 36, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), tooltip);
        }
        if (recipe.getFluidIngredient() != null) {
            List inputFluids = recipe.getFluidIngredient().getRepresentations();
            FluidStack inputStack = (FluidStack)inputFluids.get(0);
            ClientHandler.handleGuiTank(null, inputStack, -1, 1, 26, 16, 16, 175, 26, 18, 18, (int)mouseX, (int)mouseY, BACKGROUNDRL.toString(), tooltip);
        }
        return tooltip;
    }
}

