/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.entity.projectile;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.common.block.BlockShapedExplosive;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.registries.BloodMagicEntityTypes;
import wayoftime.bloodmagic.tile.TileExplosiveCharge;

public class EntityShapedCharge
extends ThrowableEntity {
    private static final DataParameter<Optional<BlockState>> ITEMSTACK_DATA = EntityDataManager.func_187226_a(EntityShapedCharge.class, (IDataSerializer)DataSerializers.field_187197_g);
    private AnointmentHolder holder;

    public EntityShapedCharge(EntityType<EntityShapedCharge> p_i50159_1_, World p_i50159_2_) {
        super(p_i50159_1_, p_i50159_2_);
    }

    public EntityShapedCharge(World worldIn, Block block, LivingEntity throwerIn) {
        super(BloodMagicEntityTypes.SHAPED_CHARGE.getEntityType(), throwerIn, worldIn);
        this.setFallTile(block.func_176223_P());
    }

    public EntityShapedCharge(World worldIn, Block block, double x, double y, double z) {
        super(BloodMagicEntityTypes.SHAPED_CHARGE.getEntityType(), x, y, z, worldIn);
        this.setFallTile(block.func_176223_P());
    }

    public void setAnointmentHolder(AnointmentHolder holder) {
        this.holder = holder;
    }

    public void setFallTile(BlockState state) {
        this.field_70180_af.func_187227_b(ITEMSTACK_DATA, Optional.of(state));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, x$0 -> this.func_230298_a_((Entity)x$0));
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction faceHit = ((BlockRayTraceResult)raytraceresult).func_216354_b();
            BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a().func_177972_a(((BlockRayTraceResult)raytraceresult).func_216354_b());
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            Material material = blockstate.func_185904_a();
            BlockState fallTile = this.getBlockState();
            if (blockstate.func_196958_f() || blockstate.func_235714_a_((ITag)BlockTags.field_232872_am_) || material.func_76224_d() || material.func_76222_j()) {
                this.func_130014_f_().func_175656_a(blockpos, (BlockState)fallTile.func_206870_a(BlockShapedExplosive.ATTACHED, (Comparable)faceHit));
                TileEntity tile = this.func_130014_f_().func_175625_s(blockpos);
                if (tile instanceof TileExplosiveCharge) {
                    ((TileExplosiveCharge)tile).setAnointmentHolder(this.holder);
                }
                this.func_241204_bJ_();
            } else {
                this.func_199703_a((IItemProvider)fallTile.func_177230_c());
                this.func_241204_bJ_();
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.getBlockState()));
        if (this.holder != null) {
            compound.func_218657_a("holder", (INBT)this.holder.serialize());
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        BlockState fallTile = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockState"));
        this.setFallTile(fallTile);
        if (compound.func_74764_b("holder")) {
            this.holder = AnointmentHolder.fromNBT(compound.func_74775_l("holder"));
        }
        if (fallTile.func_196958_f()) {
            fallTile = ((Block)BloodMagicBlocks.SHAPED_CHARGE.get()).func_176223_P();
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ITEMSTACK_DATA, Optional.of(Blocks.field_150354_m.func_176223_P()));
    }

    public BlockState getBlockState() {
        return (BlockState)((Optional)this.field_70180_af.func_187225_a(ITEMSTACK_DATA)).get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public World getWorldObj() {
        return this.field_70170_p;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

