/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.loot;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.core.AnointmentRegistrar;

public class GlobalLootModifier {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"bloodmagic");
    public static final RegistryObject<SilkTouchTestModifier.Serializer> SILKTOUCH = GLM.register("silk_touch_bamboo", () -> new SilkTouchTestModifier.Serializer());
    public static final RegistryObject<FortuneModifier.Serializer> FORTUNE = GLM.register("fortune", () -> new FortuneModifier.Serializer());
    public static final RegistryObject<LootingModifier.Serializer> LOOTING = GLM.register("looting", () -> new LootingModifier.Serializer());
    public static final RegistryObject<SmeltingModifier.Serializer> SMELT = GLM.register("smelt", () -> new SmeltingModifier.Serializer());

    private static class SmeltingModifier
    extends LootModifier {
        public SmeltingModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack ctxTool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (ctxTool.func_77978_p() == null) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null) {
                return generatedLoot;
            }
            int smeltingLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_SMELTING.get()));
            if (smeltingLevel <= 0) {
                return generatedLoot;
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            generatedLoot.forEach(stack -> ret.add(SmeltingModifier.smelt(stack, context)));
            return ret;
        }

        private static ItemStack smelt(ItemStack stack, LootContext context) {
            return context.func_202879_g().func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), (World)context.func_202879_g()).map(AbstractCookingRecipe::func_77571_b).filter(itemStack -> !itemStack.func_190926_b()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.func_190916_E() * itemStack.func_190916_E()))).orElse(stack);
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<SmeltingModifier> {
            private Serializer() {
            }

            public SmeltingModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
                return new SmeltingModifier(conditionsIn);
            }

            public JsonObject write(SmeltingModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    private static class LootingModifier
    extends LootModifier {
        public LootingModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            return generatedLoot;
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<LootingModifier> {
            private Serializer() {
            }

            public LootingModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
                return new LootingModifier(conditionsIn);
            }

            public JsonObject write(LootingModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    private static class FortuneModifier
    extends LootModifier {
        public FortuneModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack ctxTool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (ctxTool.func_77978_p() != null && ctxTool.func_77978_p().func_74767_n("bloodmagic:checked_fortune")) {
                return generatedLoot;
            }
            if (EnchantmentHelper.func_82781_a((ItemStack)ctxTool).containsKey(Enchantments.field_185306_r)) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null) {
                return generatedLoot;
            }
            int additionalFortune = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_FORTUNE.get()));
            if (additionalFortune <= 0) {
                return generatedLoot;
            }
            ItemStack fakeTool = ctxTool.func_77946_l();
            fakeTool.func_196082_o().func_74757_a("bloodmagic:checked_fortune", true);
            int baseFortuneLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)ctxTool);
            fakeTool.func_77966_a(Enchantments.field_185308_t, baseFortuneLevel + additionalFortune);
            LootContext.Builder builder = new LootContext.Builder(context);
            builder.func_216015_a(LootParameters.field_216289_i, (Object)fakeTool);
            LootContext ctx = builder.func_216022_a(LootParameterSets.field_216267_h);
            LootTable loottable = context.func_202879_g().func_73046_m().func_200249_aQ().func_186521_a(((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c().func_220068_i());
            return loottable.func_216113_a(ctx);
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<FortuneModifier> {
            private Serializer() {
            }

            public FortuneModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
                return new FortuneModifier(conditionsIn);
            }

            public JsonObject write(FortuneModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    private static class SilkTouchTestModifier
    extends LootModifier {
        public SilkTouchTestModifier(ILootCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack ctxTool = (ItemStack)context.func_216031_c(LootParameters.field_216289_i);
            if (EnchantmentHelper.func_82781_a((ItemStack)ctxTool).containsKey(Enchantments.field_185306_r)) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null || holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_SILK_TOUCH.get())) <= 0) {
                return generatedLoot;
            }
            ItemStack fakeTool = ctxTool.func_77946_l();
            fakeTool.func_77966_a(Enchantments.field_185306_r, 1);
            LootContext.Builder builder = new LootContext.Builder(context);
            builder.func_216015_a(LootParameters.field_216289_i, (Object)fakeTool);
            LootContext ctx = builder.func_216022_a(LootParameterSets.field_216267_h);
            LootTable loottable = context.func_202879_g().func_73046_m().func_200249_aQ().func_186521_a(((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c().func_220068_i());
            return loottable.func_216113_a(ctx);
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<SilkTouchTestModifier> {
            private Serializer() {
            }

            public SilkTouchTestModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
                return new SilkTouchTestModifier(conditionsIn);
            }

            public JsonObject write(SilkTouchTestModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }
}

