/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import wayoftime.bloodmagic.tile.TileAlchemicalReactionChamber;

public class ARCTanksPacket {
    private BlockPos pos;
    private CompoundNBT inputNBT;
    private CompoundNBT outputNBT;

    public ARCTanksPacket() {
        this.pos = BlockPos.field_177992_a;
        this.inputNBT = new CompoundNBT();
        this.outputNBT = new CompoundNBT();
    }

    public ARCTanksPacket(TileAlchemicalReactionChamber tile) {
        this(tile.func_174877_v(), tile.inputTank.writeToNBT(new CompoundNBT()), tile.outputTank.writeToNBT(new CompoundNBT()));
    }

    public ARCTanksPacket(BlockPos pos, CompoundNBT inputNBT, CompoundNBT outputNBT) {
        this.pos = pos;
        this.inputNBT = inputNBT;
        this.outputNBT = outputNBT;
    }

    public static void encode(ARCTanksPacket pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.func_150786_a(pkt.inputNBT);
        buf.func_150786_a(pkt.outputNBT);
    }

    public static ARCTanksPacket decode(PacketBuffer buf) {
        ARCTanksPacket pkt = new ARCTanksPacket(buf.func_179259_c(), buf.func_150793_b(), buf.func_150793_b());
        return pkt;
    }

    public static void handle(ARCTanksPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ARCTanksPacket.updateTanks(message.pos, message.inputNBT, message.outputNBT));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateTanks(BlockPos pos, CompoundNBT inputNBT, CompoundNBT outputNBT) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAlchemicalReactionChamber) {
            ((TileAlchemicalReactionChamber)tile).inputTank.readFromNBT(inputNBT);
            ((TileAlchemicalReactionChamber)tile).outputTank.readFromNBT(outputNBT);
        }
    }
}

