/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import wayoftime.bloodmagic.tile.TileAlchemyTable;

public class AlchemyTableButtonPacket {
    private BlockPos pos;
    private int slot;
    private Direction dir;
    private boolean enable;

    public AlchemyTableButtonPacket() {
        this(BlockPos.field_177992_a, 0, Direction.DOWN, true);
    }

    public AlchemyTableButtonPacket(BlockPos pos, int slot, Direction dir, boolean enable) {
        this.pos = pos;
        this.slot = slot;
        this.dir = dir;
        this.enable = enable;
    }

    public static void encode(AlchemyTableButtonPacket pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.writeInt(pkt.slot);
        buf.writeInt(pkt.dir.ordinal());
        buf.writeBoolean(pkt.enable);
    }

    public static AlchemyTableButtonPacket decode(PacketBuffer buf) {
        AlchemyTableButtonPacket pkt = new AlchemyTableButtonPacket(buf.func_179259_c(), buf.readInt(), Direction.func_82600_a((int)buf.readInt()), buf.readBoolean());
        return pkt;
    }

    public static void handle(AlchemyTableButtonPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            TileEntity tile = player.func_130014_f_().func_175625_s(message.pos);
            if (tile instanceof TileAlchemyTable) {
                ((TileAlchemyTable)tile).setSlotEnabled(message.enable, message.slot, message.dir);
            }
        });
        context.get().setPacketHandled(true);
    }
}

