/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;

public class RouterFilterPacket {
    private int slot;
    private int ghostSlot;
    private int amount;

    public RouterFilterPacket() {
    }

    public RouterFilterPacket(int slot, int ghostSlot, int amount) {
        this.slot = slot;
        this.ghostSlot = ghostSlot;
        this.amount = amount;
    }

    public static void encode(RouterFilterPacket pkt, PacketBuffer buf) {
        buf.writeInt(pkt.slot);
        buf.writeInt(pkt.ghostSlot);
        buf.writeInt(pkt.amount);
    }

    public static RouterFilterPacket decode(PacketBuffer buf) {
        RouterFilterPacket pkt = new RouterFilterPacket(buf.readInt(), buf.readInt(), buf.readInt());
        return pkt;
    }

    public static void handle(RouterFilterPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> RouterFilterPacket.sendKeyToServer(message, (PlayerEntity)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    public static void sendKeyToServer(RouterFilterPacket msg, PlayerEntity playerEntity) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (msg.slot > -1 && msg.slot < 9) {
            itemStack = playerEntity.field_71071_by.func_70301_a(msg.slot);
        }
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof IItemFilterProvider) {
            ((IItemFilterProvider)itemStack.func_77973_b()).setGhostItemAmount(itemStack, msg.ghostSlot, msg.amount);
        }
    }
}

