/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.DamageSourceBloodMagic;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.will.DemonWillHolder;

@RitualRegister(value="lava")
public class RitualLava
extends Ritual {
    public static final String LAVA_RANGE = "lavaRange";
    public static final String FIRE_FUSE_RANGE = "fireFuse";
    public static final String FIRE_RESIST_RANGE = "fireResist";
    public static final String FIRE_DAMAGE_RANGE = "fireDamage";
    public static final String LAVA_TANK_RANGE = "lavaTank";
    public static final double vengefulWillDrain = 1.0;
    public static final double steadfastWillDrain = 0.5;
    public static final double corrosiveWillDrain = 0.2;
    public static final int corrosiveRefreshTime = 20;
    public int timer = 0;

    public RitualLava() {
        super("ritualLava", 0, 10000, "ritual.bloodmagic.lavaRitual");
        this.addBlockRange(LAVA_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.addBlockRange(FIRE_FUSE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, -2, -2), 5));
        this.addBlockRange(FIRE_RESIST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1));
        this.addBlockRange(FIRE_DAMAGE_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1));
        this.addBlockRange(LAVA_TANK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(LAVA_RANGE, 9, 3, 3);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_FUSE_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_RESIST_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(FIRE_DAMAGE_RANGE, 0, 10, 10);
        this.setMaximumVolumeAndDistanceOfRange(LAVA_TANK_RANGE, 1, 10, 10);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        List entities;
        AreaDescriptor resistRange;
        ++this.timer;
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        int lpDrain = 0;
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double rawDrained = 0.0;
        DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(world, pos);
        AreaDescriptor lavaRange = masterRitualStone.getBlockRange(LAVA_RANGE);
        int maxLavaVolume = this.getMaxVolumeForRange(LAVA_RANGE, willConfig, holder);
        if (!lavaRange.isWithinRange(this.getMaxVerticalRadiusForRange(LAVA_RANGE, willConfig, holder), this.getMaxHorizontalRadiusForRange(LAVA_RANGE, willConfig, holder)) || maxLavaVolume != 0 && lavaRange.getVolume() > maxLavaVolume) {
            return;
        }
        for (BlockPos newPos : lavaRange.getContainedPositions(pos)) {
            BlockState state = world.func_180495_p(newPos);
            if (!world.func_175623_d(newPos) && !Utils.isFlowingLiquid(world, newPos, state)) continue;
            int lpCost = this.getLPCostForRawWill(rawWill);
            if (currentEssence < lpCost) break;
            world.func_175656_a(newPos, Blocks.field_150353_l.func_176223_P());
            currentEssence -= lpCost;
            lpDrain += lpCost;
            if (!(rawWill > 0.0)) continue;
            double drain = this.getWillCostForRawWill(rawWill);
            rawWill -= drain;
            rawDrained += drain;
        }
        if (rawWill > 0.0) {
            LazyOptional capability;
            AreaDescriptor chestRange = masterRitualStone.getBlockRange(LAVA_TANK_RANGE);
            TileEntity tile = world.func_175625_s(chestRange.getContainedPositions(pos).get(0));
            double drain = this.getWillCostForRawWill(rawWill);
            int lpCost = this.getLPCostForRawWill(rawWill);
            if (rawWill >= drain && currentEssence >= lpCost && tile != null && (capability = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).isPresent()) {
                IFluidHandler handler = (IFluidHandler)capability.resolve().get();
                double filled = handler.fill(new FluidStack((Fluid)Fluids.field_204547_b, 1000), IFluidHandler.FluidAction.EXECUTE);
                double ratio = filled / 1000.0;
                rawWill -= drain * ratio;
                rawDrained += drain * ratio;
                currentEssence = (int)((double)currentEssence - Math.ceil((double)lpCost * ratio));
                lpDrain = (int)((double)lpDrain + Math.ceil((double)lpCost * ratio));
            }
        }
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        if (vengefulWill >= 1.0) {
            double vengefulDrained = 0.0;
            AreaDescriptor fuseRange = masterRitualStone.getBlockRange(FIRE_FUSE_RANGE);
            AxisAlignedBB fuseArea = fuseRange.getAABB(pos);
            List entities2 = world.func_217357_a(LivingEntity.class, fuseArea);
            for (LivingEntity entity : entities2) {
                if (vengefulWill < 1.0) break;
                if (entity instanceof PlayerEntity || entity.func_70644_a(BloodMagicPotions.FIRE_FUSE)) continue;
                entity.func_195064_c(new EffectInstance(BloodMagicPotions.FIRE_FUSE, 100, 0));
                vengefulDrained += 1.0;
                vengefulWill -= 1.0;
            }
            if (vengefulDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrained, true);
            }
        }
        if (steadfastWill >= 0.5) {
            double steadfastDrained = 0.0;
            resistRange = masterRitualStone.getBlockRange(FIRE_RESIST_RANGE);
            int duration = this.getFireResistForWill(steadfastWill);
            AxisAlignedBB resistArea = resistRange.getAABB(pos);
            entities = world.func_217357_a(PlayerEntity.class, resistArea);
            for (PlayerEntity entity : entities) {
                if (steadfastWill < 0.5) break;
                if (entity.func_70644_a(Effects.field_76426_n) && entity.func_70660_b(Effects.field_76426_n).func_76459_b() >= 2) continue;
                entity.func_195064_c(new EffectInstance(Effects.field_76426_n, 100, 0));
                steadfastDrained += 0.5;
                steadfastWill -= 0.5;
            }
            if (steadfastDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastDrained, true);
            }
        }
        if (this.timer % 20 == 0 && corrosiveWill >= 0.2) {
            double corrosiveDrained = 0.0;
            resistRange = masterRitualStone.getBlockRange(FIRE_DAMAGE_RANGE);
            float damage = this.getCorrosiveDamageForWill(corrosiveWill);
            AxisAlignedBB damageArea = resistRange.getAABB(pos);
            entities = world.func_217357_a(LivingEntity.class, damageArea);
            for (PlayerEntity entity : entities) {
                if (corrosiveWill < 0.2) break;
                if (entity.func_70089_S() || entity.field_70737_aN > 0 || !Utils.isImmuneToFireDamage((LivingEntity)entity) || !entity.func_70097_a((DamageSource)DamageSourceBloodMagic.INSTANCE, damage)) continue;
                corrosiveDrained += 0.2;
                corrosiveWill -= 0.2;
            }
            if (corrosiveDrained > 0.0) {
                WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveDrained, true);
            }
        }
        if (rawDrained > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrained, true);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(lpDrain));
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 500;
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(PlayerEntity player) {
        return new ITextComponent[]{new TranslationTextComponent(this.getTranslationKey() + ".info"), new TranslationTextComponent(this.getTranslationKey() + ".default.info"), new TranslationTextComponent(this.getTranslationKey() + ".corrosive.info"), new TranslationTextComponent(this.getTranslationKey() + ".steadfast.info"), new TranslationTextComponent(this.getTranslationKey() + ".destructive.info"), new TranslationTextComponent(this.getTranslationKey() + ".vengeful.info")};
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 0, EnumRuneType.FIRE);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualLava();
    }

    @Override
    public int getMaxVolumeForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return 9 + (int)Math.pow(destructiveWill / 10.0, 1.5);
        }
        return (Integer)this.volumeRangeMap.get(range);
    }

    @Override
    public int getMaxVerticalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(3.0 + destructiveWill / 10.0);
        }
        return (Integer)this.verticalRangeMap.get(range);
    }

    @Override
    public int getMaxHorizontalRadiusForRange(String range, List<EnumDemonWillType> activeTypes, DemonWillHolder holder) {
        double destructiveWill;
        if (LAVA_RANGE.equals(range) && activeTypes.contains((Object)EnumDemonWillType.DESTRUCTIVE) && (destructiveWill = holder.getWill(EnumDemonWillType.DESTRUCTIVE)) > 0.0) {
            return (int)(3.0 + destructiveWill / 10.0);
        }
        return (Integer)this.horizontalRangeMap.get(range);
    }

    public int getFireResistForWill(double steadfastWill) {
        return (int)(200.0 + steadfastWill * 3.0);
    }

    public float getCorrosiveDamageForWill(double corrosiveWill) {
        return (float)(1.0 + corrosiveWill * 0.05);
    }

    public int getLPCostForRawWill(double raw) {
        return Math.max((int)(500.0 - raw), 0);
    }

    public double getWillCostForRawWill(double raw) {
        return Math.min(1.0, raw / 500.0);
    }
}

