/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import com.mojang.authlib.GameProfile;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="placer")
public class RitualPlacer
extends Ritual {
    public static final String PLACER_RANGE = "placerRange";
    public static final String CHEST_RANGE = "chest";
    private static FakePlayer fakePlayer = null;

    public RitualPlacer() {
        super("ritualPlacer", 0, 5000, "ritual.bloodmagic.placerRitual");
        this.addBlockRange(PLACER_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 0, -2), 5, 1, 5));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(PLACER_RANGE, 300, 7, 7);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        TileEntity tileEntity = world.func_175625_s(chestRange.getContainedPositions(masterPos).get(0));
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor areaDescriptor = masterRitualStone.getBlockRange(PLACER_RANGE);
        if (tileEntity != null) {
            IItemHandler itemHandler = Utils.getInventory(tileEntity, null);
            if (itemHandler.getSlots() <= 0) {
                return;
            }
            block0: for (BlockPos blockPos : areaDescriptor.getContainedPositions(masterRitualStone.getMasterBlockPos())) {
                BlockItemUseContext ctx = new BlockItemUseContext(world, (PlayerEntity)this.getFakePlayer((ServerWorld)world), Hand.MAIN_HAND, ItemStack.field_190927_a, BlockRayTraceResult.func_216352_a((Vector3d)new Vector3d(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)blockPos));
                if (!world.func_180495_p(blockPos).func_196953_a(ctx)) continue;
                for (int invSlot = 0; invSlot < itemHandler.getSlots(); ++invSlot) {
                    ActionResultType result;
                    ItemStack stack = itemHandler.extractItem(invSlot, 1, true);
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof BlockItem) || !(result = ((BlockItem)stack.func_77973_b()).func_195942_a(ctx)).func_226246_a_()) continue;
                    itemHandler.extractItem(invSlot, 1, false);
                    tileEntity.func_70296_d();
                    masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                    break block0;
                }
            }
        }
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public int getRefreshTime() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 3, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, 2, EnumRuneType.WATER);
        this.addRune(components, 3, 0, -2, EnumRuneType.WATER);
        this.addRune(components, 2, 0, 3, EnumRuneType.WATER);
        this.addRune(components, 2, 0, -3, EnumRuneType.WATER);
        this.addRune(components, -2, 0, 3, EnumRuneType.WATER);
        this.addRune(components, -2, 0, -3, EnumRuneType.WATER);
        this.addRune(components, -3, 0, 2, EnumRuneType.WATER);
        this.addRune(components, -3, 0, -2, EnumRuneType.WATER);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualPlacer();
    }

    private FakePlayer getFakePlayer(ServerWorld world) {
        return fakePlayer == null ? (fakePlayer = FakePlayerFactory.get((ServerWorld)world, (GameProfile)new GameProfile(null, "bloodmagic_ritual_filling"))) : fakePlayer;
    }
}

