/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.network.SetClientVelocityPacket;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="speed")
public class RitualSpeed
extends Ritual {
    public static final String SPEED_RANGE = "sanicRange";
    public static final double vengefulWillDrain = 0.05;
    public static final double destructiveWillDrain = 0.05;
    public static final double rawWillDrain = 0.1;
    public static final double steadfastWillDrain = 0.05;
    public static final double corrosiveWillDrain = 0.05;

    public RitualSpeed() {
        super("ritualSpeed", 0, 1000, "ritual.bloodmagic.speedRitual");
        this.addBlockRange(SPEED_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 1, -2), new BlockPos(3, 5, 3)));
        this.setMaximumVolumeAndDistanceOfRange(SPEED_RANGE, 0, 4, 5);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        AreaDescriptor speedRange = masterRitualStone.getBlockRange(SPEED_RANGE);
        double vengefulDrain = 0.0;
        double destructiveDrain = 0.0;
        double rawDrain = 0.0;
        double steadfastDrain = 0.0;
        double corrosiveDrain = 0.0;
        if (rawWill < 0.1) {
            rawWill = 0.0;
        }
        if (corrosiveWill < 0.05) {
            corrosiveWill = 0.0;
        }
        for (LivingEntity entity : world.func_217357_a(LivingEntity.class, speedRange.getAABB(masterRitualStone.getMasterBlockPos()))) {
            boolean transportAdults;
            if (entity.func_225608_bj_()) continue;
            boolean transportChildren = destructiveWill < 0.05;
            boolean bl = transportAdults = vengefulWill < 0.05;
            if (entity.func_70631_g_() && !transportChildren || !entity.func_70631_g_() && !transportAdults || entity instanceof PlayerEntity && transportChildren ^ transportAdults) continue;
            if (!transportChildren) {
                destructiveWill -= 0.05;
                destructiveDrain += 0.05;
            }
            if (!transportAdults) {
                vengefulWill -= 0.05;
                vengefulDrain += 0.05;
            }
            double motionY = this.getVerticalSpeedForWill(rawWill);
            double speed = this.getHorizontalSpeedForWill(rawWill);
            Direction direction = masterRitualStone.getDirection();
            if (rawWill >= 0.1) {
                rawWill -= 0.1;
                rawDrain += 0.1;
            }
            if (corrosiveWill >= 0.05) {
                corrosiveDrain += 0.05;
                speed += this.getAdditionalHorizontalSpeedForWill(corrosiveWill -= 0.05);
            }
            Vector3d motion = entity.func_213322_ci();
            double motionX = motion.func_82615_a();
            double motionZ = motion.func_82616_c();
            entity.field_70143_R = 0.0f;
            switch (direction) {
                case NORTH: {
                    motionX = 0.0;
                    motionZ = -speed;
                    break;
                }
                case SOUTH: {
                    motionX = 0.0;
                    motionZ = speed;
                    break;
                }
                case WEST: {
                    motionX = -speed;
                    motionZ = 0.0;
                    break;
                }
                case EAST: {
                    motionX = speed;
                    motionZ = 0.0;
                    break;
                }
            }
            if (steadfastWill >= 0.05) {
                entity.func_195064_c(new EffectInstance(BloodMagicPotions.SOFT_FALL, 100, 0));
                steadfastWill -= 0.05;
                steadfastDrain += 0.05;
            }
            entity.func_213293_j(motionX, motionY, motionZ);
            if (!(entity instanceof ServerPlayerEntity)) continue;
            BloodMagic.packetHandler.sendTo(new SetClientVelocityPacket(motionX, motionY, motionZ), (ServerPlayerEntity)entity);
        }
        if (rawDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrain, true);
        }
        if (vengefulDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrain, true);
        }
        if (destructiveDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveDrain, true);
        }
        if (steadfastDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastDrain, true);
        }
        if (corrosiveDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveDrain, true);
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, 0, -2, EnumRuneType.DUSK);
        this.addRune(components, 1, 0, -1, EnumRuneType.AIR);
        this.addRune(components, -1, 0, -1, EnumRuneType.AIR);
        for (int i = 0; i < 3; ++i) {
            this.addRune(components, 2, 0, i, EnumRuneType.AIR);
            this.addRune(components, -2, 0, i, EnumRuneType.AIR);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualSpeed();
    }

    @Override
    public ITextComponent[] provideInformationOfRitualToPlayer(PlayerEntity player) {
        return new ITextComponent[]{new TranslationTextComponent(this.getTranslationKey() + ".info"), new TranslationTextComponent(this.getTranslationKey() + ".default.info"), new TranslationTextComponent(this.getTranslationKey() + ".corrosive.info"), new TranslationTextComponent(this.getTranslationKey() + ".steadfast.info"), new TranslationTextComponent(this.getTranslationKey() + ".destructive.info"), new TranslationTextComponent(this.getTranslationKey() + ".vengeful.info")};
    }

    public double getVerticalSpeedForWill(double rawWill) {
        return 1.2 + rawWill / 200.0;
    }

    public double getHorizontalSpeedForWill(double rawWill) {
        return 3.0 + rawWill / 40.0;
    }

    public double getAdditionalHorizontalSpeedForWill(double corrosiveWill) {
        return corrosiveWill / 40.0;
    }
}

