/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.altar.AltarTier;
import wayoftime.bloodmagic.altar.BloodAltar;
import wayoftime.bloodmagic.altar.IBloodAltar;
import wayoftime.bloodmagic.common.block.BlockAltar;
import wayoftime.bloodmagic.tile.TileInventory;

public class TileAltar
extends TileInventory
implements IBloodAltar,
ITickableTileEntity {
    @ObjectHolder(value="bloodmagic:altar")
    public static TileEntityType<TileAltar> TYPE;
    private BloodAltar bloodAltar = new BloodAltar(this);
    private LazyOptional fluidOptional;
    private boolean isOutputOn = false;

    public TileAltar(TileEntityType<?> type) {
        super(type, 1, "altar");
    }

    public TileAltar() {
        this(TYPE);
    }

    public boolean getOutputState() {
        return this.isOutputOn;
    }

    public void setOutputState(boolean state) {
        BlockAltar altar = (BlockAltar)this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c();
        this.isOutputOn = state;
        this.field_145850_b.func_195593_d(this.field_174879_c, (Block)altar);
    }

    @Override
    public void deserialize(CompoundNBT tagCompound) {
        super.deserialize(tagCompound);
        CompoundNBT altarTag = tagCompound.func_74775_l("bloodAltar");
        this.bloodAltar.readFromNBT(altarTag);
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tagCompound) {
        super.serialize(tagCompound);
        CompoundNBT altarTag = new CompoundNBT();
        this.bloodAltar.writeToNBT(altarTag);
        tagCompound.func_218657_a("bloodAltar", (INBT)altarTag);
        return tagCompound;
    }

    public void func_73660_a() {
        this.bloodAltar.update();
    }

    @Override
    public void sacrificialDaggerCall(int amount, boolean isSacrifice) {
        this.bloodAltar.sacrificialDaggerCall(amount, isSacrifice);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0;
    }

    @Override
    public int getCapacity() {
        return this.bloodAltar.getCapacity();
    }

    @Override
    public int getCurrentBlood() {
        return this.bloodAltar.getCurrentBlood();
    }

    @Override
    public int getTier() {
        return this.bloodAltar.getTier().toInt();
    }

    @Override
    public int getProgress() {
        return this.bloodAltar.getProgress();
    }

    @Override
    public float getSacrificeMultiplier() {
        return this.bloodAltar.getSacrificeMultiplier();
    }

    @Override
    public float getSelfSacrificeMultiplier() {
        return this.bloodAltar.getSelfSacrificeMultiplier();
    }

    @Override
    public float getOrbMultiplier() {
        return this.bloodAltar.getOrbMultiplier();
    }

    @Override
    public float getDislocationMultiplier() {
        return this.bloodAltar.getDislocationMultiplier();
    }

    @Override
    public float getConsumptionMultiplier() {
        return this.bloodAltar.getConsumptionMultiplier();
    }

    @Override
    public float getConsumptionRate() {
        return this.bloodAltar.getConsumptionRate();
    }

    @Override
    public int getLiquidRequired() {
        return this.bloodAltar.getLiquidRequired();
    }

    @Override
    public int getBufferCapacity() {
        return this.bloodAltar.getBufferCapacity();
    }

    @Override
    public void startCycle() {
        this.bloodAltar.startCycle();
    }

    @Override
    public void checkTier() {
        this.bloodAltar.checkTier();
    }

    @Override
    public void requestPauseAfterCrafting(int cooldown) {
        this.bloodAltar.requestPauseAfterCrafting(cooldown);
    }

    @Override
    public boolean isActive() {
        return this.bloodAltar.isActive();
    }

    @Override
    public int fillMainTank(int amount) {
        return this.bloodAltar.fillMainTank(amount);
    }

    @Override
    public void setActive() {
        this.bloodAltar.setActive();
    }

    @Override
    public int getChargingRate() {
        return this.bloodAltar.getChargingRate();
    }

    @Override
    public int getTotalCharge() {
        return this.bloodAltar.getTotalCharge();
    }

    @Override
    public int getChargingFrequency() {
        return this.bloodAltar.getChargingFrequency();
    }

    public AltarTier getCurrentTierDisplayed() {
        return this.bloodAltar.getCurrentTierDisplayed();
    }

    public boolean setCurrentTierDisplayed(AltarTier altarTier) {
        return this.bloodAltar.setCurrentTierDisplayed(altarTier);
    }

    public int getAnalogSignalStrength(int redstoneMode) {
        return this.bloodAltar.getAnalogSignalStrength(redstoneMode);
    }

    @Override
    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidOptional != null) {
            this.fluidOptional.invalidate();
            this.fluidOptional = null;
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (this.fluidOptional == null) {
                this.fluidOptional = LazyOptional.of(() -> new BloodAltar.VariableSizeFluidHandler(this.bloodAltar));
            }
            return this.fluidOptional.cast();
        }
        return super.getCapability(capability, facing);
    }
}

