/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.ItemActivationCrystal;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.event.RitualEvent;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumReaderBoundaries;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.tile.base.TileTicking;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.BindableHelper;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.util.helper.RitualHelper;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class TileMasterRitualStone
extends TileTicking
implements IMasterRitualStone {
    @ObjectHolder(value="bloodmagic:masterritualstone")
    public static TileEntityType<TileMasterRitualStone> TYPE;
    protected final Map<String, AreaDescriptor> modableRangeMap = new HashMap<String, AreaDescriptor>();
    private UUID owner;
    private SoulNetwork cachedNetwork;
    private boolean active;
    private boolean redstoned;
    private int activeTime;
    private int cooldown;
    private Ritual currentRitual;
    private Direction direction = Direction.NORTH;
    private boolean inverted;
    private List<EnumDemonWillType> currentActiveWillConfig = new ArrayList<EnumDemonWillType>();

    public TileMasterRitualStone(TileEntityType<?> type) {
        super(type);
    }

    public TileMasterRitualStone() {
        this(TYPE);
    }

    @Override
    public void onUpdate() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.isPowered() && this.isActive()) {
            this.active = false;
            this.redstoned = true;
            this.stopRitual(Ritual.BreakType.REDSTONE);
            return;
        }
        if (!this.isActive() && !this.isPowered() && this.isRedstoned() && this.getCurrentRitual() != null) {
            this.active = true;
            ItemStack crystalStack = NBTHelper.checkNBT(ItemActivationCrystal.CrystalType.getStack(this.getCurrentRitual().getCrystalLevel()));
            BindableHelper.applyBinding(crystalStack, new Binding(this.owner, PlayerHelper.getUsernameFromUUID(this.owner)));
            this.activateRitual(crystalStack, null, this.getCurrentRitual());
            this.redstoned = false;
        }
        if (this.getCurrentRitual() != null && this.isActive()) {
            if (this.activeTime % this.getCurrentRitual().getRefreshTime() == 0) {
                this.performRitual(this.func_145831_w(), this.func_174877_v());
            }
            ++this.activeTime;
        }
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        UUID uUID = this.owner = tag.func_186855_b("owner") ? tag.func_186857_a("owner") : null;
        if (this.owner != null) {
            this.cachedNetwork = NetworkHelper.getSoulNetwork(this.owner);
        }
        this.currentRitual = BloodMagic.RITUAL_MANAGER.getRitual(tag.func_74779_i("currentRitual"));
        if (this.currentRitual != null) {
            CompoundNBT ritualTag = tag.func_74775_l("currentRitualTag");
            if (!ritualTag.isEmpty()) {
                this.currentRitual.readFromNBT(ritualTag);
            }
            this.addBlockRanges(this.currentRitual.getModableRangeMap());
            for (Map.Entry<String, AreaDescriptor> entry : this.modableRangeMap.entrySet()) {
                CompoundNBT descriptorTag = ritualTag.func_74775_l(entry.getKey());
                entry.getValue().readFromNBT(descriptorTag);
            }
        }
        this.active = tag.func_74767_n("isRunning");
        this.activeTime = tag.func_74762_e("runtime");
        this.direction = Direction.values()[tag.func_74762_e("direction")];
        this.redstoned = tag.func_74767_n("isStoned");
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            if (!tag.func_74767_n("EnumWill" + (Object)((Object)type))) continue;
            this.currentActiveWillConfig.add(type);
        }
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        String ritualId = BloodMagic.RITUAL_MANAGER.getId(this.getCurrentRitual());
        if (this.owner != null) {
            tag.func_186854_a("owner", this.owner);
        }
        tag.func_74778_a("currentRitual", Strings.isNullOrEmpty((String)ritualId) ? "" : ritualId);
        if (this.currentRitual != null) {
            CompoundNBT ritualTag = new CompoundNBT();
            this.currentRitual.writeToNBT(ritualTag);
            for (Map.Entry<String, AreaDescriptor> entry : this.modableRangeMap.entrySet()) {
                CompoundNBT descriptorTag = new CompoundNBT();
                entry.getValue().writeToNBT(descriptorTag);
                ritualTag.func_218657_a(entry.getKey(), (INBT)descriptorTag);
            }
            tag.func_218657_a("currentRitualTag", (INBT)ritualTag);
        }
        tag.func_74757_a("isRunning", this.isActive());
        tag.func_74768_a("runtime", this.getActiveTime());
        tag.func_74768_a("direction", this.direction.func_176745_a());
        tag.func_74757_a("isStoned", this.redstoned);
        for (EnumDemonWillType type : this.currentActiveWillConfig) {
            tag.func_74757_a("EnumWill" + (Object)((Object)type), true);
        }
        return tag;
    }

    @Override
    public boolean activateRitual(ItemStack activationCrystal, @Nullable PlayerEntity activator, Ritual ritual) {
        if (PlayerHelper.isFakePlayer(activator)) {
            return false;
        }
        Binding binding = ((IBindable)activationCrystal.func_77973_b()).getBinding(activationCrystal);
        if (binding != null && ritual != null) {
            int crystalLevel;
            if (activationCrystal.func_77973_b() instanceof ItemActivationCrystal && RitualHelper.canCrystalActivate(ritual, crystalLevel = ((ItemActivationCrystal)activationCrystal.func_77973_b()).getCrystalLevel(activationCrystal))) {
                if (!this.func_145831_w().field_72995_K) {
                    RitualEvent.RitualActivatedEvent event;
                    SoulNetwork network = NetworkHelper.getSoulNetwork(binding);
                    if (!this.isRedstoned() && network.getCurrentEssence() < ritual.getActivationCost() && activator != null && !activator.func_184812_l_()) {
                        activator.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.ritual.weak"), true);
                        return false;
                    }
                    if (this.currentRitual != null) {
                        this.currentRitual.stopRitual(this, Ritual.BreakType.ACTIVATE);
                    }
                    if (MinecraftForge.EVENT_BUS.post((Event)(event = new RitualEvent.RitualActivatedEvent(this, binding.getOwnerId(), ritual, activator, activationCrystal, crystalLevel)))) {
                        if (activator != null) {
                            activator.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.ritual.prevent"), true);
                        }
                        return false;
                    }
                    if (ritual.activateRitual(this, activator, binding.getOwnerId())) {
                        if (!this.isRedstoned() && activator != null && !activator.func_184812_l_()) {
                            network.syphon(this.ticket(ritual.getActivationCost()));
                        }
                        if (activator != null) {
                            activator.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.ritual.activate"), true);
                        }
                        this.active = true;
                        this.owner = binding.getOwnerId();
                        this.cachedNetwork = network;
                        this.currentRitual = ritual;
                        if (!this.checkBlockRanges(ritual.getModableRangeMap())) {
                            this.addBlockRanges(ritual.getModableRangeMap());
                        }
                        this.notifyUpdate();
                        return true;
                    }
                }
                this.notifyUpdate();
                return true;
            }
        } else if (activator != null) {
            activator.func_146105_b((ITextComponent)new TranslationTextComponent("chat.bloodmagic.ritual.notValid"), true);
        }
        return false;
    }

    @Override
    public void performRitual(World world, BlockPos pos) {
        if (!world.field_72995_K && this.getCurrentRitual() != null && BloodMagic.RITUAL_MANAGER.enabled(BloodMagic.RITUAL_MANAGER.getId(this.currentRitual), false)) {
            if (RitualHelper.checkValidRitual(this.func_145831_w(), this.func_174877_v(), this.currentRitual, this.getDirection())) {
                Ritual ritual = this.getCurrentRitual();
                RitualEvent.RitualRunEvent event = new RitualEvent.RitualRunEvent(this, this.getOwner(), ritual);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                if (!this.checkBlockRanges(this.getCurrentRitual().getModableRangeMap())) {
                    this.addBlockRanges(this.getCurrentRitual().getModableRangeMap());
                }
                this.getCurrentRitual().performRitual(this);
            } else {
                this.stopRitual(Ritual.BreakType.BREAK_STONE);
            }
        }
    }

    @Override
    public void stopRitual(Ritual.BreakType breakType) {
        if (!this.func_145831_w().field_72995_K && this.getCurrentRitual() != null) {
            RitualEvent.RitualStopEvent event = new RitualEvent.RitualStopEvent((IMasterRitualStone)this, this.getOwner(), this.getCurrentRitual(), breakType);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            this.getCurrentRitual().stopRitual(this, breakType);
            if (breakType != Ritual.BreakType.REDSTONE) {
                this.currentRitual = null;
                this.active = false;
                this.activeTime = 0;
            }
            this.notifyUpdate();
        }
    }

    @Override
    public int getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public boolean areTanksEmpty() {
        return false;
    }

    @Override
    public int getRunningTime() {
        return this.activeTime;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public SoulNetwork getOwnerNetwork() {
        return this.cachedNetwork;
    }

    public World func_145831_w() {
        return super.func_145831_w();
    }

    public BlockPos func_174877_v() {
        return super.func_174877_v();
    }

    @Override
    public World getWorldObj() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getMasterBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public String getNextBlockRange(String range) {
        if (this.currentRitual != null) {
            return this.currentRitual.getNextBlockRange(range);
        }
        return "";
    }

    @Override
    public void provideInformationOfRitualToPlayer(PlayerEntity player) {
        if (this.currentRitual != null) {
            ChatUtil.sendNoSpam(player, this.currentRitual.provideInformationOfRitualToPlayer(player));
        }
    }

    @Override
    public void provideInformationOfRangeToPlayer(PlayerEntity player, String range) {
        if (this.currentRitual != null && this.currentRitual.getListOfRanges().contains(range)) {
            ChatUtil.sendNoSpam(player, this.currentRitual.provideInformationOfRangeToPlayer(player, range));
        }
    }

    @Override
    public void setActiveWillConfig(PlayerEntity player, List<EnumDemonWillType> typeList) {
        this.currentActiveWillConfig = typeList;
    }

    @Override
    public EnumReaderBoundaries setBlockRangeByBounds(PlayerEntity player, String range, BlockPos offset1, BlockPos offset2) {
        DemonWillHolder holder;
        AreaDescriptor descriptor = this.getBlockRange(range);
        EnumReaderBoundaries modificationType = this.currentRitual.canBlockRangeBeModified(range, descriptor, this, offset1, offset2, holder = WorldDemonWillHandler.getWillHolder(this.field_145850_b, this.getMasterBlockPos()));
        if (modificationType == EnumReaderBoundaries.SUCCESS) {
            descriptor.modifyAreaByBlockPositions(offset1, offset2);
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        return modificationType;
    }

    @Override
    public List<EnumDemonWillType> getActiveWillConfig() {
        return new ArrayList<EnumDemonWillType>(this.currentActiveWillConfig);
    }

    @Override
    public void provideInformationOfWillConfigToPlayer(PlayerEntity player, List<EnumDemonWillType> typeList) {
        if (typeList.size() >= 1) {
            int i;
            Object[] translations = new TranslationTextComponent[typeList.size()];
            StringBuilder constructedString = new StringBuilder("%s");
            for (i = 1; i < typeList.size(); ++i) {
                constructedString.append(", %s");
            }
            for (i = 0; i < typeList.size(); ++i) {
                translations[i] = new TranslationTextComponent("tooltip.bloodmagic.currentBaseType." + typeList.get((int)i).name.toLowerCase(Locale.ROOT));
            }
            ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("ritual.bloodmagic.willConfig.set", new Object[]{new TranslationTextComponent(constructedString.toString(), translations)})});
        } else {
            ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent("ritual.bloodmagic.willConfig.void")});
        }
    }

    public boolean isPowered() {
        if (this.inverted) {
            return !this.func_145831_w().func_175640_z(this.func_174877_v());
        }
        return this.func_145831_w().func_175640_z(this.func_174877_v());
    }

    public SoulNetwork getCachedNetwork() {
        return this.cachedNetwork;
    }

    public void setCachedNetwork(SoulNetwork cachedNetwork) {
        this.cachedNetwork = cachedNetwork;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isRedstoned() {
        return this.redstoned;
    }

    public void setRedstoned(boolean redstoned) {
        this.redstoned = redstoned;
    }

    public int getActiveTime() {
        return this.activeTime;
    }

    public void setActiveTime(int activeTime) {
        this.activeTime = activeTime;
    }

    @Override
    public Ritual getCurrentRitual() {
        return this.currentRitual;
    }

    public void setCurrentRitual(Ritual currentRitual) {
        this.currentRitual = currentRitual;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public List<EnumDemonWillType> getCurrentActiveWillConfig() {
        return this.currentActiveWillConfig;
    }

    public void setCurrentActiveWillConfig(List<EnumDemonWillType> currentActiveWillConfig) {
        this.currentActiveWillConfig = currentActiveWillConfig;
    }

    @Override
    public AreaDescriptor getBlockRange(String range) {
        if (this.modableRangeMap.containsKey(range)) {
            return this.modableRangeMap.get(range);
        }
        return null;
    }

    @Override
    public void addBlockRange(String range, AreaDescriptor defaultRange) {
        this.modableRangeMap.putIfAbsent(range, defaultRange.copy());
    }

    @Override
    public void addBlockRanges(Map<String, AreaDescriptor> blockRanges) {
        for (Map.Entry<String, AreaDescriptor> entry : blockRanges.entrySet()) {
            this.modableRangeMap.putIfAbsent(entry.getKey(), entry.getValue().copy());
        }
    }

    @Override
    public void setBlockRange(String range, AreaDescriptor defaultRange) {
        this.modableRangeMap.put(range, defaultRange.copy());
    }

    @Override
    public void setBlockRanges(Map<String, AreaDescriptor> blockRanges) {
        for (Map.Entry<String, AreaDescriptor> entry : blockRanges.entrySet()) {
            this.modableRangeMap.put(entry.getKey(), entry.getValue().copy());
        }
    }

    public boolean checkBlockRanges(Map<String, AreaDescriptor> blockRanges) {
        for (Map.Entry<String, AreaDescriptor> entry : blockRanges.entrySet()) {
            if (this.modableRangeMap.get(entry.getKey()) != null) continue;
            return false;
        }
        return true;
    }
}

