/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.common.block.BlockShapedExplosive;
import wayoftime.bloodmagic.tile.TileExplosiveCharge;

public class TileShapedExplosive
extends TileExplosiveCharge {
    @ObjectHolder(value="bloodmagic:shaped_explosive")
    public static TileEntityType<TileShapedExplosive> TYPE;
    public double internalCounter = 0.0;
    public int explosionRadius;
    public int explosionDepth;

    public TileShapedExplosive(TileEntityType<?> type, int explosionRadius, int explosionDepth) {
        super(type);
        this.explosionRadius = explosionRadius;
        this.explosionDepth = explosionDepth;
    }

    public TileShapedExplosive() {
        this(TYPE, 2, 5);
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.internalCounter += 1.0;
        if (this.internalCounter == 20.0) {
            this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f);
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197631_x, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 5, 0.02, 0.03, 0.02, 0.0);
        }
        if (this.internalCounter == 30.0) {
            this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (this.internalCounter < 30.0) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextDouble() < 0.3) {
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.internalCounter == 100.0) {
            this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            Direction explosiveDirection = ((Direction)this.func_195044_w().func_177229_b(BlockShapedExplosive.ATTACHED)).func_176734_d();
            Direction sweepDir1 = Direction.UP;
            Direction sweepDir2 = Direction.UP;
            int numParticles = this.explosionDepth * (this.explosionRadius + 1);
            ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197627_t, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)(explosiveDirection.func_82601_c() * this.explosionDepth) / 2.0, (double)this.field_174879_c.func_177956_o() + 0.5 + (double)(explosiveDirection.func_96559_d() * this.explosionDepth) / 2.0, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)(explosiveDirection.func_82599_e() * this.explosionDepth) / 2.0, numParticles, 1.0, 1.0, 1.0, 0.0);
            switch (explosiveDirection) {
                case UP: 
                case DOWN: {
                    sweepDir1 = Direction.NORTH;
                    sweepDir2 = Direction.EAST;
                    break;
                }
                case EAST: 
                case WEST: {
                    sweepDir1 = Direction.NORTH;
                    sweepDir2 = Direction.UP;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    sweepDir1 = Direction.EAST;
                    sweepDir2 = Direction.UP;
                }
            }
            ItemStack toolStack = this.getHarvestingTool();
            ObjectArrayList objectarraylist = new ObjectArrayList();
            BlockPos initialPos = this.func_174877_v();
            for (int i = 1; i <= this.explosionDepth; ++i) {
                for (int j = -this.explosionRadius; j <= this.explosionRadius; ++j) {
                    for (int k = -this.explosionRadius; k <= this.explosionRadius; ++k) {
                        BlockPos blockpos = initialPos.func_177967_a(explosiveDirection, i).func_177967_a(sweepDir1, j).func_177967_a(sweepDir2, k);
                        BlockState blockstate = this.field_145850_b.func_180495_p(blockpos);
                        Block block = blockstate.func_177230_c();
                        if (blockstate.isAir((IBlockReader)this.field_145850_b, blockpos) || blockstate.func_185887_b((IBlockReader)this.field_145850_b, blockpos) == -1.0f) continue;
                        BlockPos blockpos1 = blockpos.func_185334_h();
                        if (!(this.field_145850_b instanceof ServerWorld)) continue;
                        TileEntity tileentity = blockstate.hasTileEntity() ? this.field_145850_b.func_175625_s(blockpos) : null;
                        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216023_a(this.field_145850_b.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)blockpos)).func_216015_a(LootParameters.field_216289_i, (Object)toolStack).func_216021_b(LootParameters.field_216288_h, (Object)tileentity);
                        blockstate.func_215693_a(lootcontext$builder).forEach(stack -> TileShapedExplosive.handleExplosionDrops((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, stack, blockpos1));
                        this.field_145850_b.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 3);
                    }
                }
            }
            for (Pair pair : objectarraylist) {
                Block.func_180635_a((World)this.field_145850_b, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
            this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
        }
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.internalCounter = tag.func_74769_h("internalCounter");
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        super.serialize(tag);
        tag.func_74780_a("internalCounter", this.internalCounter);
        return tag;
    }
}

